/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.test.reports;

import io.specmatic.core.ReportConfiguration;
import io.specmatic.core.SpecmaticConfig;
import io.specmatic.core.SuccessCriteria;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.test.reports.OpenApiCoverageReportProcessor;
import io.specmatic.test.reports.ReportProcessor;
import io.specmatic.test.reports.coverage.OpenApiCoverageReportInput;
import io.specmatic.test.reports.coverage.console.OpenAPICoverageConsoleReport;
import io.specmatic.test.reports.coverage.json.OpenApiCoverageJsonReport;
import io.specmatic.test.reports.renderers.ReportRenderer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001c\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\r0\f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/specmatic/test/reports/OpenApiCoverageReportProcessor;", "Lio/specmatic/test/reports/ReportProcessor;", "Lio/specmatic/test/reports/coverage/console/OpenAPICoverageConsoleReport;", "openApiCoverageReportInput", "Lio/specmatic/test/reports/coverage/OpenApiCoverageReportInput;", "(Lio/specmatic/test/reports/coverage/OpenApiCoverageReportInput;)V", "assertSuccessCriteria", "", "reportConfiguration", "Lio/specmatic/core/ReportConfiguration;", "report", "configureReportRenderers", "", "Lio/specmatic/test/reports/renderers/ReportRenderer;", "excludedEndpointsFromEnv", "", "process", "specmaticConfig", "Lio/specmatic/core/SpecmaticConfig;", "saveAsJson", "openApiCoverageJsonReport", "Lio/specmatic/test/reports/coverage/json/OpenApiCoverageJsonReport;", "Companion", "junit5-support"})
@SourceDebugExtension(value={"SMAP\nOpenApiCoverageReportProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenApiCoverageReportProcessor.kt\nio/specmatic/test/reports/OpenApiCoverageReportProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,98:1\n1855#2,2:99\n1549#2:101\n1620#2,3:102\n113#3:105\n*S KotlinDebug\n*F\n+ 1 OpenApiCoverageReportProcessor.kt\nio/specmatic/test/reports/OpenApiCoverageReportProcessor\n*L\n34#1:99,2\n53#1:101\n53#1:102,3\n61#1:105\n*E\n"})
public final class OpenApiCoverageReportProcessor
implements ReportProcessor<OpenAPICoverageConsoleReport> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OpenApiCoverageReportInput openApiCoverageReportInput;
    @NotNull
    public static final String JSON_REPORT_PATH = "./build/reports/specmatic";
    @NotNull
    public static final String JSON_REPORT_FILE_NAME = "coverage_report.json";

    public OpenApiCoverageReportProcessor(@NotNull OpenApiCoverageReportInput openApiCoverageReportInput) {
        Intrinsics.checkNotNullParameter((Object)openApiCoverageReportInput, (String)"openApiCoverageReportInput");
        this.openApiCoverageReportInput = openApiCoverageReportInput;
    }

    @Override
    public void process(@NotNull SpecmaticConfig specmaticConfig) {
        Intrinsics.checkNotNullParameter((Object)specmaticConfig, (String)"specmaticConfig");
        ReportConfiguration reportConfiguration = specmaticConfig.getReport();
        Intrinsics.checkNotNull((Object)reportConfiguration);
        ReportConfiguration reportConfiguration2 = reportConfiguration;
        this.openApiCoverageReportInput.addExcludedAPIs(CollectionsKt.plus((Collection)reportConfiguration2.excludedOpenAPIEndpoints(), (Iterable)this.excludedEndpointsFromEnv()));
        OpenAPICoverageConsoleReport openAPICoverageReport = this.openApiCoverageReportInput.generate();
        if (openAPICoverageReport.getCoverageRows().isEmpty()) {
            LoggingKt.getLogger().log("The Open API coverage report generated is blank.\nThis can happen if your open api specification does not have any paths documented.");
        } else {
            List<ReportRenderer<OpenAPICoverageConsoleReport>> renderers = this.configureReportRenderers(reportConfiguration2);
            Iterable $this$forEach$iv = renderers;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ReportRenderer renderer = (ReportRenderer)element$iv;
                boolean bl = false;
                LoggingKt.getLogger().log(renderer.render(openAPICoverageReport, specmaticConfig));
            }
            this.saveAsJson(this.openApiCoverageReportInput.generateJsonReport());
        }
        this.assertSuccessCriteria(reportConfiguration2, openAPICoverageReport);
    }

    @Override
    @NotNull
    public List<ReportRenderer<OpenAPICoverageConsoleReport>> configureReportRenderers(@NotNull ReportConfiguration reportConfiguration) {
        Intrinsics.checkNotNullParameter((Object)reportConfiguration, (String)"reportConfiguration");
        return reportConfiguration.mapRenderers((Function1)configureReportRenderers.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> excludedEndpointsFromEnv() {
        List list;
        String string = System.getenv("SPECMATIC_EXCLUDED_ENDPOINTS");
        if (string != null) {
            void $this$mapTo$iv$iv;
            String excludedEndpoints = string;
            boolean bl = false;
            String[] stringArray = new String[]{","};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)excludedEndpoints, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final void saveAsJson(OpenApiCoverageJsonReport openApiCoverageJsonReport) {
        System.out.println((Object)"Saving Coverage Report json to ./build/reports/specmatic ...");
        Json json2 = JsonKt.Json$default(null, (Function1)saveAsJson.json.1.INSTANCE, (int)1, null);
        StringFormat $this$encodeToString$iv = (StringFormat)json2;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String reportJson = $this$encodeToString$iv.encodeToString((SerializationStrategy)OpenApiCoverageJsonReport.Companion.serializer(), (Object)openApiCoverageJsonReport);
        File directory = new File(JSON_REPORT_PATH);
        directory.mkdirs();
        File file = new File(directory, JSON_REPORT_FILE_NAME);
        FilesKt.writeText$default((File)file, (String)reportJson, null, (int)2, null);
    }

    @Override
    public void assertSuccessCriteria(@NotNull ReportConfiguration reportConfiguration, @NotNull OpenAPICoverageConsoleReport report2) {
        Intrinsics.checkNotNullParameter((Object)reportConfiguration, (String)"reportConfiguration");
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        SuccessCriteria successCriteria = reportConfiguration.getSuccessCriteria();
        if (successCriteria.getEnforceOrDefault()) {
            boolean coverageReportSuccessCriteriaMet;
            String coverageThresholdNotMetMessage = "Total API coverage: " + report2.getTotalCoveragePercentage() + "% is less than the specified minimum threshold of " + successCriteria.getMinThresholdPercentageOrDefault() + "%. ";
            String missedEndpointsCountExceededMessage = "Total missed endpoints count: " + report2.getMissedEndpointsCount() + " is greater than the maximum threshold of " + successCriteria.getMaxMissedEndpointsInSpecOrDefault() + ".\n(Note: Specmatic will consider an endpoint as 'covered' only if it is documented in the open api spec with at least one example for each operation and response code.\nIf it is present in the spec, but does not have an example, Specmatic will still report the particular operation and response code as 'missing in spec'.)";
            boolean minCoverageThresholdCriteriaMet = report2.getTotalCoveragePercentage() >= successCriteria.getMinThresholdPercentageOrDefault();
            boolean maxMissingEndpointsExceededCriteriaMet = report2.getMissedEndpointsCount() <= successCriteria.getMaxMissedEndpointsInSpecOrDefault();
            boolean bl = coverageReportSuccessCriteriaMet = minCoverageThresholdCriteriaMet && maxMissingEndpointsExceededCriteriaMet;
            if (!coverageReportSuccessCriteriaMet) {
                LoggingKt.getLogger().newLine();
                LoggingKt.getLogger().log("Failed the following API Coverage Report success criteria:");
                if (!minCoverageThresholdCriteriaMet) {
                    LoggingKt.getLogger().log(coverageThresholdNotMetMessage);
                }
                if (!maxMissingEndpointsExceededCriteriaMet) {
                    LoggingKt.getLogger().log(missedEndpointsCountExceededMessage);
                }
                LoggingKt.getLogger().newLine();
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)coverageReportSuccessCriteriaMet).withFailMessage("One or more API Coverage report's success criteria were not met.", new Object[0])).isTrue();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/specmatic/test/reports/OpenApiCoverageReportProcessor$Companion;", "", "()V", "JSON_REPORT_FILE_NAME", "", "JSON_REPORT_PATH", "junit5-support"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

