/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.test.reports.coverage.html;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.specmatic.core.ReportFormatter;
import io.specmatic.core.SuccessCriteria;
import io.specmatic.core.TestResult;
import io.specmatic.test.reports.coverage.html.HtmlReportData;
import io.specmatic.test.reports.coverage.html.HtmlReportInformation;
import io.specmatic.test.reports.coverage.html.HtmlResult;
import io.specmatic.test.reports.coverage.html.HtmlTemplateConfiguration;
import io.specmatic.test.reports.coverage.html.HtmlUtilsKt;
import io.specmatic.test.reports.coverage.html.ScenarioData;
import io.specmatic.test.reports.coverage.html.TableRow;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JJ\u0010\u0014\u001a\u00020\u00152@\u0010\u0016\u001a<\u0012\u0004\u0012\u00020\b\u0012.\u0012,\u0012\u0004\u0012\u00020\b\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00170\u00170\u00170\u0017j\u0002`\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0019H\u0002JJ\u0010\u001d\u001a\u00020\b2@\u0010\u001e\u001a<\u0012\u0004\u0012\u00020\b\u0012.\u0012,\u0012\u0004\u0012\u00020\b\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00170\u00170\u00170\u0017j\u0002`\u001aH\u0002J\u0006\u0010\u001f\u001a\u00020\u0015J\b\u0010 \u001a\u00020\bH\u0002J\b\u0010!\u001a\u00020\bH\u0002J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\b0#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u001cH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000eH\u0002J\b\u0010+\u001a\u00020)H\u0002J\u0084\u0001\u0010,\u001a<\u0012\u0004\u0012\u00020\b\u0012.\u0012,\u0012\u0004\u0012\u00020\b\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00170\u00170\u00170\u0017j\u0002`\u001a2@\u0010\u0016\u001a<\u0012\u0004\u0012\u00020\b\u0012.\u0012,\u0012\u0004\u0012\u00020\b\u0012\"\u0012 \u0012\u0004\u0012\u00020\b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00170\u00170\u00170\u0017j\u0002`\u001aH\u0002J\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020%0\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020%0\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lio/specmatic/test/reports/coverage/html/HtmlReport;", "", "htmlReportInformation", "Lio/specmatic/test/reports/coverage/html/HtmlReportInformation;", "(Lio/specmatic/test/reports/coverage/html/HtmlReportInformation;)V", "apiSuccessCriteria", "Lio/specmatic/core/SuccessCriteria;", "outputDirectory", "", "reportData", "Lio/specmatic/test/reports/coverage/html/HtmlReportData;", "reportFormat", "Lio/specmatic/core/ReportFormatter;", "totalErrors", "", "totalFailures", "totalMissing", "totalSkipped", "totalSuccess", "totalTests", "calculateTestGroupCounts", "", "scenarioData", "", "", "Lio/specmatic/test/reports/coverage/html/ScenarioData;", "Lio/specmatic/test/reports/renderers/GroupedScenarioData;", "categorizeResult", "Lio/specmatic/test/reports/coverage/html/HtmlResult;", "dumpTestData", "testData", "generate", "generateHtmlReportText", "generatedOnTimestamp", "getHtmlResultAndBadgeColor", "Lkotlin/Pair;", "tableRow", "Lio/specmatic/test/reports/coverage/html/TableRow;", "htmlResultToDetailPostFix", "htmlResult", "successCriteriaPassed", "", "totalCoveragePercentage", "testCriteriaPassed", "updateScenarioData", "updateTableRows", "tableRows", "junit5-support"})
@SourceDebugExtension(value={"SMAP\nHtmlReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlReport.kt\nio/specmatic/test/reports/coverage/html/HtmlReport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,263:1\n1#2:264\n1855#3,2:265\n1855#3,2:271\n1855#3,2:281\n1789#3,3:287\n1855#3,2:290\n215#4:267\n215#4:268\n215#4:269\n215#4:270\n216#4:273\n216#4:274\n216#4:275\n216#4:276\n215#4:277\n215#4:278\n215#4:279\n215#4:280\n216#4:283\n216#4:284\n216#4:285\n216#4:286\n*S KotlinDebug\n*F\n+ 1 HtmlReport.kt\nio/specmatic/test/reports/coverage/html/HtmlReport\n*L\n82#1:265,2\n96#1:271,2\n125#1:281,2\n154#1:287,3\n157#1:290,2\n92#1:267\n93#1:268\n94#1:269\n95#1:270\n95#1:273\n94#1:274\n93#1:275\n92#1:276\n121#1:277\n122#1:278\n123#1:279\n124#1:280\n124#1:283\n123#1:284\n122#1:285\n121#1:286\n*E\n"})
public final class HtmlReport {
    @NotNull
    private final HtmlReportInformation htmlReportInformation;
    @NotNull
    private final String outputDirectory;
    @NotNull
    private final SuccessCriteria apiSuccessCriteria;
    @NotNull
    private final ReportFormatter reportFormat;
    @NotNull
    private final HtmlReportData reportData;
    private int totalTests;
    private int totalErrors;
    private int totalFailures;
    private int totalSkipped;
    private int totalSuccess;
    private int totalMissing;

    public HtmlReport(@NotNull HtmlReportInformation htmlReportInformation) {
        Intrinsics.checkNotNullParameter((Object)htmlReportInformation, (String)"htmlReportInformation");
        this.htmlReportInformation = htmlReportInformation;
        this.outputDirectory = this.htmlReportInformation.getReportFormat().getOutputDirectoryOrDefault();
        this.apiSuccessCriteria = this.htmlReportInformation.getSuccessCriteria();
        this.reportFormat = this.htmlReportInformation.getReportFormat();
        this.reportData = this.htmlReportInformation.getReportData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate() {
        HtmlUtilsKt.createAssetsDir(this.outputDirectory);
        this.calculateTestGroupCounts(this.htmlReportInformation.getReportData().getScenarioData());
        File outFile = new File(this.outputDirectory, "index.html");
        String htmlText = this.generateHtmlReportText();
        if (!outFile.getParentFile().exists()) {
            outFile.mkdirs();
        }
        Object object = outFile;
        Object object2 = Charsets.UTF_8;
        object = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            OutputStreamWriter it = (OutputStreamWriter)object;
            boolean bl = false;
            it.write(htmlText);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String generateHtmlReportText() {
        void $this$generateHtmlReportText_u24lambda_u241;
        Context context;
        boolean testCriteria = this.testCriteriaPassed();
        boolean successCriteria = this.successCriteriaPassed(this.reportData.getTotalCoveragePercentage());
        Map<String, Map<String, Map<String, Map<String, List<ScenarioData>>>>> updatedScenarios = this.updateScenarioData(this.reportData.getScenarioData());
        List<TableRow> updatedTableRows = this.updateTableRows(this.reportData.getTableRows());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"lite", (Object)this.reportFormat.getLiteOrDefault()), TuplesKt.to((Object)"pageTitle", (Object)this.reportFormat.getTitleOrDefault()), TuplesKt.to((Object)"reportHeading", (Object)this.reportFormat.getHeadingOrDefault()), TuplesKt.to((Object)"logo", (Object)this.reportFormat.getLogoOrDefault()), TuplesKt.to((Object)"logoAltText", (Object)this.reportFormat.getLogoAltTextOrDefault()), TuplesKt.to((Object)"summaryResult", (Object)(testCriteria && successCriteria ? "approved" : "rejected")), TuplesKt.to((Object)"totalCoverage", (Object)this.reportData.getTotalCoveragePercentage()), TuplesKt.to((Object)"totalSuccess", (Object)this.totalSuccess), TuplesKt.to((Object)"totalFailures", (Object)this.totalFailures), TuplesKt.to((Object)"totalErrors", (Object)this.totalErrors), TuplesKt.to((Object)"totalSkipped", (Object)this.totalSkipped), TuplesKt.to((Object)"totalTests", (Object)this.totalTests), TuplesKt.to((Object)"totalDuration", (Object)this.reportData.getTotalTestDuration()), TuplesKt.to((Object)"actuatorEnabled", (Object)this.reportData.getActuatorEnabled()), TuplesKt.to((Object)"minimumCoverage", (Object)this.apiSuccessCriteria.getMinThresholdPercentageOrDefault()), TuplesKt.to((Object)"successCriteriaPassed", (Object)successCriteria), TuplesKt.to((Object)"testCriteriaPassed", (Object)testCriteria), TuplesKt.to((Object)"tableConfig", (Object)this.htmlReportInformation.getTableConfig()), TuplesKt.to((Object)"tableRows", updatedTableRows), TuplesKt.to((Object)"specmaticImplementation", (Object)this.htmlReportInformation.getSpecmaticImplementation()), TuplesKt.to((Object)"specmaticVersion", (Object)this.htmlReportInformation.getSpecmaticVersion()), TuplesKt.to((Object)"generatedOn", (Object)this.generatedOnTimestamp()), TuplesKt.to((Object)"isGherkinReport", (Object)this.htmlReportInformation.isGherkinReport()), TuplesKt.to((Object)"jsonTestData", (Object)this.dumpTestData(updatedScenarios))};
        Map templateVariables = MapsKt.mapOf((Pair[])pairArray);
        Context context2 = context = new Context();
        String string = "report";
        TemplateEngine templateEngine = HtmlTemplateConfiguration.Companion.configureTemplateEngine();
        boolean bl = false;
        $this$generateHtmlReportText_u24lambda_u241.setVariables(templateVariables);
        Unit unit = Unit.INSTANCE;
        String string2 = templateEngine.process(string, (IContext)context);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"process(...)");
        return string2;
    }

    private final List<TableRow> updateTableRows(List<TableRow> tableRows) {
        Iterable $this$forEach$iv = tableRows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TableRow it = (TableRow)element$iv;
            boolean bl = false;
            Pair<HtmlResult, String> pair = this.getHtmlResultAndBadgeColor(it);
            HtmlResult htmlResult = (HtmlResult)((Object)pair.component1());
            String badgeColor = (String)pair.component2();
            it.setHtmlResult(htmlResult);
            it.setBadgeColor(badgeColor);
        }
        return tableRows;
    }

    private final Map<String, Map<String, Map<String, Map<String, List<ScenarioData>>>>> updateScenarioData(Map<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> scenarioData) {
        Map<String, Map<String, Map<String, Map<String, List<ScenarioData>>>>> $this$forEach$iv = scenarioData;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> firstGroup;
            Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> element$iv;
            Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> entry = element$iv = iterator.next();
            boolean bl = false;
            Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> $this$forEach$iv2 = firstGroup = entry.getValue();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map<String, ? extends Map<String, ? extends List<ScenarioData>>> secondGroup;
                Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> element$iv2;
                Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> entry2 = element$iv2 = iterator2.next();
                boolean bl2 = false;
                Map<String, ? extends Map<String, ? extends List<ScenarioData>>> $this$forEach$iv3 = secondGroup = entry2.getValue();
                boolean $i$f$forEach3 = false;
                Iterator<Map.Entry<String, ? extends Map<String, ? extends List<ScenarioData>>>> iterator3 = $this$forEach$iv3.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map<String, ? extends List<ScenarioData>> thirdGroup;
                    Map.Entry<String, ? extends Map<String, ? extends List<ScenarioData>>> element$iv3;
                    Map.Entry<String, ? extends Map<String, ? extends List<ScenarioData>>> entry3 = element$iv3 = iterator3.next();
                    boolean bl3 = false;
                    Map<String, ? extends List<ScenarioData>> $this$forEach$iv4 = thirdGroup = entry3.getValue();
                    boolean $i$f$forEach4 = false;
                    Iterator<Map.Entry<String, ? extends List<ScenarioData>>> iterator4 = $this$forEach$iv4.entrySet().iterator();
                    while (iterator4.hasNext()) {
                        Map.Entry<String, ? extends List<ScenarioData>> element$iv4;
                        Map.Entry<String, ? extends List<ScenarioData>> entry4 = element$iv4 = iterator4.next();
                        boolean bl4 = false;
                        List<ScenarioData> scenariosList = entry4.getValue();
                        Iterable $this$forEach$iv5 = scenariosList;
                        boolean $i$f$forEach5 = false;
                        for (Object element$iv5 : $this$forEach$iv5) {
                            ScenarioData it = (ScenarioData)element$iv5;
                            boolean bl5 = false;
                            HtmlResult htmlResult = this.categorizeResult(it);
                            String scenarioDetail = it.getName() + " " + this.htmlResultToDetailPostFix(htmlResult);
                            it.setHtmlResult(htmlResult);
                            it.setDetails(StringsKt.isBlank((CharSequence)it.getDetails()) ? scenarioDetail : scenarioDetail + "\n" + it.getDetails());
                        }
                    }
                }
            }
        }
        return scenarioData;
    }

    private final boolean testCriteriaPassed() {
        return this.totalFailures == 0;
    }

    private final boolean successCriteriaPassed(int totalCoveragePercentage) {
        return totalCoveragePercentage >= this.apiSuccessCriteria.getMinThresholdPercentageOrDefault() || !this.apiSuccessCriteria.getEnforceOrDefault();
    }

    private final void calculateTestGroupCounts(Map<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> scenarioData) {
        Map<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> $this$forEach$iv = scenarioData;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> firstGroup;
            Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> element$iv;
            Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> entry = element$iv = iterator.next();
            boolean bl = false;
            Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> $this$forEach$iv2 = firstGroup = entry.getValue();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> iterator2 = $this$forEach$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map<String, ? extends Map<String, ? extends List<ScenarioData>>> secondGroup;
                Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> element$iv2;
                Map.Entry<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>> entry2 = element$iv2 = iterator2.next();
                boolean bl2 = false;
                Map<String, ? extends Map<String, ? extends List<ScenarioData>>> $this$forEach$iv3 = secondGroup = entry2.getValue();
                boolean $i$f$forEach3 = false;
                Iterator<Map.Entry<String, ? extends Map<String, ? extends List<ScenarioData>>>> iterator3 = $this$forEach$iv3.entrySet().iterator();
                while (iterator3.hasNext()) {
                    Map<String, ? extends List<ScenarioData>> thirdGroup;
                    Map.Entry<String, ? extends Map<String, ? extends List<ScenarioData>>> element$iv3;
                    Map.Entry<String, ? extends Map<String, ? extends List<ScenarioData>>> entry3 = element$iv3 = iterator3.next();
                    boolean bl3 = false;
                    Map<String, ? extends List<ScenarioData>> $this$forEach$iv4 = thirdGroup = entry3.getValue();
                    boolean $i$f$forEach4 = false;
                    Iterator<Map.Entry<String, ? extends List<ScenarioData>>> iterator4 = $this$forEach$iv4.entrySet().iterator();
                    while (iterator4.hasNext()) {
                        Map.Entry<String, ? extends List<ScenarioData>> element$iv4;
                        Map.Entry<String, ? extends List<ScenarioData>> entry4 = element$iv4 = iterator4.next();
                        boolean bl4 = false;
                        List<ScenarioData> scenariosList = entry4.getValue();
                        Iterable $this$forEach$iv5 = scenariosList;
                        boolean $i$f$forEach5 = false;
                        for (Object element$iv5 : $this$forEach$iv5) {
                            ScenarioData it = (ScenarioData)element$iv5;
                            boolean bl5 = false;
                            switch (WhenMappings.$EnumSwitchMapping$0[it.getTestResult().ordinal()]) {
                                case 1: {
                                    int n = this.totalMissing;
                                    this.totalMissing = n + 1;
                                    break;
                                }
                                case 2: {
                                    int n = this.totalSkipped;
                                    this.totalSkipped = n + 1;
                                    break;
                                }
                                case 3: {
                                    int n = this.totalSuccess;
                                    this.totalSuccess = n + 1;
                                    break;
                                }
                                case 4: {
                                    int n = this.totalErrors;
                                    this.totalErrors = n + 1;
                                    break;
                                }
                                default: {
                                    int n;
                                    if (it.getWip()) {
                                        n = this.totalErrors;
                                        this.totalErrors = n + 1;
                                        break;
                                    }
                                    n = this.totalFailures;
                                    this.totalFailures = n + 1;
                                }
                            }
                        }
                    }
                }
            }
        }
        this.totalTests = this.reportFormat.getLiteOrDefault() ? this.totalSuccess + this.totalFailures + this.totalErrors : this.totalSuccess + this.totalFailures + this.totalErrors + this.totalSkipped;
    }

    private final String generatedOnTimestamp() {
        LocalDateTime currentDateTime = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE, MMM dd yyyy h:mma", Locale.ENGLISH);
        String string = currentDateTime.format(formatter);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<HtmlResult, String> getHtmlResultAndBadgeColor(TableRow tableRow) {
        List list;
        List list2;
        Object object;
        Map<String, Map<String, List<ScenarioData>>> map;
        Map<String, Map<String, Map<String, List<ScenarioData>>>> map2 = this.reportData.getScenarioData().get(tableRow.getFirstGroupValue());
        if (map2 != null && (map = map2.get(tableRow.getSecondGroupValue())) != null && (object = map.values()) != null) {
            void $this$fold$iv;
            Iterable iterable = (Iterable)object;
            List initial$iv = CollectionsKt.emptyList();
            boolean $i$f$fold = false;
            List accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void rows;
                Map map3 = (Map)element$iv;
                List acc = accumulator$iv;
                boolean bl = false;
                Collection collection = acc;
                List list3 = (List)rows.get(tableRow.getResponse());
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                accumulator$iv = CollectionsKt.plus((Collection)collection, (Iterable)list3);
            }
            list2 = accumulator$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List scenarioList = list;
        Iterable $this$forEach$iv = scenarioList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScenarioData it = (ScenarioData)element$iv;
            boolean bl = false;
            if (!it.getValid()) {
                HtmlResult htmlResult = it.getHtmlResult();
                Intrinsics.checkNotNull((Object)((Object)htmlResult));
                return new Pair((Object)htmlResult, (Object)"red");
            }
            HtmlResult htmlResult = it.getHtmlResult();
            switch (htmlResult == null ? -1 : WhenMappings.$EnumSwitchMapping$1[htmlResult.ordinal()]) {
                case 1: {
                    return new Pair((Object)HtmlResult.Failed, (Object)"red");
                }
                case 2: {
                    return new Pair((Object)HtmlResult.Error, (Object)"yellow");
                }
                case 3: {
                    return new Pair((Object)HtmlResult.Skipped, (Object)"yellow");
                }
            }
        }
        return new Pair((Object)HtmlResult.Success, (Object)"green");
    }

    private final String htmlResultToDetailPostFix(HtmlResult htmlResult) {
        return switch (WhenMappings.$EnumSwitchMapping$1[htmlResult.ordinal()]) {
            case 3 -> "has been SKIPPED";
            case 2 -> "has ERROR-ED";
            case 4 -> "has SUCCEEDED";
            default -> "has FAILED";
        };
    }

    private final HtmlResult categorizeResult(ScenarioData scenarioData) {
        return switch (WhenMappings.$EnumSwitchMapping$0[scenarioData.getTestResult().ordinal()]) {
            case 3 -> HtmlResult.Success;
            case 2 -> HtmlResult.Skipped;
            case 4 -> HtmlResult.Error;
            default -> scenarioData.getWip() ? HtmlResult.Error : HtmlResult.Failed;
        };
    }

    private final String dumpTestData(Map<String, ? extends Map<String, ? extends Map<String, ? extends Map<String, ? extends List<ScenarioData>>>>> testData) {
        ObjectMapper mapper = new ObjectMapper();
        String json2 = mapper.writeValueAsString(testData);
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        String string = mapper.writeValueAsString(testData);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeValueAsString(...)");
        HtmlUtilsKt.writeToFileToAssets(this.outputDirectory, "test_data.json", string);
        Intrinsics.checkNotNull((Object)json2);
        return json2;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[TestResult.values().length];
            try {
                nArray[TestResult.MissingInSpec.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestResult.NotCovered.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestResult.Success.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestResult.Error.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HtmlResult.values().length];
            try {
                nArray[HtmlResult.Failed.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HtmlResult.Error.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HtmlResult.Skipped.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HtmlResult.Success.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

