/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.test.reports.coverage.html;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\"\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003\u00a8\u0006\r"}, d2={"createAssetsDir", "", "reportsDir", "", "loadFileFromClasspath", "Ljava/io/InputStream;", "fileName", "loadFileFromClasspathAndSaveIt", "outputPath", "outputFileName", "writeToFileToAssets", "outputDir", "data", "junit5-support"})
@SourceDebugExtension(value={"SMAP\nHtmlUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HtmlUtils.kt\nio/specmatic/test/reports/coverage/html/HtmlUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1855#2,2:59\n*S KotlinDebug\n*F\n+ 1 HtmlUtils.kt\nio/specmatic/test/reports/coverage/html/HtmlUtilsKt\n*L\n45#1:59,2\n*E\n"})
public final class HtmlUtilsKt {
    @NotNull
    public static final InputStream loadFileFromClasspath(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(fileName);
        if (inputStream == null) {
            throw new IllegalArgumentException("File not found in Classpath: " + fileName);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void loadFileFromClasspathAndSaveIt(@NotNull String fileName, @NotNull String outputPath, @NotNull String outputFileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)outputFileName, (String)"outputFileName");
        InputStream fileStream = HtmlUtilsKt.loadFileFromClasspath(fileName);
        Closeable closeable = fileStream;
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            Object[] objectArray = new String[]{outputFileName};
            Path targetPath = Paths.get(outputPath, (String[])objectArray);
            targetPath.getParent().toFile().mkdirs();
            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(stream, targetPath, (CopyOption[])objectArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static /* synthetic */ void loadFileFromClasspathAndSaveIt$default(String string, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = ".";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        HtmlUtilsKt.loadFileFromClasspathAndSaveIt(string, string2, string3);
    }

    public static final void createAssetsDir(@NotNull String reportsDir) {
        Intrinsics.checkNotNullParameter((Object)reportsDir, (String)"reportsDir");
        Object[] objectArray = new String[]{"badge.svg", "blocked.svg", "check-badge.svg", "clipboard-document-list.svg", "clock.svg", "download.svg", "exclamation-triangle.svg", "favicon.svg", "main.js", "utils.js", "tableFilter.js", "summaryUpdater.js", "mark-approved.svg", "mark-rejected.svg", "specmatic-logo.svg", "styles.css", "trend-up.svg", "x-circle.svg"};
        List fileNames = CollectionsKt.listOf((Object[])objectArray);
        Iterable $this$forEach$iv = fileNames;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileName = (String)element$iv;
            boolean bl = false;
            HtmlUtilsKt.loadFileFromClasspathAndSaveIt("templates/assets/" + fileName, reportsDir, "assets/" + fileName);
        }
    }

    public static final void writeToFileToAssets(@NotNull String outputDir, @NotNull String fileName, @NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object object = new String[]{fileName};
        Path targetPath = Paths.get(outputDir + "/assets", (String[])object);
        targetPath.getParent().toFile().mkdirs();
        object = data;
        byte[] byArray = ((String)object).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        Files.write(targetPath, byArray, new OpenOption[0]);
    }
}

