/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.test.reports.renderers;

import io.specmatic.core.SpecmaticConfig;
import io.specmatic.test.reports.coverage.console.ConsoleReport;
import io.specmatic.test.reports.coverage.console.OpenAPICoverageConsoleReport;
import io.specmatic.test.reports.coverage.console.OpenApiCoverageConsoleRow;
import io.specmatic.test.reports.coverage.console.ReportColumn;
import io.specmatic.test.reports.renderers.ReportRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lio/specmatic/test/reports/renderers/CoverageReportTextRenderer;", "Lio/specmatic/test/reports/renderers/ReportRenderer;", "Lio/specmatic/test/reports/coverage/console/OpenAPICoverageConsoleReport;", "()V", "isOrAre", "", "count", "", "makeFooter", "report", "makeReportColumns", "", "Lio/specmatic/test/reports/coverage/console/ReportColumn;", "pluralisePath", "render", "specmaticConfig", "Lio/specmatic/core/SpecmaticConfig;", "junit5-support"})
@SourceDebugExtension(value={"SMAP\nCoverageReportTextRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageReportTextRenderer.kt\nio/specmatic/test/reports/renderers/CoverageReportTextRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class CoverageReportTextRenderer
implements ReportRenderer<OpenAPICoverageConsoleReport> {
    @Override
    @NotNull
    public String render(@NotNull OpenAPICoverageConsoleReport report2, @NotNull SpecmaticConfig specmaticConfig) {
        Intrinsics.checkNotNullParameter((Object)report2, (String)"report");
        Intrinsics.checkNotNullParameter((Object)specmaticConfig, (String)"specmaticConfig");
        ConsoleReport textReportGenerator = new ConsoleReport(report2.getCoverageRows(), this.makeReportColumns(report2), this.makeFooter(report2), null, 8, null);
        String coveredAPIsTable = System.lineSeparator() + textReportGenerator.generate();
        List missingAndNotImplementedAPIsMessageRows = new ArrayList();
        if (report2.getMissedEndpointsCount() > 0) {
            String missedPaths = this.pluralisePath(report2.getMissedEndpointsCount());
            missingAndNotImplementedAPIsMessageRows.add(missedPaths + " found in the app " + this.isOrAre(report2.getMissedEndpointsCount()) + " not documented in the spec.");
        }
        if (report2.getPartiallyMissedEndpointsCount() > 0) {
            String partiallyMissedPaths = this.pluralisePath(report2.getPartiallyMissedEndpointsCount());
            missingAndNotImplementedAPIsMessageRows.add(partiallyMissedPaths + " found in the app " + this.isOrAre(report2.getPartiallyMissedEndpointsCount()) + " partially documented in the spec.");
        }
        if (report2.getNotImplementedAPICount() > 0) {
            String notImplementedPaths = this.pluralisePath(report2.getNotImplementedAPICount());
            missingAndNotImplementedAPIsMessageRows.add(notImplementedPaths + " found in the spec " + this.isOrAre(report2.getNotImplementedAPICount()) + " not implemented.");
        }
        if (report2.getPartiallyNotImplementedAPICount() > 0) {
            String partiallyNotImplementedPaths = this.pluralisePath(report2.getPartiallyNotImplementedAPICount());
            missingAndNotImplementedAPIsMessageRows.add(partiallyNotImplementedPaths + " found in the spec " + this.isOrAre(report2.getPartiallyNotImplementedAPICount()) + " partially implemented.");
        }
        String string = System.lineSeparator();
        Iterable iterable = missingAndNotImplementedAPIsMessageRows;
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
        return coveredAPIsTable + string + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null) + System.lineSeparator();
    }

    private final String pluralisePath(int count) {
        return count + " path" + (count == 1 ? "" : "s");
    }

    private final String isOrAre(int count) {
        return count > 1 ? "are" : "is";
    }

    private final List<ReportColumn> makeReportColumns(OpenAPICoverageConsoleReport report2) {
        List list;
        int maxCoveragePercentageLength = 8;
        Iterator iterator = ((Iterable)report2.getCoverageRows()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it422 = (OpenApiCoverageConsoleRow)iterator.next();
        boolean bl = false;
        int it422 = it422.getPath().length();
        while (iterator.hasNext()) {
            OpenApiCoverageConsoleRow it32 = (OpenApiCoverageConsoleRow)iterator.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxPathLength$1 = false;
            int it32 = it32.getPath().length();
            if (it422 >= it32) continue;
            it422 = it32;
        }
        int maxPathLength = it422;
        Iterator it422 = ((Iterable)report2.getCoverageRows()).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it622 = (OpenApiCoverageConsoleRow)it422.next();
        boolean bl2 = false;
        int it622 = it622.getMethod().length();
        while (it422.hasNext()) {
            OpenApiCoverageConsoleRow it52 = (OpenApiCoverageConsoleRow)it422.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxMethodLength$1 = false;
            int it52 = it52.getMethod().length();
            if (it622 >= it52) continue;
            it622 = it52;
        }
        int maxMethodLength = it622;
        Iterator it622 = ((Iterable)report2.getCoverageRows()).iterator();
        if (!it622.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it = (OpenApiCoverageConsoleRow)it622.next();
        boolean bl3 = false;
        int n = it.getResponseStatus().length();
        while (it622.hasNext()) {
            OpenApiCoverageConsoleRow it22 = (OpenApiCoverageConsoleRow)it622.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxStatusLength$1 = false;
            int it22 = it22.getResponseStatus().length();
            if (n >= it22) continue;
            n = it22;
        }
        int maxStatusLength = n;
        int maxExercisedLength = 10;
        Iterator it22 = ((Iterable)report2.getCoverageRows()).iterator();
        if (!it22.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it72 = (OpenApiCoverageConsoleRow)it22.next();
        boolean bl4 = false;
        int it72 = it72.getRemarks().toString().length();
        while (it22.hasNext()) {
            OpenApiCoverageConsoleRow it2 = (OpenApiCoverageConsoleRow)it22.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxRemarkLength$1 = false;
            int n2 = it2.getRemarks().toString().length();
            if (it72 >= n2) continue;
            it72 = n2;
        }
        int maxRemarkLength = it72;
        List $this$makeReportColumns_u24lambda_u244 = list = CollectionsKt.createListBuilder();
        boolean bl5 = false;
        $this$makeReportColumns_u24lambda_u244.add(new ReportColumn("coverage", maxCoveragePercentageLength));
        $this$makeReportColumns_u24lambda_u244.add(new ReportColumn("path", maxPathLength));
        if (report2.isGherkinReport()) {
            $this$makeReportColumns_u24lambda_u244.add(new ReportColumn("soapAction", maxMethodLength));
        } else {
            $this$makeReportColumns_u24lambda_u244.add(new ReportColumn("method", maxMethodLength));
            $this$makeReportColumns_u24lambda_u244.add(new ReportColumn("response", maxStatusLength));
        }
        $this$makeReportColumns_u24lambda_u244.add(new ReportColumn("#exercised", maxExercisedLength));
        $this$makeReportColumns_u24lambda_u244.add(new ReportColumn("result", maxRemarkLength));
        return CollectionsKt.build((List)list);
    }

    private final String makeFooter(OpenAPICoverageConsoleReport report2) {
        return report2.getTotalCoveragePercentage() + "% API Coverage reported from " + report2.getTotalEndpointsCount() + " Paths";
    }
}

