/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.test.reports.renderers;

import io.specmatic.core.SpecmaticConfig;
import io.specmatic.test.reports.coverage.console.ConsoleReport;
import io.specmatic.test.reports.coverage.console.OpenAPICoverageConsoleReport;
import io.specmatic.test.reports.coverage.console.OpenApiCoverageConsoleRow;
import io.specmatic.test.reports.coverage.console.ReportColumn;
import io.specmatic.test.reports.renderers.ReportRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lio/specmatic/test/reports/renderers/CoverageReportTextRenderer;", "Lio/specmatic/test/reports/renderers/ReportRenderer;", "Lio/specmatic/test/reports/coverage/console/OpenAPICoverageConsoleReport;", "()V", "isOrAre", "", "count", "", "makeFooter", "report", "makeReportColumns", "", "Lio/specmatic/test/reports/coverage/console/ReportColumn;", "pluralisePath", "render", "specmaticConfig", "Lio/specmatic/core/SpecmaticConfig;", "junit5-support"})
@SourceDebugExtension(value={"SMAP\nCoverageReportTextRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoverageReportTextRenderer.kt\nio/specmatic/test/reports/renderers/CoverageReportTextRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class CoverageReportTextRenderer
implements ReportRenderer<OpenAPICoverageConsoleReport> {
    @Override
    @NotNull
    public String render(@NotNull OpenAPICoverageConsoleReport report, @NotNull SpecmaticConfig specmaticConfig) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        Intrinsics.checkNotNullParameter((Object)specmaticConfig, (String)"specmaticConfig");
        ConsoleReport textReportGenerator = new ConsoleReport(report.getCoverageRows(), this.makeReportColumns(report), this.makeFooter(report), null, 8, null);
        String coveredAPIsTable = System.lineSeparator() + textReportGenerator.generate();
        List missingAndNotImplementedAPIsMessageRows = new ArrayList();
        if (report.getMissedEndpointsCount() > 0) {
            String missedPaths = this.pluralisePath(report.getMissedEndpointsCount());
            missingAndNotImplementedAPIsMessageRows.add(missedPaths + " found in the app " + this.isOrAre(report.getMissedEndpointsCount()) + " not documented in the spec.");
        }
        if (report.getPartiallyMissedEndpointsCount() > 0) {
            String partiallyMissedPaths = this.pluralisePath(report.getPartiallyMissedEndpointsCount());
            missingAndNotImplementedAPIsMessageRows.add(partiallyMissedPaths + " found in the app " + this.isOrAre(report.getPartiallyMissedEndpointsCount()) + " partially documented in the spec.");
        }
        if (report.getNotImplementedAPICount() > 0) {
            String notImplementedPaths = this.pluralisePath(report.getNotImplementedAPICount());
            missingAndNotImplementedAPIsMessageRows.add(notImplementedPaths + " found in the spec " + this.isOrAre(report.getNotImplementedAPICount()) + " not implemented.");
        }
        if (report.getPartiallyNotImplementedAPICount() > 0) {
            String partiallyNotImplementedPaths = this.pluralisePath(report.getPartiallyNotImplementedAPICount());
            missingAndNotImplementedAPIsMessageRows.add(partiallyNotImplementedPaths + " found in the spec " + this.isOrAre(report.getPartiallyNotImplementedAPICount()) + " partially implemented.");
        }
        String string = System.lineSeparator();
        Iterable iterable = missingAndNotImplementedAPIsMessageRows;
        String string2 = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
        return coveredAPIsTable + string + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, null, (int)62, null) + System.lineSeparator();
    }

    private final String pluralisePath(int count) {
        return count + " path" + (count == 1 ? "" : "s");
    }

    private final String isOrAre(int count) {
        return count > 1 ? "are" : "is";
    }

    private final List<ReportColumn> makeReportColumns(OpenAPICoverageConsoleReport report) {
        int maxCoveragePercentageLength = 8;
        Iterator iterator = ((Iterable)report.getCoverageRows()).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it422 = (OpenApiCoverageConsoleRow)iterator.next();
        boolean bl = false;
        int it422 = it422.getPath().length();
        while (iterator.hasNext()) {
            OpenApiCoverageConsoleRow it32 = (OpenApiCoverageConsoleRow)iterator.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxPathLength$1 = false;
            int it32 = it32.getPath().length();
            if (it422 >= it32) continue;
            it422 = it32;
        }
        int maxPathLength = it422;
        Iterator it422 = ((Iterable)report.getCoverageRows()).iterator();
        if (!it422.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it622 = (OpenApiCoverageConsoleRow)it422.next();
        boolean bl2 = false;
        int it622 = it622.getMethod().length();
        while (it422.hasNext()) {
            OpenApiCoverageConsoleRow it52 = (OpenApiCoverageConsoleRow)it422.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxMethodLength$1 = false;
            int it52 = it52.getMethod().length();
            if (it622 >= it52) continue;
            it622 = it52;
        }
        int maxMethodLength = it622;
        Iterator it622 = ((Iterable)report.getCoverageRows()).iterator();
        if (!it622.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it = (OpenApiCoverageConsoleRow)it622.next();
        boolean bl3 = false;
        int n = it.getResponseStatus().length();
        while (it622.hasNext()) {
            OpenApiCoverageConsoleRow it2 = (OpenApiCoverageConsoleRow)it622.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxStatusLength$1 = false;
            int n2 = it2.getResponseStatus().length();
            if (n >= n2) continue;
            n = n2;
        }
        int maxStatusLength = n;
        int maxExercisedLength = 10;
        Iterator iterator2 = ((Iterable)report.getCoverageRows()).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        OpenApiCoverageConsoleRow it3 = (OpenApiCoverageConsoleRow)iterator2.next();
        boolean bl4 = false;
        int n3 = it3.getRemarks().toString().length();
        while (iterator2.hasNext()) {
            OpenApiCoverageConsoleRow it5 = (OpenApiCoverageConsoleRow)iterator2.next();
            $i$a$-maxOf-CoverageReportTextRenderer$makeReportColumns$maxRemarkLength$1 = false;
            int n4 = it5.getRemarks().toString().length();
            if (n3 >= n4) continue;
            n3 = n4;
        }
        int maxRemarkLength = n3;
        Object[] objectArray = new ReportColumn[]{new ReportColumn("coverage", maxCoveragePercentageLength), new ReportColumn("path", maxPathLength), new ReportColumn("method", maxMethodLength), new ReportColumn("response", maxStatusLength), new ReportColumn("#exercised", maxExercisedLength), new ReportColumn("result", maxRemarkLength)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final String makeFooter(OpenAPICoverageConsoleReport report) {
        return report.getTotalCoveragePercentage() + "% API Coverage reported from " + report.getTotalEndpointsCount() + " Paths";
    }
}

