/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.log;

import io.specmatic.core.log.CompositePrinter;
import io.specmatic.core.log.LogMessage;
import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.LogTail;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.log.NonVerbose;
import io.specmatic.core.log.StringLog;
import io.specmatic.core.log.ThreadSafeLog;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u0016\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010\u001a\u0014\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017\u001a\u0006\u0010\u0018\u001a\u00020\t\u001a\u0006\u0010\u0019\u001a\u00020\u0003\"\u001d\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0005\"\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u001a"}, d2={"dontPrintToConsole", "Lkotlin/Function1;", "Lio/specmatic/core/log/LogMessage;", "", "getDontPrintToConsole", "()Lkotlin/jvm/functions/Function1;", "ignoreLog", "getIgnoreLog", "logger", "Lio/specmatic/core/log/LogStrategy;", "getLogger", "()Lio/specmatic/core/log/LogStrategy;", "setLogger", "(Lio/specmatic/core/log/LogStrategy;)V", "consoleLog", "event", "", "e", "", "msg", "logException", "", "fn", "Lkotlin/Function0;", "newLogger", "resetLogger", "core"})
public final class LoggingKt {
    @NotNull
    private static LogStrategy logger = LoggingKt.newLogger();
    @NotNull
    private static final Function1<LogMessage, Unit> dontPrintToConsole = dontPrintToConsole.1.INSTANCE;
    @NotNull
    private static final Function1<LogMessage, Unit> ignoreLog = ignoreLog.1.INSTANCE;

    @NotNull
    public static final LogStrategy getLogger() {
        return logger;
    }

    public static final void setLogger(@NotNull LogStrategy logStrategy) {
        Intrinsics.checkNotNullParameter((Object)logStrategy, (String)"<set-?>");
        logger = logStrategy;
    }

    @NotNull
    public static final LogStrategy newLogger() {
        return new ThreadSafeLog(new NonVerbose(new CompositePrinter(null, 1, null)));
    }

    public static final void resetLogger() {
        logger = new NonVerbose(new CompositePrinter(null, 1, null));
    }

    public static final int logException(@NotNull Function0<Unit> fn) {
        int n;
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        try {
            fn.invoke();
            n = 0;
        }
        catch (Throwable e) {
            LogStrategy.DefaultImpls.log$default(logger, e, null, 2, null);
            n = 1;
        }
        return n;
    }

    public static final void consoleLog(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LoggingKt.consoleLog(new StringLog(event));
    }

    public static final void consoleLog(@NotNull LogMessage event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LogTail.INSTANCE.append(event);
        logger.log(event);
    }

    public static final void consoleLog(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LogTail.INSTANCE.append(LogStrategy.DefaultImpls.ofTheException$default(logger, e, null, 2, null));
        LogStrategy.DefaultImpls.log$default(logger, e, null, 2, null);
    }

    public static final void consoleLog(@NotNull Throwable e, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        LogTail.INSTANCE.append(logger.ofTheException(e, msg));
        logger.log(e, msg);
    }

    @NotNull
    public static final Function1<LogMessage, Unit> getDontPrintToConsole() {
        return dontPrintToConsole;
    }

    @NotNull
    public static final Function1<LogMessage, Unit> getIgnoreLog() {
        return ignoreLog;
    }
}

