/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import io.specmatic.core.ResultKt;
import io.specmatic.core.Substitution;
import io.specmatic.core.pattern.BooleanPatternKt;
import io.specmatic.core.pattern.ConsumeResult;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.HasDefaultExample;
import io.specmatic.core.pattern.HasValue;
import io.specmatic.core.pattern.NullPattern;
import io.specmatic.core.pattern.NumberPatternKt;
import io.specmatic.core.pattern.PairOfTypes;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.pattern.ScalarType;
import io.specmatic.core.pattern.ScalarTypeKt;
import io.specmatic.core.pattern.config.NegativePatternConfiguration;
import io.specmatic.core.value.BooleanValue;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.Value;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0011\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u0015\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J2\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0010\u0010\u0019\u001a\f\u0012\u0004\u0012\u00020\u001b0\u001aj\u0002`\u001cH\u0016J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00d6\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0017H\u0016J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u001e\u0010%\u001a\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020!0'2\u0006\u0010\"\u001a\u00020\u0017H\u0016J\u001a\u0010(\u001a\u00020\u00142\b\u0010)\u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u0017H\u0016J,\u0010*\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010/\u001a\u000200H\u0016J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00010+2\u0006\u0010\"\u001a\u00020\u0017H\u0016J$\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010,0+2\u0006\u0010-\u001a\u00020.2\u0006\u0010\"\u001a\u00020\u0017H\u0016J\u0018\u00102\u001a\u00020!2\u0006\u00103\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0017H\u0016J\b\u00104\u001a\u00020\u0005H\u0016R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u00065"}, d2={"Lio/specmatic/core/pattern/BooleanPattern;", "Lio/specmatic/core/pattern/Pattern;", "Lio/specmatic/core/pattern/ScalarType;", "Lio/specmatic/core/pattern/HasDefaultExample;", "example", "", "(Ljava/lang/String;)V", "getExample", "()Ljava/lang/String;", "pattern", "", "getPattern", "()Ljava/lang/Object;", "typeAlias", "getTypeAlias", "typeName", "getTypeName", "component1", "copy", "encompasses", "Lio/specmatic/core/Result;", "otherPattern", "thisResolver", "Lio/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lio/specmatic/core/pattern/PairOfTypes;", "Lio/specmatic/core/pattern/TypeStack;", "equals", "", "other", "generate", "Lio/specmatic/core/value/Value;", "resolver", "hashCode", "", "listOf", "valueList", "", "matches", "sampleData", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "Lio/specmatic/core/pattern/ReturnValue;", "row", "Lio/specmatic/core/pattern/Row;", "config", "Lio/specmatic/core/pattern/config/NegativePatternConfiguration;", "newBasedOn", "parse", "value", "toString", "core"})
public final class BooleanPattern
implements Pattern,
ScalarType,
HasDefaultExample {
    @Nullable
    private final String example;
    @NotNull
    private final String typeName;
    @NotNull
    private final Object pattern;

    public BooleanPattern(@Nullable String example) {
        this.example = example;
        this.typeName = "boolean";
        this.pattern = "(boolean)";
    }

    public /* synthetic */ BooleanPattern(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Override
    @Nullable
    public String getExample() {
        return this.example;
    }

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Value value2 = sampleData;
        boolean bl = value2 != null ? value2.hasTemplate() : false;
        if (bl) {
            return new Result.Success(null, null, 3, null);
        }
        return sampleData instanceof BooleanValue ? (Result)new Result.Success(null, null, 3, null) : (Result)ResultKt.mismatchResult("boolean", sampleData, resolver.getMismatchMessages());
    }

    @Override
    @NotNull
    public Value generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Value value2 = resolver.resolveExample(this.getExample(), (Pattern)this);
        if (value2 == null) {
            value2 = BooleanPatternKt.randomBoolean();
        }
        return value2;
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new HasValue[]{new HasValue(this, null, 2, null)};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new BooleanPattern[]{this};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver, @NotNull NegativePatternConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Object[] objectArray = new NullPattern[]{NullPattern.INSTANCE};
        return ScalarTypeKt.scalarAnnotation(this, (Sequence<? extends Pattern>)SequencesKt.sequenceOf((Object[])objectArray));
    }

    @Override
    @NotNull
    public Value parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = value2.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String string2 = string;
        Object[] objectArray = new String[]{"true", "false"};
        if (!CollectionsKt.listOf((Object[])objectArray).contains(string2)) {
            throw new ContractException(Result.Failure.toFailureReport$default(ResultKt.mismatchResult((Pattern)new BooleanPattern(null, 1, null), value2, resolver.getMismatchMessages()), null, 1, null));
        }
        return new BooleanValue(Boolean.parseBoolean(value2));
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        return NumberPatternKt.encompasses(this, otherPattern, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return null;
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @NotNull
    public Object getPattern() {
        return this.pattern;
    }

    @NotNull
    public String toString() {
        return this.getPattern().toString();
    }

    @Override
    @NotNull
    public ConsumeResult<Value, Value> matches(@NotNull List<? extends Value> sampleData, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.matches(this, sampleData, resolver);
    }

    @Override
    @NotNull
    public ConsumeResult<Pattern, Pattern> encompasses(@NotNull List<? extends Pattern> others, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull String lengthError, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.encompasses(this, others, thisResolver, otherResolver, lengthError, typeStack);
    }

    @Override
    @NotNull
    public Value generateWithAll(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.generateWithAll(this, resolver);
    }

    @Override
    @NotNull
    public List<Pattern> patternSet(@NotNull Resolver resolver) {
        return Pattern.DefaultImpls.patternSet(this, resolver);
    }

    @Override
    @NotNull
    public Pattern parseToType(@NotNull String valueString, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.parseToType(this, valueString, resolver);
    }

    @Override
    @NotNull
    public Result fitsWithin(@NotNull List<? extends Pattern> otherPatterns2, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        return Pattern.DefaultImpls.fitsWithin(this, otherPatterns2, thisResolver, otherResolver, typeStack);
    }

    @Override
    @NotNull
    public Pattern toNullable(@Nullable String defaultValue) {
        return Pattern.DefaultImpls.toNullable(this, defaultValue);
    }

    @Override
    @NotNull
    public ReturnValue<Value> resolveSubstitutions(@NotNull Substitution substitution, @NotNull Value value2, @NotNull Resolver resolver, @Nullable String key2) {
        return Pattern.DefaultImpls.resolveSubstitutions(this, substitution, value2, resolver, key2);
    }

    @Override
    @NotNull
    public ReturnValue<Map<String, Pattern>> getTemplateTypes(@NotNull String key2, @NotNull Value value2, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.getTemplateTypes(this, key2, value2, resolver);
    }

    @Override
    @NotNull
    public ReturnValue<Value> fillInTheBlanks(@NotNull Value value2, @NotNull Resolver resolver) {
        return Pattern.DefaultImpls.fillInTheBlanks(this, value2, resolver);
    }

    @Override
    @NotNull
    public Pattern addTypeAliasesToConcretePattern(@NotNull Pattern concretePattern, @NotNull Resolver resolver, @Nullable String typeAlias) {
        return Pattern.DefaultImpls.addTypeAliasesToConcretePattern(this, concretePattern, resolver, typeAlias);
    }

    @Nullable
    public final String component1() {
        return this.example;
    }

    @NotNull
    public final BooleanPattern copy(@Nullable String example) {
        return new BooleanPattern(example);
    }

    public static /* synthetic */ BooleanPattern copy$default(BooleanPattern booleanPattern, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = booleanPattern.example;
        }
        return booleanPattern.copy(string);
    }

    public int hashCode() {
        return this.example == null ? 0 : this.example.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BooleanPattern)) {
            return false;
        }
        BooleanPattern booleanPattern = (BooleanPattern)other;
        return Intrinsics.areEqual((Object)this.example, (Object)booleanPattern.example);
    }

    public BooleanPattern() {
        this(null, 1, null);
    }
}

