/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.value;

import io.specmatic.core.ExampleDeclarations;
import io.specmatic.core.pattern.DeferredPattern;
import io.specmatic.core.pattern.JSONObjectPattern;
import io.specmatic.core.pattern.JSONObjectPatternKt;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.TabularPattern;
import io.specmatic.core.pattern.TabularPatternKt;
import io.specmatic.core.utilities.JSONSerialisationKt;
import io.specmatic.core.utilities.Utilities;
import io.specmatic.core.value.BooleanValue;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONComposite;
import io.specmatic.core.value.JSONObjectValueKt;
import io.specmatic.core.value.NumberValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.TypeDeclaration;
import io.specmatic.core.value.Value;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\u0014\b\u0002\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u00c6\u0001J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0005H\u0016J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0018\u001a\u00020\u0005J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001a\u001a\u00020\u0005J \u0010\u0019\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u00052\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dH\u0002J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00012\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00050\u001dJ\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0005J\u0014\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u0005J\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u00042\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J\t\u0010&\u001a\u00020!H\u00d6\u0001J\u0016\u0010'\u001a\u00020\u00012\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00010\u001dH\u0016J\b\u0010)\u001a\u00020\u0005H\u0016J\b\u0010*\u001a\u00020\u0005H\u0016J\u0006\u0010+\u001a\u00020\u0005J\b\u0010,\u001a\u00020\u000fH\u0016J8\u0010-\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\u0006\u0010\u001f\u001a\u00020\u00052\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u00102\u001a\u000200H\u0016J8\u00103\u001a\u000e\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u0002000.2\u0006\u00104\u001a\u00020\u00052\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u00102\u001a\u000200H\u0016J\b\u00105\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00066"}, d2={"Lio/specmatic/core/value/JSONObjectValue;", "Lio/specmatic/core/value/Value;", "Lio/specmatic/core/value/JSONComposite;", "jsonObject", "", "", "(Ljava/util/Map;)V", "httpContentType", "getHttpContentType", "()Ljava/lang/String;", "getJsonObject", "()Ljava/util/Map;", "component1", "copy", "deepPattern", "Lio/specmatic/core/pattern/Pattern;", "displayableType", "displayableValue", "equals", "", "other", "", "exactMatchElseType", "findFirstChildByName", "name", "findFirstChildByPath", "path", "first", "rest", "", "getBoolean", "key", "getInt", "", "getJSONArray", "getJSONObject", "getJSONObjectValue", "getString", "hashCode", "listOf", "valueList", "toString", "toStringLiteral", "toUnformattedStringLiteral", "type", "typeDeclarationWithKey", "Lkotlin/Pair;", "Lio/specmatic/core/value/TypeDeclaration;", "Lio/specmatic/core/ExampleDeclarations;", "types", "exampleDeclarations", "typeDeclarationWithoutKey", "exampleKey", "valueErrorSnippet", "core"})
@SourceDebugExtension(value={"SMAP\nJSONObjectValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONObjectValue.kt\nio/specmatic/core/value/JSONObjectValue\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,102:1\n453#2:103\n403#2:104\n453#2:109\n403#2:110\n453#2:115\n403#2:116\n1238#3,4:105\n1238#3,4:111\n1238#3,4:117\n*S KotlinDebug\n*F\n+ 1 JSONObjectValue.kt\nio/specmatic/core/value/JSONObjectValue\n*L\n18#1:103\n18#1:104\n21#1:109\n21#1:110\n28#1:115\n28#1:116\n18#1:105,4\n21#1:111,4\n28#1:117,4\n*E\n"})
public final class JSONObjectValue
implements Value,
JSONComposite {
    @NotNull
    private final Map<String, Value> jsonObject;
    @NotNull
    private final String httpContentType;

    public JSONObjectValue(@NotNull Map<String, ? extends Value> jsonObject) {
        Intrinsics.checkNotNullParameter(jsonObject, (String)"jsonObject");
        this.jsonObject = jsonObject;
        this.httpContentType = "application/json";
    }

    public /* synthetic */ JSONObjectValue(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map2);
    }

    @NotNull
    public final Map<String, Value> getJsonObject() {
        return this.jsonObject;
    }

    @Override
    @NotNull
    public String getHttpContentType() {
        return this.httpContentType;
    }

    @Override
    @NotNull
    public String valueErrorSnippet() {
        return "JSON object " + this.displayableValue();
    }

    @Override
    @NotNull
    public String displayableValue() {
        return this.toStringLiteral();
    }

    @Override
    @NotNull
    public String toStringLiteral() {
        return JSONSerialisationKt.valueMapToPrettyJsonString(this.jsonObject);
    }

    @NotNull
    public final String toUnformattedStringLiteral() {
        return JSONSerialisationKt.valueMapToUnindentedJsonString(this.jsonObject);
    }

    @Override
    @NotNull
    public String displayableType() {
        return "json object";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pattern exactMatchElseType() {
        void $this$mapValuesTo$iv$iv;
        Map<String, Value> $this$mapValues$iv = this.jsonObject;
        boolean $i$f$mapValues = false;
        Map<String, Value> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Pattern pattern2 = ((Value)it.getValue()).exactMatchElseType();
            map4.put(k, pattern2);
        }
        return JSONObjectPatternKt.toJSONObjectPattern$default(destination$iv$iv, null, 2, null);
    }

    @Override
    @NotNull
    public Pattern type() {
        return new JSONObjectPattern(null, null, null, null, null, 31, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pattern deepPattern() {
        void $this$mapValuesTo$iv$iv;
        Map<String, Value> $this$mapValues$iv = this.jsonObject;
        boolean $i$f$mapValues = false;
        Map<String, Value> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Pattern pattern2 = ((Value)it.getValue()).deepPattern();
            map4.put(k, pattern2);
        }
        return JSONObjectPatternKt.toJSONObjectPattern$default(destination$iv$iv, null, 2, null);
    }

    @NotNull
    public String toString() {
        return JSONSerialisationKt.valueMapToPrettyJsonString(this.jsonObject);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithKey(@NotNull String key2, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        Triple<Map<String, DeferredPattern>, Map<String, Pattern>, ExampleDeclarations> triple = JSONObjectValueKt.dictionaryToDeclarations(this.jsonObject, types, exampleDeclarations);
        Map jsonTypeMap = (Map)triple.component1();
        Map newTypes = (Map)triple.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)triple.component3();
        Map $this$mapValues$iv = jsonTypeMap;
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            DeferredPattern deferredPattern = new DeferredPattern(((DeferredPattern)it.getValue()).getPattern(), null, 2, null);
            map4.put(k, deferredPattern);
        }
        TabularPattern newType = TabularPatternKt.toTabularPattern$default(destination$iv$iv, null, 2, null);
        String newTypeName = exampleDeclarations.getNewName(Utilities.capitalizeFirstChar(key2), newTypes.keySet());
        TypeDeclaration typeDeclaration = new TypeDeclaration("(" + newTypeName + ")", MapsKt.plus((Map)newTypes, (Pair)TuplesKt.to((Object)newTypeName, (Object)newType)));
        return new Pair((Object)typeDeclaration, (Object)newExamples);
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public Pair<TypeDeclaration, ExampleDeclarations> typeDeclarationWithoutKey(@NotNull String exampleKey, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter((Object)exampleKey, (String)"exampleKey");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        return this.typeDeclarationWithKey(exampleKey, types, exampleDeclarations);
    }

    @NotNull
    public final String getString(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.specmatic.core.value.StringValue");
        return ((StringValue)object).getString();
    }

    public final boolean getBoolean(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.specmatic.core.value.BooleanValue");
        return ((BooleanValue)object).getBooleanValue();
    }

    public final int getInt(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.specmatic.core.value.NumberValue");
        return ((NumberValue)object).getNumber().intValue();
    }

    @NotNull
    public final Map<String, Value> getJSONObject(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.specmatic.core.value.JSONObjectValue");
        return ((JSONObjectValue)object).jsonObject;
    }

    @NotNull
    public final JSONObjectValue getJSONObjectValue(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.specmatic.core.value.JSONObjectValue");
        return (JSONObjectValue)object;
    }

    @NotNull
    public final List<Value> getJSONArray(@NotNull String key2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Object object = MapsKt.getValue(this.jsonObject, (Object)key2);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type io.specmatic.core.value.JSONArrayValue");
        return ((JSONArrayValue)object).getList();
    }

    @Nullable
    public final Value findFirstChildByPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{"."};
        return this.findFirstChildByPath(StringsKt.split$default((CharSequence)path2, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
    }

    @Nullable
    public final Value findFirstChildByPath(@NotNull List<String> path2) {
        Intrinsics.checkNotNullParameter(path2, (String)"path");
        return this.findFirstChildByPath((String)CollectionsKt.first(path2), CollectionsKt.drop((Iterable)path2, (int)1));
    }

    private final Value findFirstChildByPath(String first, List<String> rest2) {
        Value value2;
        Value value3 = this.findFirstChildByName(first);
        if (value3 != null) {
            Value it = value3;
            boolean bl = false;
            value2 = rest2.isEmpty() ? it : (it instanceof JSONObjectValue ? ((JSONObjectValue)it).findFirstChildByPath(rest2) : (it instanceof JSONArrayValue ? ((JSONArrayValue)it).getElementAtIndex((String)CollectionsKt.first(rest2), CollectionsKt.drop((Iterable)rest2, (int)1)) : null));
        } else {
            value2 = null;
        }
        return value2;
    }

    @Nullable
    public final Value findFirstChildByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.jsonObject.get(name);
    }

    @Override
    @NotNull
    public StringValue toStringValue() {
        return Value.DefaultImpls.toStringValue(this);
    }

    @Override
    public boolean hasTemplate() {
        return Value.DefaultImpls.hasTemplate(this);
    }

    @Override
    public boolean hasDataTemplate() {
        return Value.DefaultImpls.hasDataTemplate(this);
    }

    @NotNull
    public final Map<String, Value> component1() {
        return this.jsonObject;
    }

    @NotNull
    public final JSONObjectValue copy(@NotNull Map<String, ? extends Value> jsonObject) {
        Intrinsics.checkNotNullParameter(jsonObject, (String)"jsonObject");
        return new JSONObjectValue(jsonObject);
    }

    public static /* synthetic */ JSONObjectValue copy$default(JSONObjectValue jSONObjectValue, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map2 = jSONObjectValue.jsonObject;
        }
        return jSONObjectValue.copy(map2);
    }

    public int hashCode() {
        return ((Object)this.jsonObject).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONObjectValue)) {
            return false;
        }
        JSONObjectValue jSONObjectValue = (JSONObjectValue)other;
        return Intrinsics.areEqual(this.jsonObject, jSONObjectValue.jsonObject);
    }

    public JSONObjectValue() {
        this(null, 1, null);
    }
}

