/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.request.forms.FormBuilder;
import io.ktor.client.request.forms.FormDataContent;
import io.ktor.client.request.forms.FormDslKt;
import io.ktor.client.request.forms.MultiPartFormDataContent;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.HttpMethod;
import io.ktor.http.ParametersKt;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.TextContent;
import io.ktor.util.reflect.TypeInfoJvmKt;
import io.specmatic.core.HttpHeadersPattern;
import io.specmatic.core.HttpHeadersPatternKt;
import io.specmatic.core.HttpPathPattern;
import io.specmatic.core.HttpPathPatternKt;
import io.specmatic.core.HttpQueryParamPattern;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpRequestKt;
import io.specmatic.core.HttpRequestMetadata;
import io.specmatic.core.HttpRequestPattern;
import io.specmatic.core.MultiPartContent;
import io.specmatic.core.MultiPartContentValue;
import io.specmatic.core.MultiPartFileValue;
import io.specmatic.core.MultiPartFormDataPattern;
import io.specmatic.core.MultiPartFormDataValue;
import io.specmatic.core.NoBodyValue;
import io.specmatic.core.QueryParameters;
import io.specmatic.core.Resolver;
import io.specmatic.core.URLParts;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.ExactValuePattern;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.QueryParameterArrayPattern;
import io.specmatic.core.pattern.QueryParameterScalarPattern;
import io.specmatic.core.pattern.StringPattern;
import io.specmatic.core.utilities.URIUtils;
import io.specmatic.core.value.EmptyStringKt;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import io.specmatic.core.value.XMLNode;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0086\b\u0018\u00002\u00020\u0001:\u0003jklB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u008f\u0001\b\u0016\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014Bw\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u0012\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u0012\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100J\u000b\u00101\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u00102\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\t\u00104\u001a\u00020\u000bH\u00c6\u0003J\t\u00105\u001a\u00020\u0016H\u00c6\u0003J\u0015\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u00c6\u0003J\u000f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u00108\u001a\u00020\u0013H\u00c6\u0003J$\u00109\u001a\u00020\u00032\b\u0010:\u001a\u0004\u0018\u00010\u00032\b\u0010;\u001a\u0004\u0018\u00010\u00032\u0006\u0010<\u001a\u00020\u0003H\u0002J{\u0010=\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0015\u001a\u00020\u00162\u0014\b\u0002\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u00c6\u0001J\u0013\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010A\u001a\u00020\u00032\b\u0010B\u001a\u0004\u0018\u00010\u0003J\t\u0010C\u001a\u00020DH\u00d6\u0001J\u0010\u0010E\u001a\u00020?2\u0006\u0010F\u001a\u00020\u0003H\u0002J\u0010\u0010G\u001a\u00020?2\u0006\u0010F\u001a\u00020\u0003H\u0002J\u0006\u0010H\u001a\u00020\u0000J(\u0010I\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020J0\t2\u0012\u0010K\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tH\u0002J\u001c\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020J0\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010M\u001a\u00020\u0003J\u000e\u0010M\u001a\u00020\u00032\u0006\u0010N\u001a\u00020OJ\u0006\u0010P\u001a\u00020\u0003J\u001a\u0010Q\u001a\u00020\u00002\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tJ\u0006\u0010S\u001a\u00020TJ\u0010\u0010U\u001a\u00020\u00032\b\b\u0002\u0010V\u001a\u00020\u0003J\u0006\u0010W\u001a\u00020XJ\t\u0010Y\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010Z\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010Z\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\u0016\u0010[\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u0003J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0003J\u000e\u0010`\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0003J\u0016\u0010a\u001a\u00020\u00002\u0006\u0010\\\u001a\u00020\u00032\u0006\u0010]\u001a\u00020\u0003J\u001a\u0010b\u001a\u00020\u00002\u0012\u0010c\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\tJ\u000e\u0010d\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0005J\u001a\u0010e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00032\b\u0010f\u001a\u0004\u0018\u00010\u0003H\u0002J\u000e\u0010g\u001a\u00020\u00002\u0006\u0010F\u001a\u00020\u0003J2\u0010h\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\b\u0010/\u001a\u0004\u0018\u000100H\u0002J\u0006\u0010i\u001a\u00020\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001eR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u001cR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u00a8\u0006m"}, d2={"Lio/specmatic/core/HttpRequest;", "", "method", "", "uri", "Ljava/net/URI;", "(Ljava/lang/String;Ljava/net/URI;)V", "path", "headers", "", "body", "Lio/specmatic/core/value/Value;", "queryParametersMap", "formFields", "multiPartFormData", "", "Lio/specmatic/core/MultiPartFormDataValue;", "marker", "metadata", "Lio/specmatic/core/HttpRequestMetadata;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lio/specmatic/core/value/Value;Ljava/util/Map;Ljava/util/Map;Ljava/util/List;Ljava/lang/String;Lio/specmatic/core/HttpRequestMetadata;)V", "queryParams", "Lio/specmatic/core/QueryParameters;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lio/specmatic/core/value/Value;Lio/specmatic/core/QueryParameters;Ljava/util/Map;Ljava/util/List;Lio/specmatic/core/HttpRequestMetadata;)V", "getBody", "()Lio/specmatic/core/value/Value;", "bodyString", "getBodyString", "()Ljava/lang/String;", "getFormFields", "()Ljava/util/Map;", "getHeaders", "getMetadata", "()Lio/specmatic/core/HttpRequestMetadata;", "getMethod", "getMultiPartFormData", "()Ljava/util/List;", "getPath", "getQueryParams", "()Lio/specmatic/core/QueryParameters;", "addSecurityHeader", "headerName", "headerValue", "buildKTORRequest", "", "httpRequestBuilder", "Lio/ktor/client/request/HttpRequestBuilder;", "url", "Ljava/net/URL;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "concatNonNulls", "first", "second", "separator", "copy", "equals", "", "other", "getURL", "baseURL", "hashCode", "", "isIPAddress", "host", "isNotIPAddress", "loadFileContentIntoParts", "mapToPattern", "Lio/specmatic/core/pattern/Pattern;", "map", "mapToQueryParameterPattern", "requestNotRecognized", "requestNotRecognizedMessages", "Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "requestNotRecognizedInStrictMode", "setHeaders", "addedHeaders", "toJSON", "Lio/specmatic/core/value/JSONObjectValue;", "toLogString", "prefix", "toPattern", "Lio/specmatic/core/HttpRequestPattern;", "toString", "updateBody", "updateHeader", "key", "value", "updateMethod", "name", "updatePath", "updateQueryParam", "updateQueryParams", "otherQueryParams", "updateWith", "updateWithPathAndQuery", "query", "withHost", "withoutDuplicateHostHeader", "withoutDynamicHeaders", "LenientRequestNotRecognizedMessages", "RequestNotRecognizedMessages", "StrictRequestNotRecognizedMessages", "core"})
@SourceDebugExtension(value={"SMAP\nHttpRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequest.kt\nio/specmatic/core/HttpRequest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 7 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 8 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n*L\n1#1,658:1\n1549#2:659\n1620#2,3:660\n819#2:663\n847#2,2:664\n1238#2,4:669\n1549#2:673\n1620#2,3:674\n1549#2:685\n1620#2,3:686\n1238#2,4:691\n1477#2:695\n1502#2,3:696\n1505#2,3:706\n1238#2,2:711\n1549#2:713\n1620#2,3:714\n1241#2:717\n766#2:726\n857#2,2:727\n1855#2,2:729\n1238#2,4:733\n1549#2:756\n1620#2,3:757\n1549#2:760\n1620#2,3:761\n1#3:666\n453#4:667\n403#4:668\n453#4:689\n403#4:690\n372#4,7:699\n453#4:709\n403#4:710\n453#4:731\n403#4:732\n478#4,7:764\n125#5:677\n152#5,3:678\n125#5:681\n152#5,3:682\n125#5:718\n152#5,3:719\n125#5:722\n152#5,3:723\n37#6,2:737\n16#7,4:739\n21#7,10:746\n17#8,3:743\n*S KotlinDebug\n*F\n+ 1 HttpRequest.kt\nio/specmatic/core/HttpRequest\n*L\n119#1:659\n119#1:660,3\n124#1:663\n124#1:664,2\n138#1:669,4\n141#1:673\n141#1:674,3\n185#1:685\n185#1:686,3\n190#1:691,4\n199#1:695\n199#1:696,3\n199#1:706,3\n200#1:711,2\n201#1:713\n201#1:714,3\n200#1:717\n225#1:726\n225#1:727,2\n226#1:729,2\n239#1:733,4\n282#1:756\n282#1:757,3\n291#1:760\n291#1:761,3\n138#1:667\n138#1:668\n190#1:689\n190#1:690\n199#1:699,7\n200#1:709\n200#1:710\n239#1:731\n239#1:732\n376#1:764,7\n160#1:677\n160#1:678,3\n162#1:681\n162#1:682,3\n208#1:718\n208#1:719,3\n224#1:722\n224#1:723,3\n240#1:737,2\n236#1:739,4\n236#1:746,10\n236#1:743,3\n*E\n"})
public final class HttpRequest {
    @Nullable
    private final String method;
    @Nullable
    private final String path;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private final QueryParameters queryParams;
    @NotNull
    private final Map<String, String> formFields;
    @NotNull
    private final List<MultiPartFormDataValue> multiPartFormData;
    @NotNull
    private final HttpRequestMetadata metadata;

    public HttpRequest(@Nullable String method, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body, @NotNull QueryParameters queryParams2, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull HttpRequestMetadata metadata) {
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)queryParams2, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.method = method;
        this.path = path2;
        this.headers = headers2;
        this.body = body;
        this.queryParams = queryParams2;
        this.formFields = formFields;
        this.multiPartFormData = multiPartFormData;
        this.metadata = metadata;
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map2, Value value2, QueryParameters queryParameters, Map map3, List list, HttpRequestMetadata httpRequestMetadata, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            value2 = EmptyStringKt.getEmptyString();
        }
        if ((n & 0x10) != 0) {
            queryParameters = new QueryParameters(null, 1, null);
        }
        if ((n & 0x20) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            httpRequestMetadata = new HttpRequestMetadata(null, 1, null);
        }
        this(string, string2, map2, value2, queryParameters, map3, list, httpRequestMetadata);
    }

    @Nullable
    public final String getMethod() {
        return this.method;
    }

    @Nullable
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    @NotNull
    public final QueryParameters getQueryParams() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> getFormFields() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> getMultiPartFormData() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequestMetadata getMetadata() {
        return this.metadata;
    }

    public HttpRequest(@NotNull String method, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this(method, uri.getPath(), null, null, HttpRequestKt.urlToQueryParams(uri), null, null, null, null, 492, null);
    }

    public HttpRequest(@Nullable String method, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body, @NotNull Map<String, String> queryParametersMap, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull String marker, @NotNull HttpRequestMetadata metadata) {
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter(queryParametersMap, (String)"queryParametersMap");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this(method, path2, headers2, body, new QueryParameters(queryParametersMap), formFields, multiPartFormData, metadata);
    }

    public /* synthetic */ HttpRequest(String string, String string2, Map map2, Value value2, Map map3, Map map4, List list, String string3, HttpRequestMetadata httpRequestMetadata, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            map2 = MapsKt.emptyMap();
        }
        if ((n & 8) != 0) {
            value2 = EmptyStringKt.getEmptyString();
        }
        if ((n & 0x10) != 0) {
            map3 = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            map4 = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x80) != 0) {
            string3 = "Dummy";
        }
        if ((n & 0x100) != 0) {
            httpRequestMetadata = new HttpRequestMetadata(null, 1, null);
        }
        this(string, string2, map2, value2, map3, map4, list, string3, httpRequestMetadata);
    }

    @NotNull
    public final HttpRequest updateQueryParams(@NotNull Map<String, String> otherQueryParams) {
        Intrinsics.checkNotNullParameter(otherQueryParams, (String)"otherQueryParams");
        return HttpRequest.copy$default(this, null, null, null, null, this.queryParams.plus(otherQueryParams), null, null, null, 239, null);
    }

    @NotNull
    public final HttpRequest withHost(@NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)"Host", (Object)host)), null, null, null, null, null, 251, null);
    }

    @NotNull
    public final HttpRequest updatePath(@NotNull String path2) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            URI urlParam = new URI(path2);
            httpRequest = this.updateWith(urlParam);
        }
        catch (URISyntaxException e) {
            String[] stringArray = new String[]{"?"};
            List pieces = StringsKt.split$default((CharSequence)path2, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            httpRequest = this.updateWithPathAndQuery((String)pieces.get(0), (String)CollectionsKt.getOrNull((List)pieces, (int)1));
        }
        catch (UnsupportedEncodingException e) {
            String[] stringArray = new String[]{"?"};
            List pieces = StringsKt.split$default((CharSequence)path2, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
            httpRequest = this.updateWithPathAndQuery((String)pieces.get(0), (String)CollectionsKt.getOrNull((List)pieces, (int)1));
        }
        return httpRequest;
    }

    @NotNull
    public final HttpRequest updateQueryParam(@NotNull String key2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return HttpRequest.copy$default(this, null, null, null, null, this.queryParams.plus((Pair<String, String>)TuplesKt.to((Object)key2, (Object)value2)), null, null, null, 239, null);
    }

    @NotNull
    public final HttpRequest updateBody(@NotNull Value body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return HttpRequest.copy$default(this, null, null, null, body, null, null, null, null, 247, null);
    }

    @NotNull
    public final HttpRequest updateBody(@Nullable String body) {
        return HttpRequest.copy$default(this, null, null, null, GrammarKt.parsedValue(body), null, null, null, null, 247, null);
    }

    @NotNull
    public final HttpRequest updateWith(@NotNull URI url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return this.updateWithPathAndQuery(string, url.getQuery());
    }

    private final HttpRequest updateWithPathAndQuery(String path2, String query2) {
        Map<String, String> queryParams2 = URIUtils.INSTANCE.parseQuery(query2);
        return HttpRequest.copy$default(this, null, path2, null, null, new QueryParameters(queryParams2), null, null, null, 237, null);
    }

    @NotNull
    public final HttpRequest updateMethod(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = name.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return HttpRequest.copy$default(this, string, null, null, null, null, null, null, null, 254, null);
    }

    @NotNull
    public final HttpRequest updateHeader(@NotNull String key2, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)key2, (Object)value2)), null, null, null, null, null, 251, null);
    }

    @NotNull
    public final String getBodyString() {
        return this.body.toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getURL(@Nullable String baseURL) {
        void $this$mapTo$iv$iv;
        String string = baseURL;
        String cleanBase = string != null ? StringsKt.removeSuffix((String)string, (CharSequence)"/") : null;
        String string2 = this.path;
        String cleanPath = string2 != null ? StringsKt.removePrefix((String)string2, (CharSequence)"/") : null;
        String fullUrl = new URLParts(this.concatNonNulls(cleanBase, cleanPath, "/")).withEncodedPathSegments();
        Iterable $this$map$iv = this.queryParams.getParamPairs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BasicNameValuePair((String)it.getFirst(), (String)it.getSecond()));
        }
        String queryPart = URLEncodedUtils.format((Iterable)((List)destination$iv$iv), (Charset)Charsets.UTF_8);
        return this.concatNonNulls(fullUrl, queryPart, "?");
    }

    /*
     * WARNING - void declaration
     */
    private final String concatNonNulls(String first, String second, String separator) {
        void $this$filterNotTo$iv$iv;
        Object[] objectArray = new String[]{first, second};
        Iterable $this$filterNot$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)separator, null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        Unit unit;
        StringValue stringValue;
        Map requestMap;
        Map map2 = requestMap = (Map)new LinkedHashMap();
        String string = "path";
        String string2 = this.path;
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            stringValue = new StringValue(it);
        } else {
            stringValue = new StringValue("/");
        }
        Value value2 = stringValue;
        map2.put(string, value2);
        String string3 = this.method;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            requestMap.put("method", new StringValue(it));
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new ContractException("Can't serialise the request without a method.", null, null, null, false, 30, null);
        }
        HttpRequestKt.access$setIfNotEmpty(requestMap, "query", this.queryParams.asMap());
        HttpRequestKt.access$setIfNotEmpty(requestMap, "headers", this.headers);
        if (!this.formFields.isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            map2 = requestMap;
            string = "form-fields";
            Object $this$mapValues$iv = this.formFields;
            boolean $i$f$mapValues = false;
            Map<String, String> bl = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Object object = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Object object2 = object;
                boolean bl3 = false;
                StringValue stringValue2 = new StringValue((String)it.getValue());
                object2.put(k, stringValue2);
            }
            Object object = destination$iv$iv;
            $this$mapValues$iv = new JSONObjectValue((Map<String, ? extends Value>)object);
            map2.put(string, $this$mapValues$iv);
        } else if (!((Collection)this.multiPartFormData).isEmpty()) {
            void $this$mapTo$iv$iv;
            map2 = requestMap;
            string = "multipart-formdata";
            Iterable $this$map$iv = this.multiPartFormData;
            boolean $i$f$map = false;
            Iterable $this$mapValuesTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
                Object object = destination$iv$iv;
                boolean bl = false;
                object.add(it.toJSONObject());
            }
            List list = (List)destination$iv$iv;
            value2 = new JSONArrayValue(list);
            map2.put(string, value2);
        } else {
            requestMap.put("body", this.body);
        }
        return new JSONObjectValue(requestMap);
    }

    @NotNull
    public final HttpRequest setHeaders(@NotNull Map<String, String> addedHeaders) {
        Intrinsics.checkNotNullParameter(addedHeaders, (String)"addedHeaders");
        return HttpRequest.copy$default(this, null, null, MapsKt.plus(this.headers, addedHeaders), null, null, null, null, null, 251, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix2) {
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv;
        String string;
        String methodString;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String string2 = this.method;
        if (string2 == null) {
            string2 = methodString = "NO_METHOD";
        }
        if ((string = this.path) == null) {
            string = "NO_PATH";
        }
        String pathString = string;
        String it = CollectionsKt.joinToString$default((Iterable)this.queryParams.getParamPairs(), (CharSequence)"&", null, null, (int)0, null, (Function1)toLogString.queryParamString.1.INSTANCE, (int)30, null);
        boolean bl = false;
        Object queryParamString2 = ((CharSequence)it).length() > 0 ? "?" + it : it;
        String urlString = pathString + (String)queryParamString2;
        String firstLine = methodString + " " + urlString;
        Map<String, String> $this$map$iv = this.headers;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Object destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it2;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.getKey() + ": " + it2.getValue());
        }
        String headerString2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        if (!this.formFields.isEmpty()) {
            void $this$mapTo$iv$iv2;
            Map<String, String> $this$map$iv2 = this.formFields;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo2 = false;
            Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
            while (iterator2.hasNext()) {
                void it3;
                Map.Entry item$iv$iv;
                Map.Entry bl2 = item$iv$iv = iterator2.next();
                collection = destination$iv$iv2;
                boolean bl3 = false;
                collection.add(it3.getKey() + "=" + it3.getValue());
            }
            object = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        } else {
            object = !((Collection)this.multiPartFormData).isEmpty() ? CollectionsKt.joinToString$default((Iterable)this.multiPartFormData, (CharSequence)"\n", null, null, (int)0, null, (Function1)toLogString.bodyString.2.INSTANCE, (int)30, null) : this.body.toString();
        }
        Object[] it4 = object;
        boolean bl4 = false;
        String bodyString2 = HttpRequestKt.formatJson((String)it4);
        it4 = new String[]{firstLine, headerString2};
        String firstPart = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])it4), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).toString();
        Object[] objectArray = new String[]{firstPart, "", bodyString2};
        String requestString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return HttpRequestKt.startLinesWith(requestString, prefix2);
    }

    public static /* synthetic */ String toLogString$default(HttpRequest httpRequest, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpRequest.toLogString(string);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequestPattern toPattern() {
        Collection<MultiPartFormDataPattern> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String string = this.path;
        if (string == null) {
            string = "/";
        }
        String pathForPattern = string;
        Iterable iterable = this.multiPartFormData;
        Map<String, Pattern> map2 = this.mapToPattern(this.formFields);
        Pattern pattern2 = this.body.exactMatchElseType();
        String string2 = this.method;
        HttpQueryParamPattern httpQueryParamPattern = new HttpQueryParamPattern(this.mapToQueryParameterPattern(this.queryParams), null, 2, null);
        HttpPathPattern httpPathPattern = new HttpPathPattern(HttpPathPatternKt.pathToPattern(pathForPattern), pathForPattern);
        HttpHeadersPattern httpHeadersPattern = new HttpHeadersPattern(this.mapToPattern(this.headers), null, null, 6, null);
        boolean $i$f$map = false;
        void var4_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.inferType());
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 128;
        List list = null;
        Collection<MultiPartFormDataPattern> collection2 = collection;
        Map<String, Pattern> map3 = map2;
        Pattern pattern3 = pattern2;
        String string3 = string2;
        HttpQueryParamPattern httpQueryParamPattern2 = httpQueryParamPattern;
        HttpPathPattern httpPathPattern2 = httpPathPattern;
        HttpHeadersPattern httpHeadersPattern2 = httpHeadersPattern;
        return new HttpRequestPattern(httpHeadersPattern2, httpPathPattern2, httpQueryParamPattern2, string3, pattern3, map3, (List)collection2, list, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> mapToPattern(Map<String, String> map2) {
        void $this$mapValuesTo$iv$iv;
        Map<String, String> $this$mapValues$iv = map2;
        boolean $i$f$mapValues = false;
        Map<String, String> map3 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map4 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map5 = map4;
            boolean bl2 = false;
            String value2 = (String)entry2.getValue();
            Pattern pattern2 = GrammarKt.isPatternToken(value2) ? GrammarKt.parsedPattern$default(value2, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(value2), null, false, 6, null);
            map5.put(k, pattern2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, Pattern> mapToQueryParameterPattern(QueryParameters queryParams2) {
        void $this$mapTo$iv$iv;
        Map queryParamGroups;
        Object object;
        Map $this$mapValuesTo$iv$iv;
        Map $this$getOrPut$iv$iv$iv;
        Object key$iv$iv;
        Map $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = queryParams2.getParamPairs();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator<Object> iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object t = iterator.next();
            Pair it = (Pair)t;
            boolean bl = false;
            key$iv$iv = (String)it.getFirst();
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(t);
        }
        Map $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean bl = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapTo$iv$iv2;
            void it$iv$iv;
            key$iv$iv = (Map.Entry)element$iv$iv$iv;
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean bl2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = $this$getOrPut$iv$iv$iv;
            boolean bl3 = false;
            List keyValuePairs = (List)entry.getValue();
            Iterable $this$map$iv = keyValuePairs;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                String value2 = (String)pair.component2();
                collection.add(GrammarKt.isPatternToken(value2) ? GrammarKt.parsedPattern$default(value2, null, null, 6, null) : (Pattern)new ExactValuePattern(new StringValue(value2), null, false, 6, null));
            }
            List list = (List)destination$iv$iv2;
            object.put(k, list);
        }
        Map $this$map$iv = queryParamGroups = destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapValuesTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
            Map.Entry entry2 = entry;
            object = destination$iv$iv;
            boolean bl3 = false;
            String parameterKey = (String)entry2.getKey();
            List parameterPatterns = (List)entry2.getValue();
            object.add(parameterPatterns.size() > 1 ? TuplesKt.to((Object)parameterKey, (Object)new QueryParameterArrayPattern(parameterPatterns, parameterKey)) : TuplesKt.to((Object)parameterKey, (Object)new QueryParameterScalarPattern((Pattern)CollectionsKt.single((List)parameterPatterns))));
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    public final void buildKTORRequest(@NotNull HttpRequestBuilder httpRequestBuilder, @Nullable URL url) {
        HttpRequestBuilder $this$forEach$iv;
        Iterator $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Triple it;
        Object object;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)httpRequestBuilder, (String)"httpRequestBuilder");
        String string = this.method;
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type kotlin.String");
        httpRequestBuilder.setMethod(HttpMethod.Companion.parse(string));
        List<String> listOfExcludedHeaders = HttpRequestKt.listOfExcludedHeaders();
        Map<String, String> map2 = this.withoutDuplicateHostHeader(this.headers, url);
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            object = destination$iv$iv;
            boolean bl = false;
            String string2 = ((Object)StringsKt.trim((CharSequence)((String)it.getKey()))).toString();
            String string3 = ((Object)StringsKt.trim((CharSequence)((String)it.getKey()))).toString().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            object.add(new Triple((Object)string2, (Object)string3, (Object)((Object)StringsKt.trim((CharSequence)((String)it.getValue()))).toString()));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv = iterator.next();
            it = (Triple)element$iv$iv;
            boolean bl = false;
            String loweredKey = (String)it.component2();
            if (!(!listOfExcludedHeaders.contains(loweredKey))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple $i$f$filterTo2 = (Triple)element$iv;
            boolean bl = false;
            String key2 = (String)$i$f$filterTo2.component1();
            String value2 = (String)$i$f$filterTo2.component3();
            UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)httpRequestBuilder), (String)key2, (Object)value2);
        }
        URLBuilder it2 = httpRequestBuilder.getUrl();
        boolean bl = false;
        if (it2.getPort() == 0 || it2.getPort() == it2.getProtocol().getDefaultPort()) {
            UtilsKt.header((HttpMessageBuilder)((HttpMessageBuilder)httpRequestBuilder), (String)"Host", (Object)URLBuilderKt.getAuthority((URLBuilder)it2));
        }
        if (!(this.body instanceof NoBodyValue)) {
            void body$iv;
            OutgoingContent outgoingContent;
            Object parameters;
            $this$forEach$iv = httpRequestBuilder;
            if (!this.formFields.isEmpty()) {
                void $this$mapValuesTo$iv$iv;
                Pair[] $this$mapValues$iv = this.formFields;
                boolean $i$f$mapValues = false;
                Pair[] $i$f$filterTo2 = $this$mapValues$iv;
                Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
                boolean $i$f$mapValuesTo = false;
                Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                    void it3;
                    void it$iv$iv;
                    Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                    Map map3 = destination$iv$iv2;
                    boolean bl2 = false;
                    Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                    Object k = it$iv$iv.getKey();
                    object = map3;
                    boolean bl3 = false;
                    List list = CollectionsKt.listOf(it3.getValue());
                    object.put(k, list);
                }
                parameters = MapsKt.toList((Map)destination$iv$iv2);
                Collection $this$toTypedArray$iv = (Collection)parameters;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$mapValues$iv = thisCollection$iv.toArray(new Pair[0]);
                outgoingContent = (OutgoingContent)new FormDataContent(ParametersKt.parametersOf((Pair[])Arrays.copyOf($this$mapValues$iv, $this$mapValues$iv.length)));
            } else if (!((Collection)this.multiPartFormData).isEmpty()) {
                outgoingContent = (OutgoingContent)new MultiPartFormDataContent(FormDslKt.formData((Function1)((Function1)new Function1<FormBuilder, Unit>(this){
                    final /* synthetic */ HttpRequest this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull FormBuilder $this$formData) {
                        Intrinsics.checkNotNullParameter((Object)$this$formData, (String)"$this$formData");
                        Iterable $this$forEach$iv = this.this$0.getMultiPartFormData();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            MultiPartFormDataValue value2 = (MultiPartFormDataValue)element$iv;
                            boolean bl = false;
                            value2.addTo($this$formData);
                        }
                    }
                })), null, null, 6, null);
            } else {
                TextContent textContent;
                if (this.headers.containsKey("Content-Type")) {
                    String string4 = this.getBodyString();
                    String string5 = this.headers.get("Content-Type");
                    Intrinsics.checkNotNull((Object)string5, (String)"null cannot be cast to non-null type kotlin.String");
                    textContent = new TextContent(string4, ContentType.Companion.parse(string5), null, 4, null);
                } else {
                    textContent = new TextContent(this.getBodyString(), ContentType.Companion.parse(this.body.getHttpContentType()), null, 4, null);
                }
                outgoingContent = (OutgoingContent)textContent;
            }
            parameters = outgoingContent;
            boolean $i$f$setBody = false;
            void var7_11 = body$iv;
            if (var7_11 instanceof OutgoingContent) {
                $this$setBody$iv.setBody((Object)body$iv);
                $this$setBody$iv.setBodyType(null);
            } else {
                $this$setBody$iv.setBody((Object)body$iv);
                boolean $i$f$typeInfo = false;
                KType kType$iv$iv = Reflection.typeOf(OutgoingContent.class);
                Type reifiedType$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv);
                $this$setBody$iv.setBodyType(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(OutgoingContent.class), (KType)kType$iv$iv));
            }
        }
    }

    private final Map<String, String> withoutDuplicateHostHeader(Map<String, String> headers2, URL url) {
        if (url == null) {
            return headers2;
        }
        String string = url.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        if (this.isNotIPAddress(string)) {
            return MapsKt.minus(headers2, (Object)"Host");
        }
        return headers2;
    }

    private final boolean isNotIPAddress(String host) {
        return !this.isIPAddress(host) && !Intrinsics.areEqual((Object)host, (Object)"localhost");
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isIPAddress(String host) {
        boolean bl;
        try {
            void $this$mapTo$iv$iv;
            String[] stringArray = new String[]{"."};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)host, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(Integer.parseInt((String)it));
            }
            bl = !((Collection)((List)destination$iv$iv)).isEmpty();
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpRequest loadFileContentIntoParts() {
        void $this$mapTo$iv$iv;
        List<MultiPartFormDataValue> parts = this.multiPartFormData;
        Iterable $this$map$iv = parts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            MultiPartFormDataValue multiPartFormDataValue;
            void part;
            MultiPartFormDataValue multiPartFormDataValue2 = (MultiPartFormDataValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = part;
            if (var12_11 instanceof MultiPartContentValue) {
                multiPartFormDataValue = part;
            } else if (var12_11 instanceof MultiPartFileValue) {
                File partFile = new File(StringsKt.removePrefix((String)((MultiPartFileValue)part).getFilename(), (CharSequence)"@"));
                MultiPartContent binaryContent = partFile.exists() ? new MultiPartContent(partFile) : new MultiPartContent(new StringPattern(null, null, null, null, null, 31, null).generate(new Resolver()).toStringLiteral());
                multiPartFormDataValue = MultiPartFileValue.copy$default((MultiPartFileValue)part, null, null, null, null, binaryContent, null, 47, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            collection.add(multiPartFormDataValue);
        }
        List newMultiPartFormData = (List)destination$iv$iv;
        return HttpRequest.copy$default(this, null, null, null, null, null, null, newMultiPartFormData, null, 191, null);
    }

    @NotNull
    public final String requestNotRecognized(@NotNull RequestNotRecognizedMessages requestNotRecognizedMessages) {
        Intrinsics.checkNotNullParameter((Object)requestNotRecognizedMessages, (String)"requestNotRecognizedMessages");
        String soapActionHeader = "SOAPAction";
        String string = this.method;
        Intrinsics.checkNotNull((Object)string);
        String method = string;
        String string2 = this.path;
        if (string2 == null) {
            string2 = "/";
        }
        String path2 = string2;
        return this.headers.containsKey(soapActionHeader) ? requestNotRecognizedMessages.soap((String)MapsKt.getValue(this.headers, (Object)soapActionHeader), path2) : (this.body instanceof XMLNode ? requestNotRecognizedMessages.xmlOverHttp(method, path2) : requestNotRecognizedMessages.restful(method, path2));
    }

    @NotNull
    public final String requestNotRecognized() {
        return this.requestNotRecognized(new LenientRequestNotRecognizedMessages());
    }

    @NotNull
    public final String requestNotRecognizedInStrictMode() {
        return this.requestNotRecognized(new StrictRequestNotRecognizedMessages());
    }

    @NotNull
    public final HttpRequest withoutDynamicHeaders() {
        return HttpRequest.copy$default(this, null, null, HttpHeadersPatternKt.withoutDynamicHeaders(this.headers), null, null, null, null, null, 251, null);
    }

    @NotNull
    public final HttpRequest addSecurityHeader(@NotNull String headerName, @NotNull String headerValue) {
        Intrinsics.checkNotNullParameter((Object)headerName, (String)"headerName");
        Intrinsics.checkNotNullParameter((Object)headerValue, (String)"headerValue");
        HttpRequestMetadata updatedMetadata = this.metadata.copy(SetsKt.plus(this.metadata.getSecurityHeaderNames(), (Object)headerName));
        Map<String, String> $this$filterKeys$iv = this.headers;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
            String key2 = entry$iv.getKey();
            boolean bl = false;
            if (!(!StringsKt.equals((String)key2, (String)headerName, (boolean)true))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map updatedHeaders = MapsKt.plus((Map)result$iv, (Pair)TuplesKt.to((Object)headerName, (Object)headerValue));
        return HttpRequest.copy$default(this, null, null, updatedHeaders, null, null, null, null, updatedMetadata, 123, null);
    }

    @Nullable
    public final String component1() {
        return this.method;
    }

    @Nullable
    public final String component2() {
        return this.path;
    }

    @NotNull
    public final Map<String, String> component3() {
        return this.headers;
    }

    @NotNull
    public final Value component4() {
        return this.body;
    }

    @NotNull
    public final QueryParameters component5() {
        return this.queryParams;
    }

    @NotNull
    public final Map<String, String> component6() {
        return this.formFields;
    }

    @NotNull
    public final List<MultiPartFormDataValue> component7() {
        return this.multiPartFormData;
    }

    @NotNull
    public final HttpRequestMetadata component8() {
        return this.metadata;
    }

    @NotNull
    public final HttpRequest copy(@Nullable String method, @Nullable String path2, @NotNull Map<String, String> headers2, @NotNull Value body, @NotNull QueryParameters queryParams2, @NotNull Map<String, String> formFields, @NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull HttpRequestMetadata metadata) {
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)queryParams2, (String)"queryParams");
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        return new HttpRequest(method, path2, headers2, body, queryParams2, formFields, multiPartFormData, metadata);
    }

    public static /* synthetic */ HttpRequest copy$default(HttpRequest httpRequest, String string, String string2, Map map2, Value value2, QueryParameters queryParameters, Map map3, List list, HttpRequestMetadata httpRequestMetadata, int n, Object object) {
        if ((n & 1) != 0) {
            string = httpRequest.method;
        }
        if ((n & 2) != 0) {
            string2 = httpRequest.path;
        }
        if ((n & 4) != 0) {
            map2 = httpRequest.headers;
        }
        if ((n & 8) != 0) {
            value2 = httpRequest.body;
        }
        if ((n & 0x10) != 0) {
            queryParameters = httpRequest.queryParams;
        }
        if ((n & 0x20) != 0) {
            map3 = httpRequest.formFields;
        }
        if ((n & 0x40) != 0) {
            list = httpRequest.multiPartFormData;
        }
        if ((n & 0x80) != 0) {
            httpRequestMetadata = httpRequest.metadata;
        }
        return httpRequest.copy(string, string2, map2, value2, queryParameters, map3, list, httpRequestMetadata);
    }

    @NotNull
    public String toString() {
        return "HttpRequest(method=" + this.method + ", path=" + this.path + ", headers=" + this.headers + ", body=" + this.body + ", queryParams=" + this.queryParams + ", formFields=" + this.formFields + ", multiPartFormData=" + this.multiPartFormData + ", metadata=" + this.metadata + ")";
    }

    public int hashCode() {
        int result2 = this.method == null ? 0 : this.method.hashCode();
        result2 = result2 * 31 + (this.path == null ? 0 : this.path.hashCode());
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + this.queryParams.hashCode();
        result2 = result2 * 31 + ((Object)this.formFields).hashCode();
        result2 = result2 * 31 + ((Object)this.multiPartFormData).hashCode();
        result2 = result2 * 31 + this.metadata.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpRequest)) {
            return false;
        }
        HttpRequest httpRequest = (HttpRequest)other;
        if (!Intrinsics.areEqual((Object)this.method, (Object)httpRequest.method)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)httpRequest.path)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpRequest.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)httpRequest.body)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.queryParams, (Object)httpRequest.queryParams)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.formFields, httpRequest.formFields)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.multiPartFormData, httpRequest.multiPartFormData)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.metadata, (Object)httpRequest.metadata);
    }

    public HttpRequest() {
        this(null, null, null, null, null, null, null, null, 255, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lio/specmatic/core/HttpRequest$LenientRequestNotRecognizedMessages;", "Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "()V", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "core"})
    public static final class LenientRequestNotRecognizedMessages
    implements RequestNotRecognizedMessages {
        @Override
        @NotNull
        public String soap(@NotNull String soapActionHeaderValue, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)soapActionHeaderValue, (String)"soapActionHeaderValue");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching SOAP stub or contract found for SOAPAction " + soapActionHeaderValue + " and path " + path2;
        }

        @Override
        @NotNull
        public String xmlOverHttp(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching XML-REST stub or contract found for method " + method + " and path " + path2;
        }

        @Override
        @NotNull
        public String restful(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching REST stub or contract found for method " + method + " and path " + path2;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&\u00a8\u0006\t"}, d2={"Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "core"})
    public static interface RequestNotRecognizedMessages {
        @NotNull
        public String soap(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String xmlOverHttp(@NotNull String var1, @NotNull String var2);

        @NotNull
        public String restful(@NotNull String var1, @NotNull String var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\n"}, d2={"Lio/specmatic/core/HttpRequest$StrictRequestNotRecognizedMessages;", "Lio/specmatic/core/HttpRequest$RequestNotRecognizedMessages;", "()V", "restful", "", "method", "path", "soap", "soapActionHeaderValue", "xmlOverHttp", "core"})
    public static final class StrictRequestNotRecognizedMessages
    implements RequestNotRecognizedMessages {
        @Override
        @NotNull
        public String soap(@NotNull String soapActionHeaderValue, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)soapActionHeaderValue, (String)"soapActionHeaderValue");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching SOAP stub (strict mode) found for SOAPAction " + soapActionHeaderValue + " and path " + path2;
        }

        @Override
        @NotNull
        public String xmlOverHttp(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching XML-REST stub (strict mode) found for method " + method + " and path " + path2;
        }

        @Override
        @NotNull
        public String restful(@NotNull String method, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return "No matching REST stub (strict mode) found for method " + method + " and path " + path2;
        }
    }
}

