/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.ktor.http.HttpHeaders;
import io.specmatic.conversions.PostmanKt;
import io.specmatic.core.ExampleDeclarations;
import io.specmatic.core.GherkinClause;
import io.specmatic.core.GherkinClauseKt;
import io.specmatic.core.GherkinSection;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpRequestKt;
import io.specmatic.core.MultiPartContentValue;
import io.specmatic.core.MultiPartFileValue;
import io.specmatic.core.MultiPartFormDataValue;
import io.specmatic.core.QueryParameters;
import io.specmatic.core.URLParts;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.DeferredPattern;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.utilities.Flags;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.JSONObjectValueKt;
import io.specmatic.core.value.NullValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.UseExampleDeclarations;
import io.specmatic.core.value.Value;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001aN\u0010\b\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000e\u001a\u000e\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001a\u000e\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001\u001aN\u0010\u0016\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0017\u001a\u00020\u000e\u001aZ\u0010\u0018\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000e\u001a\u000e\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u001aT\u0010\u001d\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\n2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0012\u001a\u00020\u000e\u001a$\u0010 \u001a\u0004\u0018\u00010\u00012\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010!\u001a\u00020\u0001\u001a0\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010!\u001a\u00020\u0001H\u0000\u001a\u0016\u0010#\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a\u0016\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001\u001a$\u0010&\u001a\u00020\u001f2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a\u001a\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010*\u001a\u00020+\u001a\u001a\u0010,\u001a\u00020\u00102\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f\u001a8\u0010-\u001a\u00020.2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0006002\u0006\u0010!\u001a\u00020\u00012\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\fH\u0002\u001a\u000e\u00102\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u0001\u001a\u0018\u00103\u001a\u00020\u00012\u0006\u00104\u001a\u00020\u00012\u0006\u00105\u001a\u00020\u0001H\u0000\u001a&\u00106\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00060\f2\u0012\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f\u001a2\u00108\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u000e\u00109\u001a\u00020\u00012\u0006\u0010:\u001a\u00020\u0001\u001a\u001a\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010<\u001a\u00020=\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"FORM_FIELDS_JSON_KEY", "", "MULTIPART_FORMDATA_JSON_KEY", "arrayValue", "Lio/specmatic/core/value/JSONArrayValue;", "value", "Lio/specmatic/core/value/Value;", "errorMessage", "bodyToGherkin", "Lkotlin/Triple;", "", "Lio/specmatic/core/GherkinClause;", "", "Lio/specmatic/core/pattern/Pattern;", "Lio/specmatic/core/ExampleDeclarations;", "request", "Lio/specmatic/core/HttpRequest;", "types", "exampleDeclarations", "decodePath", "path", "escapeSpaceInPath", "firstLineToGherkin", "exampleDeclarationsStore", "formFieldsToGherkin", "formFields", "formatJson", "json", "listOfExcludedHeaders", "multiPartFormDataToGherkin", "multiPartFormData", "Lio/specmatic/core/MultiPartFormDataValue;", "nativeString", "key", "nativeStringStringMap", "notNull", "objectValue", "Lio/specmatic/core/value/JSONObjectValue;", "parsePartType", "multiPartSpec", "name", "queryParamsToValueMap", "queryParams", "Lio/specmatic/core/QueryParameters;", "requestFromJSON", "setIfNotEmpty", "", "dest", "", "data", "singleLineJson", "startLinesWith", "str", "startValue", "stringMapToValueMap", "stringStringMap", "toGherkinClauses", "urlDecodePathSegments", "url", "urlToQueryParams", "uri", "Ljava/net/URI;", "core"})
@SourceDebugExtension(value={"SMAP\nHttpRequest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpRequest.kt\nio/specmatic/core/HttpRequestKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,658:1\n1179#2,2:659\n1253#2,4:661\n1238#2,4:667\n1549#2:671\n1620#2,3:672\n1238#2,4:677\n1238#2,4:684\n1179#2,2:688\n1253#2,4:690\n1789#2,3:694\n1549#2:697\n1620#2,3:698\n1549#2:701\n1620#2,3:702\n453#3:665\n403#3:666\n453#3:675\n403#3:676\n453#3:682\n403#3:683\n1#4:681\n*S KotlinDebug\n*F\n+ 1 HttpRequest.kt\nio/specmatic/core/HttpRequestKt\n*L\n29#1:659,2\n29#1:661,4\n392#1:667,4\n428#1:671\n428#1:672,3\n499#1:677,4\n531#1:684,4\n534#1:688,2\n534#1:690,4\n558#1:694,3\n614#1:697\n614#1:698,3\n626#1:701\n626#1:702,3\n392#1:665\n392#1:666\n499#1:675\n499#1:676\n531#1:682\n531#1:683\n*E\n"})
public final class HttpRequestKt {
    @NotNull
    public static final String FORM_FIELDS_JSON_KEY = "form-fields";
    @NotNull
    public static final String MULTIPART_FORMDATA_JSON_KEY = "multipart-formdata";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> urlToQueryParams(@NotNull URI uri) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (uri.getQuery() == null) {
            return MapsKt.emptyMap();
        }
        String string = uri.getQuery();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getQuery(...)");
        String[] stringArray = new String[]{"&"};
        Iterable $this$associate$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            Regex regex = new Regex("=");
            int n = 2;
            List parts = regex.split(charSequence, n);
            Pair pair = new Pair(parts.get(0), parts.get(1));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final void setIfNotEmpty(Map<String, Value> dest, String key2, Map<String, String> data2) {
        if (!data2.isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            Map<String, Value> map2 = dest;
            Map<String, String> $this$mapValues$iv = data2;
            boolean $i$f$mapValues = false;
            Map<String, String> map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map5 = map4;
                boolean bl2 = false;
                StringValue stringValue = new StringValue((String)it.getValue());
                map5.put(k, stringValue);
            }
            Map map6 = destination$iv$iv;
            JSONObjectValue jSONObjectValue = new JSONObjectValue(map6);
            map2.put(key2, jSONObjectValue);
        }
    }

    @Nullable
    public static final String nativeString(@NotNull Map<String, ? extends Value> json2, @NotNull String key2) {
        Intrinsics.checkNotNullParameter(json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Value value2 = json2.get(key2);
        if (value2 == null) {
            return null;
        }
        Value keyValue = value2;
        if (!(keyValue instanceof StringValue)) {
            throw new ContractException("Expected " + key2 + " to be a string value", null, null, null, false, 30, null);
        }
        return ((StringValue)keyValue).getString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final HttpRequest requestFromJSON(@NotNull Map<String, ? extends Value> json2) {
        HttpRequest httpRequest;
        Intrinsics.checkNotNullParameter(json2, (String)"json");
        String string = HttpRequestKt.nativeString(json2, "method");
        if (string == null) {
            throw new ContractException("http-request must contain a key named method whose value is the method in the request", null, null, null, false, 30, null);
        }
        HttpRequest httpRequest2 = new HttpRequest(null, null, null, null, null, null, null, null, 255, null).updateMethod(string);
        String string2 = HttpRequestKt.nativeString(json2, "path");
        if (string2 == null) {
            string2 = "/";
        }
        HttpRequest httpRequest3 = httpRequest2.updatePath(string2).updateQueryParams(HttpRequestKt.nativeStringStringMap(json2, "query")).setHeaders(HttpRequestKt.nativeStringStringMap(json2, "headers"));
        boolean bl = false;
        if (json2.containsKey(FORM_FIELDS_JSON_KEY)) {
            httpRequest = HttpRequest.copy$default(httpRequest3, null, null, null, null, null, HttpRequestKt.nativeStringStringMap(json2, FORM_FIELDS_JSON_KEY), null, null, 223, null);
        } else if (json2.containsKey(MULTIPART_FORMDATA_JSON_KEY)) {
            void $this$mapTo$iv$iv;
            JSONArrayValue parts = HttpRequestKt.arrayValue((Value)MapsKt.getValue(json2, (Object)MULTIPART_FORMDATA_JSON_KEY), "multipart-formdata must be a json array.");
            Iterable $this$map$iv = parts.getList();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String name;
                void it;
                Value value2 = (Value)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                JSONObjectValue part = HttpRequestKt.objectValue((Value)it, "All multipart parts must be json object values.");
                Map<String, Value> multiPartSpec = part.getJsonObject();
                if (HttpRequestKt.nativeString(multiPartSpec, "name") == null) {
                    throw new ContractException("One of the multipart entries does not have a name key", null, null, null, false, 30, null);
                }
                collection.add(HttpRequestKt.parsePartType(multiPartSpec, name));
            }
            List multiPartData = (List)destination$iv$iv;
            httpRequest = HttpRequest.copy$default(httpRequest3, null, null, null, null, null, null, CollectionsKt.plus((Collection)httpRequest3.getMultiPartFormData(), (Iterable)multiPartData), null, 191, null);
        } else if (json2.containsKey("body")) {
            Value body = HttpRequestKt.notNull(json2.getOrDefault("body", NullValue.INSTANCE), "Either body should have a value or the key should be absent from http-response");
            httpRequest = httpRequest3.updateBody(body);
        } else {
            httpRequest = httpRequest3;
        }
        return httpRequest;
    }

    private static final MultiPartFormDataValue parsePartType(Map<String, ? extends Value> multiPartSpec, String name) {
        MultiPartFormDataValue multiPartFormDataValue;
        if (multiPartSpec.containsKey("content")) {
            Value value2 = multiPartSpec.get("contentType");
            multiPartFormDataValue = new MultiPartContentValue(name, (Value)MapsKt.getValue(multiPartSpec, (Object)"content"), null, value2 != null ? value2.toStringLiteral() : null, 4, null);
        } else if (multiPartSpec.containsKey("filename")) {
            Value value3 = multiPartSpec.get("contentType");
            Value value4 = multiPartSpec.get("contentEncoding");
            multiPartFormDataValue = new MultiPartFileValue(name, StringsKt.removePrefix((String)((Value)MapsKt.getValue(multiPartSpec, (Object)"filename")).toStringLiteral(), (CharSequence)"@"), value3 != null ? value3.toStringLiteral() : null, value4 != null ? value4.toStringLiteral() : null, null, null, 48, null);
        } else {
            throw new ContractException("Multipart entry " + name + " must have either a content key or a filename key", null, null, null, false, 30, null);
        }
        return multiPartFormDataValue;
    }

    @NotNull
    public static final JSONObjectValue objectValue(@NotNull Value value2, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (!(value2 instanceof JSONObjectValue)) {
            throw new ContractException(errorMessage, null, null, null, false, 30, null);
        }
        return (JSONObjectValue)value2;
    }

    @NotNull
    public static final JSONArrayValue arrayValue(@NotNull Value value2, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (!(value2 instanceof JSONArrayValue)) {
            throw new ContractException(errorMessage, null, null, null, false, 30, null);
        }
        return (JSONArrayValue)value2;
    }

    @NotNull
    public static final Value notNull(@NotNull Value value2, @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        if (value2 instanceof NullValue) {
            throw new ContractException(errorMessage, null, null, null, false, 30, null);
        }
        return value2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> nativeStringStringMap(@NotNull Map<String, ? extends Value> json2, @NotNull String key2) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(json2, (String)"json");
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        Value value2 = json2.get(key2);
        if (value2 == null) {
            return MapsKt.emptyMap();
        }
        Value queryValue = value2;
        if (!(queryValue instanceof JSONObjectValue)) {
            throw new ContractException("Expected " + key2 + " to be a json object", null, null, null, false, 30, null);
        }
        Map<String, Value> $this$mapValues$iv = ((JSONObjectValue)queryValue).getJsonObject();
        boolean $i$f$mapValues = false;
        Map<String, Value> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String string = it.getValue().toString();
            map4.put(k, string);
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final String startLinesWith(@NotNull String str, @NotNull String startValue) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        Intrinsics.checkNotNullParameter((Object)startValue, (String)"startValue");
        String[] stringArray = new String[]{"\n"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(startValue){
            final /* synthetic */ String $startValue;
            {
                this.$startValue = $startValue;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$startValue + it;
            }
        }), (int)30, null);
    }

    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> toGherkinClauses(@NotNull HttpRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Triple triple = new Triple((Object)CollectionsKt.emptyList(), (Object)MapsKt.emptyMap(), (Object)new UseExampleDeclarations(null, null, null, 7, null));
        boolean bl = false;
        List clauses = (List)triple.component1();
        Map types = (Map)triple.component2();
        UseExampleDeclarations exampleDeclaration = (UseExampleDeclarations)triple.component3();
        Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> triple2 = HttpRequestKt.firstLineToGherkin(request, types, exampleDeclaration);
        List newClauses = (List)triple2.component1();
        Map newTypes = (Map)triple2.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)triple2.component3();
        triple = new Triple((Object)CollectionsKt.plus((Collection)clauses, (Iterable)newClauses), (Object)newTypes, (Object)newExamples);
        boolean bl2 = false;
        clauses = (List)triple.component1();
        types = (Map)triple.component2();
        ExampleDeclarations examples = (ExampleDeclarations)triple.component3();
        triple2 = GherkinClauseKt.headersToGherkin(request.getHeaders(), "request-header", types, examples, GherkinSection.When);
        newClauses = (List)triple2.component1();
        newTypes = (Map)triple2.component2();
        newExamples = (ExampleDeclarations)triple2.component3();
        triple = new Triple((Object)CollectionsKt.plus((Collection)clauses, (Iterable)newClauses), (Object)newTypes, (Object)newExamples);
        boolean bl3 = false;
        clauses = (List)triple.component1();
        types = (Map)triple.component2();
        examples = (ExampleDeclarations)triple.component3();
        triple2 = HttpRequestKt.bodyToGherkin(request, types, examples);
        newClauses = (List)triple2.component1();
        newTypes = (Map)triple2.component2();
        newExamples = (ExampleDeclarations)triple2.component3();
        triple = new Triple((Object)CollectionsKt.plus((Collection)clauses, (Iterable)newClauses), (Object)newTypes, (Object)newExamples);
        boolean bl4 = false;
        clauses = (List)triple.component1();
        types = (Map)triple.component2();
        examples = (ExampleDeclarations)triple.component3();
        return new Triple((Object)clauses, (Object)types, (Object)examples);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Value> stringMapToValueMap(@NotNull Map<String, String> stringStringMap) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter(stringStringMap, (String)"stringStringMap");
        Map<String, String> $this$mapValues$iv = stringStringMap;
        boolean $i$f$mapValues = false;
        Map<String, String> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Value value2 = PostmanKt.guessType(GrammarKt.parsedValue((String)it.getValue()));
            map4.put(k, value2);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, Value> queryParamsToValueMap(@NotNull QueryParameters queryParams2) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)queryParams2, (String)"queryParams");
        Iterable $this$associate$iv = queryParams2.getParamPairs();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            String key2 = (String)pair.component1();
            String value2 = (String)pair.component2();
            pair = TuplesKt.to((Object)key2, (Object)PostmanKt.guessType(GrammarKt.parsedValue(value2)));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> bodyToGherkin(@NotNull HttpRequest request, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        return !((Collection)request.getMultiPartFormData()).isEmpty() ? HttpRequestKt.multiPartFormDataToGherkin(request.getMultiPartFormData(), types, exampleDeclarations) : (!request.getFormFields().isEmpty() ? HttpRequestKt.formFieldsToGherkin(request.getFormFields(), types, exampleDeclarations) : GherkinClauseKt.requestBodyToGherkinClauses(request.getBody(), types, exampleDeclarations));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> multiPartFormDataToGherkin(@NotNull List<? extends MultiPartFormDataValue> multiPartFormData, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter(multiPartFormData, (String)"multiPartFormData");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        Iterable iterable = multiPartFormData;
        Triple triple = new Triple((Object)CollectionsKt.emptyList(), types, (Object)exampleDeclarations);
        boolean $i$f$fold = false;
        Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void part;
            MultiPartFormDataValue multiPartFormDataValue = (MultiPartFormDataValue)element$iv;
            void var10_10 = accumulator$iv;
            boolean bl = false;
            List clauses = (List)var10_10.component1();
            Map newTypes = (Map)var10_10.component2();
            ExampleDeclarations examples = (ExampleDeclarations)var10_10.component3();
            accumulator$iv = part.toClauseData(clauses, newTypes, examples);
        }
        return accumulator$iv;
    }

    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> firstLineToGherkin(@NotNull HttpRequest request, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarationsStore) {
        Triple triple;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarationsStore, (String)"exampleDeclarationsStore");
        String string = request.getMethod();
        if (string == null) {
            throw new ContractException("Can't generate a spec file without the http method.", null, null, null, false, 30, null);
        }
        String method = string;
        if (request.getPath() == null) {
            throw new ContractException("Can't generate a contract without the url.", null, null, null, false, 30, null);
        }
        if (request.getQueryParams().isNotEmpty()) {
            Triple<Map<String, DeferredPattern>, Map<String, Pattern>, ExampleDeclarations> triple2 = JSONObjectValueKt.dictionaryToDeclarations(HttpRequestKt.queryParamsToValueMap(request.getQueryParams()), types, exampleDeclarationsStore);
            Map dictionaryType = (Map)triple2.component1();
            Map newTypes = (Map)triple2.component2();
            ExampleDeclarations examples = (ExampleDeclarations)triple2.component3();
            String query2 = CollectionsKt.joinToString$default((Iterable)dictionaryType.entrySet(), (CharSequence)"&", null, null, (int)0, null, (Function1)firstLineToGherkin.query.1.INSTANCE, (int)30, null);
            triple = new Triple((Object)("?" + query2), (Object)newTypes, (Object)examples);
        } else {
            triple = new Triple((Object)"", (Object)MapsKt.emptyMap(), (Object)exampleDeclarationsStore);
        }
        Triple triple3 = triple;
        String query3 = (String)triple3.component1();
        Map newTypes = (Map)triple3.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)triple3.component3();
        String path2 = HttpRequestKt.escapeSpaceInPath(request.getPath()) + query3;
        GherkinClause requestLineGherkin = new GherkinClause(method + " " + path2, GherkinSection.When);
        return new Triple((Object)CollectionsKt.listOf((Object)requestLineGherkin), (Object)newTypes, (Object)newExamples);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> formFieldsToGherkin(@NotNull Map<String, String> formFields, @NotNull Map<String, ? extends Pattern> types, @NotNull ExampleDeclarations exampleDeclarations) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(formFields, (String)"formFields");
        Intrinsics.checkNotNullParameter(types, (String)"types");
        Intrinsics.checkNotNullParameter((Object)exampleDeclarations, (String)"exampleDeclarations");
        Triple<Map<String, DeferredPattern>, Map<String, Pattern>, ExampleDeclarations> triple = JSONObjectValueKt.dictionaryToDeclarations(HttpRequestKt.stringMapToValueMap(formFields), types, exampleDeclarations);
        Map dictionaryTypeMap = (Map)triple.component1();
        Map newTypes = (Map)triple.component2();
        ExampleDeclarations newExamples = (ExampleDeclarations)triple.component3();
        Iterable $this$map$iv = dictionaryTypeMap.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void entry;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new GherkinClause("form-field " + entry.getKey() + " " + ((DeferredPattern)entry.getValue()).getPattern(), GherkinSection.When));
        }
        List formFieldClauses = (List)destination$iv$iv;
        return new Triple((Object)formFieldClauses, (Object)newTypes, (Object)exampleDeclarations.plus(newExamples));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> listOfExcludedHeaders() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Object[] objectArray = new String[]{HttpHeaders.INSTANCE.getContentLength(), HttpHeaders.INSTANCE.getContentType(), HttpHeaders.INSTANCE.getTransferEncoding(), HttpHeaders.INSTANCE.getUpgrade()};
        Iterable $this$map$iv = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)HttpHeaders.INSTANCE.getUnsafeHeadersList(), (Object[])objectArray));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = it.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            collection.add(string2);
        }
        return (List)var3_3;
    }

    @NotNull
    public static final String escapeSpaceInPath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{"/"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)path2, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)escapeSpaceInPath.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String urlDecodePathSegments(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (!StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2, null)) {
            return HttpRequestKt.decodePath(url);
        }
        return new URLParts(url).withDecodedPathSegments();
    }

    @NotNull
    public static final String decodePath(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        String[] stringArray = new String[]{"/"};
        return CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)path2, (String[])stringArray, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", null, null, (int)0, null, (Function1)decodePath.1.INSTANCE, (int)30, null);
    }

    @NotNull
    public static final String singleLineJson(@NotNull String json2) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        CharSequence charSequence = json2;
        Regex regex = new Regex("\\s*([{}\\[\\]:,])\\s*");
        String string = "$1";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("\\s+");
        string = " ";
        return regex.replace(charSequence, string);
    }

    @NotNull
    public static final String formatJson(@NotNull String json2) {
        Intrinsics.checkNotNullParameter((Object)json2, (String)"json");
        return Flags.Companion.getBooleanValue("SPECMATIC_PRETTY_PRINT", true) ? json2 : HttpRequestKt.singleLineJson(json2);
    }

    public static final /* synthetic */ void access$setIfNotEmpty(Map dest, String key2, Map data2) {
        HttpRequestKt.setIfNotEmpty(dest, key2, data2);
    }
}

