/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.ktor.http.HttpStatusCode;
import io.specmatic.core.HttpHeadersPatternKt;
import io.specmatic.core.HttpRequestKt;
import io.specmatic.core.HttpResponseKt;
import io.specmatic.core.NoBodyValue;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.value.EmptyStringKt;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.NullValue;
import io.specmatic.core.value.NumberValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\b\u0018\u0000 22\u00020\u0001:\u00012B3\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\bB\u0019\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J=\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\b\b\u0002\u0010\u0004\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J&\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00072\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\"\u001a\u00020\u001dH\u0002J\u0006\u0010#\u001a\u00020\u001dJ\u000e\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J\u0006\u0010&\u001a\u00020\u0005J\u0006\u0010'\u001a\u00020(J\u0010\u0010)\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020\u0005J\t\u0010+\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\tJ\u000e\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020\tJ\u0006\u0010/\u001a\u00020\u0000J\u0006\u00100\u001a\u00020\u0000J\u0006\u00101\u001a\u00020\u0000R\u0011\u0010\u0004\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u00063"}, d2={"Lio/specmatic/core/HttpResponse;", "", "status", "", "body", "", "headers", "", "(ILjava/lang/String;Ljava/util/Map;)V", "Lio/specmatic/core/value/Value;", "(ILio/specmatic/core/value/Value;)V", "externalisedResponseCommand", "(ILjava/util/Map;Lio/specmatic/core/value/Value;Ljava/lang/String;)V", "getBody", "()Lio/specmatic/core/value/Value;", "getExternalisedResponseCommand", "()Ljava/lang/String;", "getHeaders", "()Ljava/util/Map;", "getStatus", "()I", "statusText", "getStatusText", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "export", "bindings", "hashCode", "headersHasOnlyTextPlainContentTypeHeader", "isNotEmpty", "selectValue", "selector", "specmaticResultHeaderValue", "toJSON", "Lio/specmatic/core/value/JSONObjectValue;", "toLogString", "prefix", "toString", "updateBody", "updateBodyWith", "content", "withRandomResultHeader", "withoutDynamicHeaders", "withoutSpecmaticHeaders", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nHttpResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpResponse.kt\nio/specmatic/core/HttpResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,251:1\n1#2:252\n453#3:253\n403#3:254\n551#3:266\n536#3,6:267\n1238#4,4:255\n1789#4,3:263\n125#5:259\n152#5,3:260\n*S KotlinDebug\n*F\n+ 1 HttpResponse.kt\nio/specmatic/core/HttpResponse\n*L\n55#1:253\n55#1:254\n107#1:266\n107#1:267,6\n55#1:255,4\n97#1:263,3\n60#1:259\n60#1:260,3\n*E\n"})
public final class HttpResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int status;
    @NotNull
    private final Map<String, String> headers;
    @NotNull
    private final Value body;
    @NotNull
    private final String externalisedResponseCommand;
    @NotNull
    private static final HttpResponse ERROR_400 = new HttpResponse(400, "This request did not match any scenario.", MapsKt.emptyMap());
    @NotNull
    private static final HttpResponse OK = new HttpResponse(200, MapsKt.emptyMap(), null, null, 12, null);
    @NotNull
    private static final HttpResponse EMPTY = new HttpResponse(0, MapsKt.emptyMap(), null, null, 12, null);

    public HttpResponse(int status, @NotNull Map<String, String> headers2, @NotNull Value body, @NotNull String externalisedResponseCommand) {
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)externalisedResponseCommand, (String)"externalisedResponseCommand");
        this.status = status;
        this.headers = headers2;
        this.body = body;
        this.externalisedResponseCommand = externalisedResponseCommand;
    }

    public /* synthetic */ HttpResponse(int n, Map map2, Value value2, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"text/plain"));
        }
        if ((n2 & 4) != 0) {
            value2 = EmptyStringKt.getEmptyString();
        }
        if ((n2 & 8) != 0) {
            string = "";
        }
        this(n, map2, value2, string);
    }

    public final int getStatus() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final Value getBody() {
        return this.body;
    }

    @NotNull
    public final String getExternalisedResponseCommand() {
        return this.externalisedResponseCommand;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse(int status, @Nullable String body, @NotNull Map<String, String> headers2) {
        Object object;
        Map<String, String> map2;
        int n;
        HttpResponse httpResponse;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter(headers2, (String)"headers");
                httpResponse = this;
                n = status;
                map2 = headers2;
                object = body;
                if (object == null) break block2;
                String string = object;
                Map<String, String> map3 = map2;
                int n2 = n;
                HttpResponse httpResponse2 = httpResponse;
                boolean bl = false;
                Value value2 = GrammarKt.parsedValue((String)it);
                httpResponse = httpResponse2;
                n = n2;
                map2 = map3;
                Value value3 = value2;
                object = value3;
                if (value3 != null) break block3;
            }
            object = EmptyStringKt.getEmptyString();
        }
        httpResponse(n, map2, (Value)object, null, 8, null);
    }

    public /* synthetic */ HttpResponse(int n, String string, Map map2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            map2 = MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"text/plain"));
        }
        this(n, string, map2);
    }

    public HttpResponse(int status, @NotNull Value body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        this(status, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)body.getHttpContentType())), body, null, 8, null);
    }

    public /* synthetic */ HttpResponse(int n, Value value2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, value2);
    }

    private final String getStatusText() {
        return this.status == 0 ? "" : HttpStatusCode.Companion.fromValue(this.status).getDescription();
    }

    @NotNull
    public final String specmaticResultHeaderValue() {
        return this.headers.getOrDefault("X-Specmatic-Result", "success");
    }

    @NotNull
    public final HttpResponse updateBodyWith(@NotNull Value content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Map map2 = MapsKt.plus((Map)MapsKt.minus(this.headers, (Object)"Content-Type"), (Pair)TuplesKt.to((Object)"Content-Type", (Object)content.getHttpContentType()));
        return HttpResponse.copy$default(this, 0, map2, content, null, 9, null);
    }

    @NotNull
    public final HttpResponse updateBody(@NotNull Value body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return HttpResponse.copy$default(this, 0, null, body, null, 11, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JSONObjectValue toJSON() {
        Map map2;
        Map json2 = map2 = (Map)new LinkedHashMap();
        boolean bl = false;
        json2.put("status", new NumberValue(this.status));
        json2.put("body", this.body);
        if (((CharSequence)this.getStatusText()).length() > 0) {
            json2.put("status-text", new StringValue(this.getStatusText()));
        }
        if (!this.headers.isEmpty()) {
            void $this$mapValuesTo$iv$iv;
            Map map3 = json2;
            String string = "headers";
            Map<String, String> $this$mapValues$iv = this.headers;
            boolean $i$f$mapValues = false;
            Map<String, String> map4 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map5 = destination$iv$iv;
                boolean bl2 = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map6 = map5;
                boolean bl3 = false;
                StringValue stringValue = new StringValue((String)it.getValue());
                map6.put(k, stringValue);
            }
            Map map7 = destination$iv$iv;
            JSONObjectValue jSONObjectValue = new JSONObjectValue(map7);
            map3.put(string, jSONObjectValue);
        }
        Map map8 = map2;
        return new JSONObjectValue(map8);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toLogString(@NotNull String prefix2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix2, (String)"prefix");
        String statusLine = this.status + " " + this.getStatusText();
        Map<String, String> $this$map$iv = this.headers;
        boolean $i$f$map22 = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getKey() + ": " + it.getValue());
        }
        String headerString2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        Object[] $i$f$map22 = new String[]{statusLine, headerString2};
        String firstPart = ((Object)StringsKt.trim((CharSequence)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])$i$f$map22), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null))).toString();
        String formattedBody = HttpRequestKt.formatJson(this.body.toStringLiteral());
        Object[] objectArray = new String[]{firstPart, "", formattedBody};
        String responseString = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        return HttpRequestKt.startLinesWith(responseString, prefix2);
    }

    public static /* synthetic */ String toLogString$default(HttpResponse httpResponse, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return httpResponse.toLogString(string);
    }

    @NotNull
    public final String selectValue(@NotNull String selector) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        if (StringsKt.startsWith$default((String)selector, (String)"response-header.", (boolean)false, (int)2, null)) {
            String headerName = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)selector, (CharSequence)"response-header."))).toString();
            object = this.headers.get(headerName);
            if (object == null) {
                throw new ContractException("Couldn't find header name " + headerName + " specified in " + selector, null, null, null, false, 30, null);
            }
        } else if (StringsKt.startsWith$default((String)selector, (String)"response-body", (boolean)false, (int)2, null)) {
            String bodySelector = ((Object)StringsKt.trim((CharSequence)StringsKt.removePrefix((String)selector, (CharSequence)"response-body"))).toString();
            if (StringsKt.isBlank((CharSequence)bodySelector)) {
                object = this.body.toStringLiteral();
            } else {
                if (!(this.body instanceof JSONObjectValue)) {
                    throw new ContractException("JSON selector can only be used for JSON body", null, null, null, false, 30, null);
                }
                String jsonBodySelector = StringsKt.removePrefix((String)bodySelector, (CharSequence)".");
                object = ((JSONObjectValue)this.body).findFirstChildByPath(jsonBodySelector);
                if (object == null || (object = object.toStringLiteral()) == null) {
                    throw new ContractException("JSON selector " + selector + " was not found", null, null, null, false, 30, null);
                }
            }
        } else {
            throw new ContractException("Selector " + selector + " is unexpected. It must either start with response-header or response-body.", null, null, null, false, 30, null);
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> export(@NotNull Map<String, String> bindings) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(bindings, (String)"bindings");
        Iterable iterable = bindings.entrySet();
        Map initial$iv = MapsKt.emptyMap();
        boolean $i$f$fold = false;
        Map accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void setter;
            Map.Entry entry = (Map.Entry)element$iv;
            Map acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = MapsKt.plus((Map)acc, (Pair)TuplesKt.to(setter.getKey(), (Object)this.selectValue((String)setter.getValue())));
        }
        return accumulator$iv;
    }

    @NotNull
    public final HttpResponse withRandomResultHeader() {
        return HttpResponse.copy$default(this, 0, MapsKt.plus(this.headers, (Pair)TuplesKt.to((Object)"X-Specmatic-Type", (Object)"random")), null, null, 13, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final HttpResponse withoutSpecmaticHeaders() {
        void $this$filterNotTo$iv$iv;
        Map<String, String> $this$filterNot$iv = this.headers;
        boolean $i$f$filterNot = false;
        Map<String, String> map2 = $this$filterNot$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterNotTo = false;
        Iterator iterator = $this$filterNotTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (StringsKt.startsWith$default((String)((String)it.getKey()), (String)"X-Specmatic-", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map withoutSpecmaticHeaders = destination$iv$iv;
        return HttpResponse.copy$default(this, 0, withoutSpecmaticHeaders, null, null, 13, null);
    }

    @NotNull
    public final HttpResponse withoutDynamicHeaders() {
        return HttpResponse.copy$default(this, 0, HttpHeadersPatternKt.withoutDynamicHeaders(this.headers), null, null, 13, null);
    }

    public final boolean isNotEmpty() {
        boolean bodyIsEmpty = Intrinsics.areEqual((Object)this.body, (Object)NoBodyValue.INSTANCE);
        boolean headersIsEmpty = this.headers.isEmpty() || this.headersHasOnlyTextPlainContentTypeHeader();
        boolean responseIsEmpty = bodyIsEmpty && headersIsEmpty;
        return !responseIsEmpty;
    }

    private final boolean headersHasOnlyTextPlainContentTypeHeader() {
        return this.headers.size() == 1 && Intrinsics.areEqual((Object)this.headers.get("Content-Type"), (Object)"text/plain");
    }

    public final int component1() {
        return this.status;
    }

    @NotNull
    public final Map<String, String> component2() {
        return this.headers;
    }

    @NotNull
    public final Value component3() {
        return this.body;
    }

    @NotNull
    public final String component4() {
        return this.externalisedResponseCommand;
    }

    @NotNull
    public final HttpResponse copy(int status, @NotNull Map<String, String> headers2, @NotNull Value body, @NotNull String externalisedResponseCommand) {
        Intrinsics.checkNotNullParameter(headers2, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)externalisedResponseCommand, (String)"externalisedResponseCommand");
        return new HttpResponse(status, headers2, body, externalisedResponseCommand);
    }

    public static /* synthetic */ HttpResponse copy$default(HttpResponse httpResponse, int n, Map map2, Value value2, String string, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = httpResponse.status;
        }
        if ((n2 & 2) != 0) {
            map2 = httpResponse.headers;
        }
        if ((n2 & 4) != 0) {
            value2 = httpResponse.body;
        }
        if ((n2 & 8) != 0) {
            string = httpResponse.externalisedResponseCommand;
        }
        return httpResponse.copy(n, map2, value2, string);
    }

    @NotNull
    public String toString() {
        return "HttpResponse(status=" + this.status + ", headers=" + this.headers + ", body=" + this.body + ", externalisedResponseCommand=" + this.externalisedResponseCommand + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.status);
        result2 = result2 * 31 + ((Object)this.headers).hashCode();
        result2 = result2 * 31 + this.body.hashCode();
        result2 = result2 * 31 + this.externalisedResponseCommand.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpResponse)) {
            return false;
        }
        HttpResponse httpResponse = (HttpResponse)other;
        if (this.status != httpResponse.status) {
            return false;
        }
        if (!Intrinsics.areEqual(this.headers, httpResponse.headers)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.body, (Object)httpResponse.body)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.externalisedResponseCommand, (Object)httpResponse.externalisedResponseCommand);
    }

    public HttpResponse() {
        this(0, null, null, null, 15, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u0011\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013J\u0010\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0014J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0018J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u0019\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lio/specmatic/core/HttpResponse$Companion;", "", "()V", "EMPTY", "Lio/specmatic/core/HttpResponse;", "getEMPTY", "()Lio/specmatic/core/HttpResponse;", "ERROR_400", "getERROR_400", "OK", "getOK", "bodyToHttpResponse", "body", "", "status", "", "from", "fromJSON", "jsonObject", "", "Lio/specmatic/core/value/Value;", "jsonResponse", "jsonData", "ok", "", "xmlResponse", "xmlData", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpResponse getERROR_400() {
            return ERROR_400;
        }

        @NotNull
        public final HttpResponse getOK() {
            return OK;
        }

        @NotNull
        public final HttpResponse ok(@NotNull Number body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            NumberValue bodyValue = new NumberValue(body);
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())), bodyValue, null, 8, null);
        }

        @NotNull
        public final HttpResponse ok(@NotNull String body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            StringValue bodyValue = new StringValue(body);
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())), bodyValue, null, 8, null);
        }

        @NotNull
        public final HttpResponse ok(@NotNull Value body) {
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            return new HttpResponse(200, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)body.getHttpContentType())), body, null, 8, null);
        }

        @NotNull
        public final HttpResponse getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final HttpResponse jsonResponse(@Nullable String jsonData) {
            return new HttpResponse(200, jsonData, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/json")));
        }

        @NotNull
        public final HttpResponse xmlResponse(@Nullable String xmlData) {
            return new HttpResponse(200, xmlData, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Content-Type", (Object)"application/xml")));
        }

        @NotNull
        public final HttpResponse from(int status, @Nullable String body) {
            return this.bodyToHttpResponse(body, status);
        }

        private final HttpResponse bodyToHttpResponse(String body, int status) {
            Value bodyValue = GrammarKt.parsedValue(body);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Content-Type", (Object)bodyValue.getHttpContentType())};
            return new HttpResponse(status, MapsKt.mutableMapOf((Pair[])pairArray), bodyValue, null, 8, null);
        }

        @NotNull
        public final HttpResponse fromJSON(@NotNull Map<String, ? extends Value> jsonObject) {
            Intrinsics.checkNotNullParameter(jsonObject, (String)"jsonObject");
            Value body = jsonObject.get("body");
            if (body instanceof NullValue) {
                throw new ContractException("Either body should have a value or the key should be absent from http-request", null, null, null, false, 30, null);
            }
            Integer n = HttpResponseKt.nativeInteger(jsonObject, "status");
            if (n == null) {
                throw new ContractException("http-response must contain a key named status, whose value is the http status in the response", null, null, null, false, 30, null);
            }
            return new HttpResponse((int)n, MapsKt.toMutableMap(HttpRequestKt.nativeStringStringMap(jsonObject, "headers")), jsonObject.getOrDefault("body", NoBodyValue.INSTANCE), jsonObject.getOrDefault("externalisedResponseCommand", (Value)((Object)"")).toString());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

