/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.ktor.client.request.forms.FormBuilder;
import io.ktor.http.ContentType;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HeaderValueWithParametersKt;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.util.StringValuesBuilder;
import io.specmatic.core.ExampleDeclarations;
import io.specmatic.core.GherkinClause;
import io.specmatic.core.GherkinSection;
import io.specmatic.core.MultiPartContentPattern;
import io.specmatic.core.MultiPartFormDataPattern;
import io.specmatic.core.MultiPartFormDataValue;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.TypeDeclaration;
import io.specmatic.core.value.Value;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J3\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\b\u0010 \u001a\u00020!H\u0016JV\u0010\"\u001a&\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020'0&\u0012\u0004\u0012\u00020(0#2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020%0$2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020'0&2\u0006\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020\u0003H\u0016J\b\u0010-\u001a\u00020.H\u0016J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\n\u00a8\u00060"}, d2={"Lio/specmatic/core/MultiPartContentValue;", "Lio/specmatic/core/MultiPartFormDataValue;", "name", "", "content", "Lio/specmatic/core/value/Value;", "boundary", "specifiedContentType", "(Ljava/lang/String;Lio/specmatic/core/value/Value;Ljava/lang/String;Ljava/lang/String;)V", "getBoundary", "()Ljava/lang/String;", "getContent", "()Lio/specmatic/core/value/Value;", "contentType", "getContentType", "getName", "getSpecifiedContentType", "addTo", "", "formBuilder", "Lio/ktor/client/request/forms/FormBuilder;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "inferType", "Lio/specmatic/core/MultiPartFormDataPattern;", "toClauseData", "Lkotlin/Triple;", "", "Lio/specmatic/core/GherkinClause;", "", "Lio/specmatic/core/pattern/Pattern;", "Lio/specmatic/core/ExampleDeclarations;", "clauses", "newTypes", "examples", "toDisplayableValue", "toJSONObject", "Lio/specmatic/core/value/JSONObjectValue;", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nMultiPartFormDataValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MultiPartFormDataValue.kt\nio/specmatic/core/MultiPartContentValue\n+ 2 Headers.kt\nio/ktor/http/Headers$Companion\n*L\n1#1,191:1\n24#2:192\n*S KotlinDebug\n*F\n+ 1 MultiPartFormDataValue.kt\nio/specmatic/core/MultiPartContentValue\n*L\n55#1:192\n*E\n"})
public final class MultiPartContentValue
extends MultiPartFormDataValue {
    @NotNull
    private final String name;
    @NotNull
    private final Value content;
    @NotNull
    private final String boundary;
    @Nullable
    private final String specifiedContentType;

    public MultiPartContentValue(@NotNull String name, @NotNull Value content, @NotNull String boundary, @Nullable String specifiedContentType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        String string = specifiedContentType;
        if (string == null) {
            string = content.getHttpContentType();
        }
        super(name, string, null);
        this.name = name;
        this.content = content;
        this.boundary = boundary;
        this.specifiedContentType = specifiedContentType;
    }

    public /* synthetic */ MultiPartContentValue(String string, Value value2, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "#####";
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        this(string, value2, string2, string3);
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final Value getContent() {
        return this.content;
    }

    @NotNull
    public final String getBoundary() {
        return this.boundary;
    }

    @Nullable
    public final String getSpecifiedContentType() {
        return this.specifiedContentType;
    }

    @Override
    @NotNull
    public String getContentType() {
        String string = this.specifiedContentType;
        if (string == null) {
            string = this.content.getHttpContentType();
        }
        return string;
    }

    @Override
    @NotNull
    public MultiPartFormDataPattern inferType() {
        return new MultiPartContentPattern(this.getName(), this.content.exactMatchElseType(), this.getContentType());
    }

    @Override
    @NotNull
    public String toDisplayableValue() {
        return ((Object)StringsKt.trim((CharSequence)("\n--" + this.boundary + "\nContent-Disposition: form-data; name=\"" + this.getName() + "\"\nContent-Type: " + this.getContentType() + "\n\n" + this.content + "\n"))).toString();
    }

    @Override
    @NotNull
    public JSONObjectValue toJSONObject() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"name", (Object)new StringValue(this.getName())), TuplesKt.to((Object)"content", (Object)new StringValue(this.content.toStringLiteral())), TuplesKt.to((Object)"contentType", (Object)new StringValue(this.getContentType()))};
        return new JSONObjectValue(MapsKt.mapOf((Pair[])pairArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addTo(@NotNull FormBuilder formBuilder) {
        void $this$addTo_u24lambda_u240;
        HeadersBuilder headersBuilder;
        Intrinsics.checkNotNullParameter((Object)formBuilder, (String)"formBuilder");
        Headers.Companion this_$iv = Headers.Companion;
        boolean $i$f$build = false;
        HeadersBuilder headersBuilder2 = headersBuilder = new HeadersBuilder(0, 1, null);
        String string = this.content.toStringLiteral();
        String string2 = this.getName();
        FormBuilder formBuilder2 = formBuilder;
        boolean bl = false;
        HeaderValueWithParametersKt.append((StringValuesBuilder)((StringValuesBuilder)$this$addTo_u24lambda_u240), (String)HttpHeaders.INSTANCE.getContentType(), (HeaderValueWithParameters)((HeaderValueWithParameters)ContentType.Companion.parse(this.getContentType())));
        Unit unit = Unit.INSTANCE;
        formBuilder2.append(string2, string, headersBuilder.build());
    }

    @Override
    @NotNull
    public Triple<List<GherkinClause>, Map<String, Pattern>, ExampleDeclarations> toClauseData(@NotNull List<GherkinClause> clauses, @NotNull Map<String, ? extends Pattern> newTypes, @NotNull ExampleDeclarations examples) {
        Intrinsics.checkNotNullParameter(clauses, (String)"clauses");
        Intrinsics.checkNotNullParameter(newTypes, (String)"newTypes");
        Intrinsics.checkNotNullParameter((Object)examples, (String)"examples");
        Pair<TypeDeclaration, ExampleDeclarations> pair = this.content.typeDeclarationWithKey(this.getName(), newTypes, examples);
        TypeDeclaration typeDeclaration = (TypeDeclaration)pair.component1();
        ExampleDeclarations newExamples = (ExampleDeclarations)pair.component2();
        GherkinClause newGherkinClause = new GherkinClause("request-part " + this.getName() + " " + typeDeclaration.getTypeValue(), GherkinSection.When);
        return new Triple((Object)CollectionsKt.plus((Collection)clauses, (Object)newGherkinClause), typeDeclaration.getTypes(), (Object)examples.plus(newExamples));
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Value component2() {
        return this.content;
    }

    @NotNull
    public final String component3() {
        return this.boundary;
    }

    @Nullable
    public final String component4() {
        return this.specifiedContentType;
    }

    @NotNull
    public final MultiPartContentValue copy(@NotNull String name, @NotNull Value content, @NotNull String boundary, @Nullable String specifiedContentType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)boundary, (String)"boundary");
        return new MultiPartContentValue(name, content, boundary, specifiedContentType);
    }

    public static /* synthetic */ MultiPartContentValue copy$default(MultiPartContentValue multiPartContentValue, String string, Value value2, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = multiPartContentValue.name;
        }
        if ((n & 2) != 0) {
            value2 = multiPartContentValue.content;
        }
        if ((n & 4) != 0) {
            string2 = multiPartContentValue.boundary;
        }
        if ((n & 8) != 0) {
            string3 = multiPartContentValue.specifiedContentType;
        }
        return multiPartContentValue.copy(string, value2, string2, string3);
    }

    @NotNull
    public String toString() {
        return "MultiPartContentValue(name=" + this.name + ", content=" + this.content + ", boundary=" + this.boundary + ", specifiedContentType=" + this.specifiedContentType + ")";
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = result2 * 31 + this.content.hashCode();
        result2 = result2 * 31 + this.boundary.hashCode();
        result2 = result2 * 31 + (this.specifiedContentType == null ? 0 : this.specifiedContentType.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultiPartContentValue)) {
            return false;
        }
        MultiPartContentValue multiPartContentValue = (MultiPartContentValue)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)multiPartContentValue.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.content, (Object)multiPartContentValue.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.boundary, (Object)multiPartContentValue.boundary)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.specifiedContentType, (Object)multiPartContentValue.specifiedContentType);
    }
}

