/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.specmatic.core.HttpPathPattern;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpResponse;
import io.specmatic.core.Result;
import io.specmatic.core.Scenario;
import io.specmatic.core.URLPathSegmentPattern;
import io.specmatic.core.WorkflowConfiguration;
import io.specmatic.core.WorkflowIDOperation;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.Value;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lio/specmatic/core/Workflow;", "", "workflow", "Lio/specmatic/core/WorkflowConfiguration;", "(Lio/specmatic/core/WorkflowConfiguration;)V", "id", "Lio/specmatic/core/value/Value;", "getId", "()Lio/specmatic/core/value/Value;", "setId", "(Lio/specmatic/core/value/Value;)V", "getWorkflow", "()Lio/specmatic/core/WorkflowConfiguration;", "extractDataFrom", "", "response", "Lio/specmatic/core/HttpResponse;", "originalScenario", "Lio/specmatic/core/Scenario;", "updateRequest", "Lio/specmatic/core/HttpRequest;", "request", "core"})
@SourceDebugExtension(value={"SMAP\nWorkflow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Workflow.kt\nio/specmatic/core/Workflow\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n350#2,7:102\n*S KotlinDebug\n*F\n+ 1 Workflow.kt\nio/specmatic/core/Workflow\n*L\n75#1:102,7\n*E\n"})
public final class Workflow {
    @NotNull
    private final WorkflowConfiguration workflow;
    @Nullable
    private Value id;

    public Workflow(@NotNull WorkflowConfiguration workflow) {
        Intrinsics.checkNotNullParameter((Object)workflow, (String)"workflow");
        this.workflow = workflow;
    }

    public /* synthetic */ Workflow(WorkflowConfiguration workflowConfiguration, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            workflowConfiguration = new WorkflowConfiguration(null, 1, null);
        }
        this(workflowConfiguration);
    }

    @NotNull
    public final WorkflowConfiguration getWorkflow() {
        return this.workflow;
    }

    @Nullable
    public final Value getId() {
        return this.id;
    }

    public final void setId(@Nullable Value value2) {
        this.id = value2;
    }

    public final void extractDataFrom(@NotNull HttpResponse response, @NotNull Scenario originalScenario) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)originalScenario, (String)"originalScenario");
        WorkflowIDOperation workflowIDOperation = this.workflow.getIds().get(originalScenario.getApiDescription());
        if (workflowIDOperation == null) {
            return;
        }
        WorkflowIDOperation operation = workflowIDOperation;
        String extractLocation = operation.getExtract();
        if (extractLocation != null) {
            String[] stringArray = new String[]{"."};
            List locationPath = StringsKt.split$default((CharSequence)extractLocation, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (locationPath.isEmpty()) {
                return;
            }
            String area = (String)locationPath.get(0);
            List path2 = CollectionsKt.drop((Iterable)locationPath, (int)1);
            String string = area.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            if (Intrinsics.areEqual((Object)string, (Object)"BODY")) {
                Value data2;
                Value responseBody2 = response.getBody();
                if (path2.isEmpty()) {
                    this.id = responseBody2;
                } else if (responseBody2 instanceof JSONObjectValue && (data2 = ((JSONObjectValue)responseBody2).findFirstChildByPath(CollectionsKt.joinToString$default((Iterable)path2, (CharSequence)".", null, null, (int)0, null, null, (int)62, null))) != null) {
                    this.id = data2;
                }
            } else {
                throw new ContractException("Cannot extract data from " + area + " yet", null, null, null, false, 30, null);
            }
        }
    }

    @NotNull
    public final HttpRequest updateRequest(@NotNull HttpRequest request, @NotNull Scenario originalScenario) {
        HttpRequest httpRequest;
        WorkflowIDOperation operation;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)originalScenario, (String)"originalScenario");
        if (originalScenario.isNegative()) {
            return request;
        }
        WorkflowIDOperation workflowIDOperation = this.workflow.getIds().get(originalScenario.getApiDescription());
        if (workflowIDOperation == null) {
            workflowIDOperation = this.workflow.getIds().get("*");
        }
        if ((operation = workflowIDOperation) == null) {
            return request;
        }
        String string = operation.getUse();
        if (string == null) {
            return request;
        }
        String useLocation = string;
        String[] stringArray = new String[]{"."};
        List locationPath = StringsKt.split$default((CharSequence)useLocation, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (locationPath.isEmpty()) {
            return request;
        }
        String area = (String)locationPath.get(0);
        List path2 = CollectionsKt.drop((Iterable)locationPath, (int)1);
        String string2 = area.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        if (Intrinsics.areEqual((Object)string2, (Object)"PATH")) {
            int pathParamIndex;
            block17: {
                if (path2.isEmpty()) {
                    throw new ContractException("Cannot use id " + useLocation, null, null, null, false, 30, null);
                }
                if (path2.size() > 1) {
                    throw new ContractException("PATH.<name> must refer to the name of a path parameter", null, null, null, false, 30, null);
                }
                String pathParamName = (String)path2.get(0);
                Object object = originalScenario.getHttpRequestPattern().getHttpPathPattern();
                if (object != null && (object = ((HttpPathPattern)object).getPathSegmentPatterns()) != null) {
                    Object $this$indexOfFirst$iv = object;
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    Iterator iterator = $this$indexOfFirst$iv.iterator();
                    while (iterator.hasNext()) {
                        Object item$iv = iterator.next();
                        URLPathSegmentPattern it = (URLPathSegmentPattern)item$iv;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)it.getKey(), (Object)pathParamName)) {
                            v4 = index$iv;
                            break block17;
                        }
                        ++index$iv;
                    }
                    v4 = -1;
                } else {
                    v4 = pathParamIndex = -1;
                }
            }
            if (pathParamIndex < 0) {
                httpRequest = request;
            } else {
                Result result2;
                String string3 = request.getPath();
                Intrinsics.checkNotNull((Object)string3);
                String[] stringArray2 = new String[]{"/"};
                List updatedPath = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)string3, (String[])stringArray2, (boolean)false, (int)0, (int)6, null));
                int indexToUpdate = Intrinsics.areEqual((Object)CollectionsKt.getOrNull((List)updatedPath, (int)0), (Object)"") ? pathParamIndex + 1 : pathParamIndex;
                Value value2 = this.id;
                if (value2 != null) {
                    Value it = value2;
                    boolean bl = false;
                    updatedPath.set(indexToUpdate, it.toStringLiteral());
                }
                HttpPathPattern httpPathPattern = originalScenario.getHttpRequestPattern().getHttpPathPattern();
                Result result3 = result2 = httpPathPattern != null ? httpPathPattern.matches(CollectionsKt.joinToString$default((Iterable)updatedPath, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), originalScenario.getResolver()) : null;
                if (result3 != null) {
                    result3.throwOnFailure();
                }
                httpRequest = HttpRequest.copy$default(request, null, CollectionsKt.joinToString$default((Iterable)updatedPath, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), null, null, null, null, null, null, 253, null);
            }
        } else {
            throw new ContractException("Cannot extract data from " + area + " yet", null, null, null, false, 30, null);
        }
        return httpRequest;
    }

    public Workflow() {
        this(null, 1, null);
    }
}

