/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.azure;

import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpResponse;
import io.specmatic.core.azure.AzureAPI;
import io.specmatic.core.azure.AzureAPIKt;
import io.specmatic.core.azure.AzureAuthToken;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.ContractExceptionKt;
import io.specmatic.core.pattern.GrammarKt;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.Value;
import io.specmatic.test.HttpClient;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\n\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/specmatic/core/azure/AzureAPI;", "", "azureAuthToken", "Lio/specmatic/core/azure/AzureAuthToken;", "azureBaseURL", "", "collection", "(Lio/specmatic/core/azure/AzureAuthToken;Ljava/lang/String;Ljava/lang/String;)V", "codeAdvancedSearch", "Lio/specmatic/core/value/JSONObjectValue;", "searchString", "referencesToContract", "", "Lio/specmatic/core/azure/AzureAPI$ContractConsumerEntry;", "ContractConsumerEntry", "core"})
public final class AzureAPI {
    @NotNull
    private final AzureAuthToken azureAuthToken;
    @NotNull
    private final String azureBaseURL;
    @NotNull
    private final String collection;

    public AzureAPI(@NotNull AzureAuthToken azureAuthToken, @NotNull String azureBaseURL, @NotNull String collection) {
        Intrinsics.checkNotNullParameter((Object)azureAuthToken, (String)"azureAuthToken");
        Intrinsics.checkNotNullParameter((Object)azureBaseURL, (String)"azureBaseURL");
        Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
        this.azureAuthToken = azureAuthToken;
        this.azureBaseURL = azureBaseURL;
        this.collection = collection;
    }

    @NotNull
    public final List<ContractConsumerEntry> referencesToContract(@NotNull String searchString) {
        Intrinsics.checkNotNullParameter((Object)searchString, (String)"searchString");
        JSONObjectValue azureResponse = this.codeAdvancedSearch(searchString);
        Value value2 = azureResponse.findFirstChildByPath("results.values");
        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type io.specmatic.core.value.JSONArrayValue");
        JSONArrayValue referencesToSpecification = (JSONArrayValue)value2;
        return (List)ContractExceptionKt.attempt$default("Error processing Azure's response to a search for a specification (" + searchString + ")", null, (Function0)new Function0<List<? extends ContractConsumerEntry>>(referencesToSpecification, this){
            final /* synthetic */ JSONArrayValue $referencesToSpecification;
            final /* synthetic */ AzureAPI this$0;
            {
                this.$referencesToSpecification = $referencesToSpecification;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<ContractConsumerEntry> invoke() {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = this.$referencesToSpecification.getList();
                AzureAPI azureAPI = this.this$0;
                boolean $i$f$map = false;
                void var4_4 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void referenceToSpecification;
                    Value value2 = (Value)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new ContractConsumerEntry(AzureAPI.access$getCollection$p(azureAPI), (Value)referenceToSpecification));
                }
                return (List)destination$iv$iv;
            }
        }, 2, null);
    }

    private final JSONObjectValue codeAdvancedSearch(String searchString) {
        HttpClient client2 = new HttpClient(this.azureBaseURL, 0L, codeAdvancedSearch.client.1.INSTANCE, null, 10, null);
        HttpRequest request = HttpRequest.copy$default(new HttpRequest("POST", new URI("/" + this.collection + "/_apis/search/codeAdvancedQueryResults?api-version=5.1-preview.1")), null, null, MapsKt.mapOf((Pair)TuplesKt.to((Object)"Authorization", (Object)("Basic " + this.azureAuthToken.basic()))), GrammarKt.parsedJSON$default(StringsKt.trimIndent((String)("\n                {\"searchText\":\"" + searchString + "\",\"skipResults\":0,\"takeResults\":50,\"sortOptions\":[],\"summarizedHitCountsNeeded\":true,\"searchFilters\":{}}\n            ")), null, 2, null), null, null, null, null, 243, null);
        HttpResponse response = client2.execute(request);
        Value value2 = GrammarKt.parsedJSON$default(response.getBody().toStringLiteral(), null, 2, null);
        Intrinsics.checkNotNull((Object)value2, (String)"null cannot be cast to non-null type io.specmatic.core.value.JSONObjectValue");
        return (JSONObjectValue)value2;
    }

    public static final /* synthetic */ String access$getCollection$p(AzureAPI $this) {
        return $this.collection;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006\u001c"}, d2={"Lio/specmatic/core/azure/AzureAPI$ContractConsumerEntry;", "", "collection", "", "referenceToSpecificationInAzureSearchResult", "Lio/specmatic/core/value/JSONObjectValue;", "(Ljava/lang/String;Lio/specmatic/core/value/JSONObjectValue;)V", "Lio/specmatic/core/value/Value;", "(Ljava/lang/String;Lio/specmatic/core/value/Value;)V", "project", "branch", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "getCollection", "description", "getDescription", "getProject", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "core"})
    public static final class ContractConsumerEntry {
        @NotNull
        private final String collection;
        @NotNull
        private final String project;
        @NotNull
        private final String branch;

        public ContractConsumerEntry(@NotNull String collection, @NotNull String project, @NotNull String branch) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            this.collection = collection;
            this.project = project;
            this.branch = branch;
        }

        @NotNull
        public final String getCollection() {
            return this.collection;
        }

        @NotNull
        public final String getProject() {
            return this.project;
        }

        @NotNull
        public final String getBranch() {
            return this.branch;
        }

        public ContractConsumerEntry(@NotNull String collection, @NotNull JSONObjectValue referenceToSpecificationInAzureSearchResult) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)referenceToSpecificationInAzureSearchResult, (String)"referenceToSpecificationInAzureSearchResult");
            Value value2 = referenceToSpecificationInAzureSearchResult.getJsonObject().get("project");
            if (value2 == null) {
                throw new ContractException("Expected \"project\" in consumer search result", null, null, null, false, 30, null);
            }
            Value value3 = referenceToSpecificationInAzureSearchResult.getJsonObject().get("branch");
            if (value3 == null) {
                throw new ContractException("Expected \"branch\" in consumer search result", null, null, null, false, 30, null);
            }
            this(AzureAPIKt.access$unDefault(referenceToSpecificationInAzureSearchResult, collection), value2.toStringLiteral(), value3.toStringLiteral());
        }

        public ContractConsumerEntry(@NotNull String collection, @NotNull Value referenceToSpecificationInAzureSearchResult) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)referenceToSpecificationInAzureSearchResult, (String)"referenceToSpecificationInAzureSearchResult");
            this(collection, (JSONObjectValue)referenceToSpecificationInAzureSearchResult);
        }

        @NotNull
        public final String getDescription() {
            return this.collection + "/" + this.project + " (" + this.branch + ")";
        }

        @NotNull
        public final String component1() {
            return this.collection;
        }

        @NotNull
        public final String component2() {
            return this.project;
        }

        @NotNull
        public final String component3() {
            return this.branch;
        }

        @NotNull
        public final ContractConsumerEntry copy(@NotNull String collection, @NotNull String project, @NotNull String branch) {
            Intrinsics.checkNotNullParameter((Object)collection, (String)"collection");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
            return new ContractConsumerEntry(collection, project, branch);
        }

        public static /* synthetic */ ContractConsumerEntry copy$default(ContractConsumerEntry contractConsumerEntry, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = contractConsumerEntry.collection;
            }
            if ((n & 2) != 0) {
                string2 = contractConsumerEntry.project;
            }
            if ((n & 4) != 0) {
                string3 = contractConsumerEntry.branch;
            }
            return contractConsumerEntry.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "ContractConsumerEntry(collection=" + this.collection + ", project=" + this.project + ", branch=" + this.branch + ")";
        }

        public int hashCode() {
            int result2 = this.collection.hashCode();
            result2 = result2 * 31 + this.project.hashCode();
            result2 = result2 * 31 + this.branch.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContractConsumerEntry)) {
                return false;
            }
            ContractConsumerEntry contractConsumerEntry = (ContractConsumerEntry)other;
            if (!Intrinsics.areEqual((Object)this.collection, (Object)contractConsumerEntry.collection)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.project, (Object)contractConsumerEntry.project)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.branch, (Object)contractConsumerEntry.branch);
        }
    }
}

