/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.examples.server;

import io.specmatic.core.examples.server.ExamplesInteractiveServerKt;
import io.specmatic.core.log.LoggingKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0001\u00a8\u0006\u0007"}, d2={"defaultExternalExampleDirFrom", "Ljava/io/File;", "contractFile", "loadExternalExamples", "Lkotlin/Pair;", "", "examplesDir", "core"})
public final class ExamplesInteractiveServerKt {
    @NotNull
    public static final Pair<File, List<File>> loadExternalExamples(@NotNull File examplesDir) {
        Intrinsics.checkNotNullParameter((Object)examplesDir, (String)"examplesDir");
        if (!examplesDir.isDirectory()) {
            LoggingKt.getLogger().log(examplesDir + " does not exist, did not find any files to validate");
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
        return TuplesKt.to((Object)examplesDir, (Object)SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)((Sequence)FilesKt.walk$default((File)examplesDir, null, (int)1, null)), (Function1)loadExternalExamples.1.INSTANCE)));
    }

    @NotNull
    public static final File defaultExternalExampleDirFrom(@NotNull File contractFile) {
        Intrinsics.checkNotNullParameter((Object)contractFile, (String)"contractFile");
        File file = contractFile.getAbsoluteFile().getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return FilesKt.resolve((File)file, (String)(FilesKt.getNameWithoutExtension((File)contractFile) + "_examples"));
    }
}

