/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.log;

import io.specmatic.core.log.CompositePrinter;
import io.specmatic.core.log.LogMessage;
import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.NewLineLogMessage;
import io.specmatic.core.log.ReadyMessage;
import io.specmatic.core.log.StringLog;
import io.specmatic.core.log.VerboseExceptionLog;
import io.specmatic.core.utilities.Utilities;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000f\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0013H\u0016J\u001a\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0013H\u0016J\u001a\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\u001a\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0011\u001a\u0004\u0018\u00010\u0013H\u0016J\u000e\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/specmatic/core/log/Verbose;", "Lio/specmatic/core/log/LogStrategy;", "printer", "Lio/specmatic/core/log/CompositePrinter;", "infoLoggingEnabled", "", "(Lio/specmatic/core/log/CompositePrinter;Z)V", "getInfoLoggingEnabled", "()Z", "setInfoLoggingEnabled", "(Z)V", "getPrinter", "()Lio/specmatic/core/log/CompositePrinter;", "readyMessage", "Lio/specmatic/core/log/ReadyMessage;", "debug", "", "msg", "Lio/specmatic/core/log/LogMessage;", "", "e", "", "exceptionString", "keepReady", "log", "logError", "newLine", "ofTheException", "print", "core"})
public final class Verbose
implements LogStrategy {
    @NotNull
    private final CompositePrinter printer;
    private boolean infoLoggingEnabled;
    @NotNull
    private final ReadyMessage readyMessage;

    public Verbose(@NotNull CompositePrinter printer, boolean infoLoggingEnabled) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        this.printer = printer;
        this.infoLoggingEnabled = infoLoggingEnabled;
        this.readyMessage = new ReadyMessage(null, 1, null);
    }

    public /* synthetic */ Verbose(CompositePrinter compositePrinter, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            compositePrinter = new CompositePrinter(null, 1, null);
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(compositePrinter, bl);
    }

    @Override
    @NotNull
    public CompositePrinter getPrinter() {
        return this.printer;
    }

    @Override
    public boolean getInfoLoggingEnabled() {
        return this.infoLoggingEnabled;
    }

    @Override
    public void setInfoLoggingEnabled(boolean bl) {
        this.infoLoggingEnabled = bl;
    }

    @Override
    public void keepReady(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.readyMessage.setMsg(msg);
    }

    public final void print(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.readyMessage.printLogString(this.getPrinter());
        this.getPrinter().print(msg);
    }

    @Override
    @NotNull
    public String exceptionString(@NotNull Throwable e, @Nullable String msg) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (msg == null) {
            object = Utilities.exceptionCauseMessage(e);
        } else {
            String string = e.getLocalizedMessage();
            if (string == null && (string = e.getMessage()) == null) {
                string = e.getClass().getName();
            }
            object = msg + ": " + string;
        }
        String message = object;
        return message + System.lineSeparator() + ExceptionsKt.stackTraceToString((Throwable)e);
    }

    @Override
    @NotNull
    public LogMessage ofTheException(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return new VerboseExceptionLog(e, msg);
    }

    @Override
    public void log(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.print(new VerboseExceptionLog(e, msg));
    }

    @Override
    public void log(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.getInfoLoggingEnabled()) {
            this.log(new StringLog(msg));
        }
    }

    @Override
    public void log(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (this.getInfoLoggingEnabled()) {
            this.print(msg);
        }
    }

    @Override
    public void logError(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.log(e, "ERROR");
    }

    @Override
    public void newLine() {
        this.print(NewLineLogMessage.INSTANCE);
    }

    @Override
    @NotNull
    public String debug(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.debug(new StringLog(msg));
        return msg;
    }

    @Override
    public void debug(@NotNull LogMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.print(msg);
    }

    @Override
    public void debug(@NotNull Throwable e, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.log(e, msg);
    }

    @Override
    public void disableInfoLogging() {
        LogStrategy.DefaultImpls.disableInfoLogging(this);
    }

    @Override
    public void enableInfoLogging() {
        LogStrategy.DefaultImpls.enableInfoLogging(this);
    }

    public Verbose() {
        this(null, false, 3, null);
    }
}

