/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.RFC3339Kt;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/specmatic/core/pattern/RFC3339;", "", "()V", "Companion", "core"})
public final class RFC3339 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DateTimeFormatter dateFormatter;

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        dateFormatter = dateTimeFormatter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lio/specmatic/core/pattern/RFC3339$Companion;", "", "()V", "dateFormatter", "Ljava/time/format/DateTimeFormatter;", "getDateFormatter", "()Ljava/time/format/DateTimeFormatter;", "currentDate", "", "currentDateTime", "parse", "", "dateTime", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getDateFormatter() {
            return dateFormatter;
        }

        public final void parse(@NotNull String dateTime) {
            Intrinsics.checkNotNullParameter((Object)dateTime, (String)"dateTime");
            Matcher matcher = RFC3339Kt.access$getRFC3339_PATTERN$p().matcher(dateTime);
            if (!matcher.matches()) {
                throw new ContractException("Error while parsing the dateTime as per RFC 3339: " + dateTime, null, null, null, false, 30, null);
            }
        }

        @NotNull
        public final String currentDateTime() {
            ZonedDateTime dateTimeWithSystemOffset = ZonedDateTime.of(LocalDateTime.now(), ZoneId.systemDefault());
            String string = dateTimeWithSystemOffset.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssXXX"));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        @NotNull
        public final String currentDate() {
            String string = LocalDateTime.now().format(this.getDateFormatter());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

