/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.git.SystemGit;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.utilities.ContractPathData;
import io.specmatic.core.utilities.ContractSource;
import io.specmatic.core.utilities.ContractsSelectorPredicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J&\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\r\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u001f"}, d2={"Lio/specmatic/core/utilities/LocalFileSystemSource;", "Lio/specmatic/core/utilities/ContractSource;", "directory", "", "testContracts", "", "stubContracts", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getDirectory", "()Ljava/lang/String;", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "type", "getType", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "getLatest", "", "sourceGit", "Lio/specmatic/core/git/SystemGit;", "install", "loadContracts", "Lio/specmatic/core/utilities/ContractPathData;", "selector", "Lio/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "pathDescriptor", "path", "pushUpdates", "core"})
@SourceDebugExtension(value={"SMAP\nLocalFileSystemSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFileSystemSource.kt\nio/specmatic/core/utilities/LocalFileSystemSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1549#2:52\n1620#2,3:53\n*S KotlinDebug\n*F\n+ 1 LocalFileSystemSource.kt\nio/specmatic/core/utilities/LocalFileSystemSource\n*L\n40#1:52\n40#1:53,3\n*E\n"})
public final class LocalFileSystemSource
implements ContractSource {
    @NotNull
    private final String directory;
    @NotNull
    private final List<String> testContracts;
    @NotNull
    private final List<String> stubContracts;
    @NotNull
    private final String type;

    public LocalFileSystemSource(@NotNull String directory, @NotNull List<String> testContracts, @NotNull List<String> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        this.directory = directory;
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.type = "filesystem";
    }

    public /* synthetic */ LocalFileSystemSource(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        this(string, list, list2);
    }

    @NotNull
    public final String getDirectory() {
        return this.directory;
    }

    @Override
    @NotNull
    public List<String> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<String> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return path2;
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        LoggingKt.getLogger().log("No installation needed as this source is a directory on the local file system");
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        if (new File(this.directory).isAbsolute()) {
            return new File(this.directory);
        }
        return FilesKt.resolve((File)workingDirectory, (String)this.directory);
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        LoggingKt.getLogger().log("No need to get latest as this source is a directory on the local file system");
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        LoggingKt.getLogger().log("No need to push updates as this source is a directory on the local file system");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File resolvedPath = FilesKt.resolve((File)new File(this.directory), (String)it);
            String string2 = resolvedPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            collection.add(new ContractPathData(this.directory, string2, this.getType(), null, null, resolvedPath.getCanonicalPath(), 24, null));
        }
        return (List)destination$iv$iv;
    }
}

