/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.conversions;

import io.specmatic.conversions.OpenAPISecurityScheme;
import io.specmatic.conversions.OpenAPISecuritySchemeKt;
import io.specmatic.core.BreadCrumb;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpRequestPattern;
import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.HasFailure;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.pattern.ReturnValueKt;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.pattern.StringPattern;
import io.specmatic.core.pattern.StringPatternKt;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.util.Base64;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u0005\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u0015\u0010\u000f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\u0010\u0010\u0017\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00192\u0006\u0010\b\u001a\u00020\tH\u0002J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0018\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u0014H\u0016J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\"\u001a\u00020\u0003H\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lio/specmatic/conversions/BasicAuthSecurityScheme;", "Lio/specmatic/conversions/OpenAPISecurityScheme;", "token", "", "(Ljava/lang/String;)V", "addTo", "Lio/specmatic/core/HttpRequest;", "httpRequest", "resolver", "Lio/specmatic/core/Resolver;", "Lio/specmatic/core/HttpRequestPattern;", "requestPattern", "row", "Lio/specmatic/core/pattern/Row;", "component1", "copy", "copyFromTo", "originalRequest", "newHttpRequest", "equals", "", "other", "", "getAuthorizationHeaderValue", "getTokenFromDictionary", "Lio/specmatic/core/pattern/ReturnValue;", "hashCode", "", "isInRequest", "request", "complete", "isInRow", "matches", "Lio/specmatic/core/Result;", "randomBasicAuthCredentials", "removeParam", "toString", "validateBase64EncodedCredentials", "base64Credentials", "validatedToken", "specmatic-core"})
public final class BasicAuthSecurityScheme
implements OpenAPISecurityScheme {
    @Nullable
    private final String token;

    public BasicAuthSecurityScheme(@Nullable String token) {
        this.token = token;
    }

    public /* synthetic */ BasicAuthSecurityScheme(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string);
    }

    @Override
    @NotNull
    public Result matches(@NotNull HttpRequest httpRequest, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = httpRequest.getHeaders().get("Authorization");
        if (string == null) {
            Result result2;
            if (resolver.getMockMode()) {
                result2 = new Result.Success(null, null, 3, null);
            } else {
                String string2 = BreadCrumb.with-impl(BreadCrumb.Companion.getHEADER-uLvOB-M(), "Authorization");
                String string3 = resolver.getMismatchMessages().expectedKeyWasMissing("Header", "Authorization");
                result2 = new Result.Failure(string3, null, string2, null, null, 26, null);
            }
            return result2;
        }
        String authHeaderValue = string;
        String string4 = authHeaderValue.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        if (!StringsKt.startsWith$default((String)string4, (String)"basic", (boolean)false, (int)2, null)) {
            String string5 = BreadCrumb.with-impl(BreadCrumb.Companion.getHEADER-uLvOB-M(), "Authorization");
            return new Result.Failure("Authorization header must be prefixed with \"Basic\"", null, string5, null, null, 26, null);
        }
        String base64Credentials = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)authHeaderValue, (String)" ", null, (int)2, null))).toString();
        return this.validateBase64EncodedCredentials(base64Credentials);
    }

    private final Result validateBase64EncodedCredentials(String base64Credentials) {
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(base64Credentials);
            Intrinsics.checkNotNull((Object)decodedBytes);
            String credentials = new String(decodedBytes, Charsets.UTF_8);
            if (!StringsKt.contains$default((CharSequence)credentials, (CharSequence)":", (boolean)false, (int)2, null)) {
                String string = BreadCrumb.with-impl(BreadCrumb.Companion.getHEADER-uLvOB-M(), "Authorization");
                return new Result.Failure("Base64-encoded credentials in Authorization header is not in the form username:password", null, string, null, null, 26, null);
            }
        }
        catch (IllegalArgumentException e) {
            String string = BreadCrumb.with-impl(BreadCrumb.Companion.getHEADER-uLvOB-M(), "Authorization");
            return new Result.Failure("Invalid base64 encoding in Authorization header", null, string, null, null, 26, null);
        }
        return new Result.Success(null, null, 3, null);
    }

    @Override
    @NotNull
    public HttpRequest removeParam(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        return HttpRequest.copy$default(httpRequest, null, null, MapsKt.minus(httpRequest.getHeaders(), (Object)"Authorization"), null, null, null, null, null, 251, null);
    }

    @Override
    @NotNull
    public HttpRequest addTo(@NotNull HttpRequest httpRequest, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return httpRequest.addSecurityHeader("Authorization", this.getAuthorizationHeaderValue(resolver));
    }

    @Override
    @NotNull
    public HttpRequestPattern addTo(@NotNull HttpRequestPattern requestPattern, @NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)requestPattern, (String)"requestPattern");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return OpenAPISecuritySchemeKt.addToHeaderType("Authorization", row, requestPattern);
    }

    @Override
    @NotNull
    public HttpRequest copyFromTo(@NotNull HttpRequest originalRequest, @NotNull HttpRequest newHttpRequest) {
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        Intrinsics.checkNotNullParameter((Object)newHttpRequest, (String)"newHttpRequest");
        if (!originalRequest.getHeaders().containsKey("Authorization")) {
            return newHttpRequest;
        }
        return newHttpRequest.addSecurityHeader("Authorization", (String)MapsKt.getValue(originalRequest.getHeaders(), (Object)"Authorization"));
    }

    @Override
    public boolean isInRow(@NotNull Row row) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        return row.containsField("Authorization");
    }

    @Override
    public boolean isInRequest(@NotNull HttpRequest request, boolean complete) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return request.hasHeader("Authorization");
    }

    private final String getAuthorizationHeaderValue(Resolver resolver) {
        String string;
        ReturnValue<String> tokenFromDictionary = this.getTokenFromDictionary(resolver);
        if (this.token != null) {
            string = this.validatedToken(this.token);
        } else {
            if (tokenFromDictionary != null) {
                return ReturnValueKt.unwrapOrContractException(tokenFromDictionary);
            }
            string = this.randomBasicAuthCredentials();
        }
        String validToken = string;
        return "Basic " + validToken;
    }

    private final ReturnValue<String> getTokenFromDictionary(Resolver resolver) {
        Resolver updatedResolver = resolver.updateLookupForParam(BreadCrumb.Companion.getHEADER-uLvOB-M());
        ReturnValue<Value> dictionaryValue = updatedResolver.getDictionary().getValueFor("Authorization", new StringPattern(null, null, null, null, null, 31, null), updatedResolver);
        ReturnValue<Value> returnValue2 = dictionaryValue;
        if (returnValue2 == null || (returnValue2 = ReturnValueKt.unwrapOrContractException(returnValue2)) == null) {
            return null;
        }
        ReturnValue<Value> authHeader = returnValue2;
        if (!(authHeader instanceof StringValue)) {
            String string = BreadCrumb.with-impl(BreadCrumb.Companion.getHEADER-uLvOB-M(), "Authorization");
            return new HasFailure(new Result.Failure("Header Authorization must be a string.", null, string, null, null, 26, null), null, 2, null);
        }
        String headerValue = ((StringValue)((Object)authHeader)).getNativeValue();
        String string = headerValue.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!StringsKt.startsWith$default((String)string, (String)"basic ", (boolean)false, (int)2, null)) {
            String string2 = BreadCrumb.with-impl(BreadCrumb.Companion.getHEADER-uLvOB-M(), "Authorization");
            return new HasFailure(new Result.Failure("Authorization header must be prefixed with \"Basic\"", null, string2, null, null, 26, null), null, 2, null);
        }
        String base64Credentials = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)headerValue, (String)" ", null, (int)2, null))).toString();
        return Result.toReturnValue$default(this.validateBase64EncodedCredentials(base64Credentials), headerValue, null, 2, null);
    }

    private final String validatedToken(String token) {
        Result result2 = this.validateBase64EncodedCredentials(token);
        if (result2 instanceof Result.Failure) {
            throw new ContractException(result2.reportString(), null, null, null, false, 30, null);
        }
        return token;
    }

    private final String randomBasicAuthCredentials() {
        String randomUsername = StringPatternKt.randomString$default(0, 1, null);
        String randomPassword = StringPatternKt.randomString$default(0, 1, null);
        Base64.Encoder encoder = Base64.getEncoder();
        String string = randomUsername + ":" + randomPassword;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    private final String component1() {
        return this.token;
    }

    @NotNull
    public final BasicAuthSecurityScheme copy(@Nullable String token) {
        return new BasicAuthSecurityScheme(token);
    }

    public static /* synthetic */ BasicAuthSecurityScheme copy$default(BasicAuthSecurityScheme basicAuthSecurityScheme, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = basicAuthSecurityScheme.token;
        }
        return basicAuthSecurityScheme.copy(string);
    }

    @NotNull
    public String toString() {
        return "BasicAuthSecurityScheme(token=" + this.token + ")";
    }

    public int hashCode() {
        return this.token == null ? 0 : this.token.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BasicAuthSecurityScheme)) {
            return false;
        }
        BasicAuthSecurityScheme basicAuthSecurityScheme = (BasicAuthSecurityScheme)other;
        return Intrinsics.areEqual((Object)this.token, (Object)basicAuthSecurityScheme.token);
    }

    public BasicAuthSecurityScheme() {
        this(null, 1, null);
    }
}

