/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.specmatic.core.HttpRequestKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/specmatic/core/URLParts;", "", "url", "", "(Ljava/lang/String;)V", "baseUrl", "parts", "", "getParts", "()Ljava/util/List;", "queryOnwards", "queryStartIndex", "", "noPathInURL", "", "withDecodedPathSegments", "withEncodedPathSegments", "specmatic-core"})
public final class URLParts {
    private final int queryStartIndex;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final List<String> parts;
    @NotNull
    private final String queryOnwards;

    public URLParts(@NotNull String url) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.queryStartIndex = StringsKt.indexOf$default((CharSequence)url, (char)'?', (int)0, (boolean)false, (int)6, null);
        if (this.queryStartIndex != -1) {
            String string3 = url.substring(0, this.queryStartIndex);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string2 = url;
        }
        this.baseUrl = string2;
        String[] stringArray = new String[]{"/"};
        this.parts = StringsKt.split$default((CharSequence)this.baseUrl, (String[])stringArray, (boolean)false, (int)4, (int)2, null);
        if (this.queryStartIndex != -1) {
            String string4 = url.substring(this.queryStartIndex);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            string = "";
        }
        this.queryOnwards = string;
    }

    @NotNull
    public final List<String> getParts() {
        return this.parts;
    }

    @NotNull
    public final String withEncodedPathSegments() {
        if (this.noPathInURL()) {
            return this.baseUrl;
        }
        List<String> list = this.parts;
        String scheme = list.get(0);
        String authority = list.get(2);
        String path2 = list.get(3);
        String escapedPath = HttpRequestKt.escapeSpaceInPath(path2);
        return scheme + "//" + authority + "/" + escapedPath + this.queryOnwards;
    }

    @NotNull
    public final String withDecodedPathSegments() {
        if (this.noPathInURL()) {
            return this.baseUrl;
        }
        List<String> list = this.parts;
        String scheme = list.get(0);
        String authority = list.get(2);
        String path2 = list.get(3);
        String escapedPath = HttpRequestKt.decodePath(path2);
        return scheme + "//" + authority + "/" + escapedPath + this.queryOnwards;
    }

    private final boolean noPathInURL() {
        return this.parts.size() < 4;
    }
}

