/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.log;

import io.specmatic.core.BadRequestOrDefault;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpRequestPattern;
import io.specmatic.core.HttpRequestPatternKt;
import io.specmatic.core.HttpResponse;
import io.specmatic.core.HttpResponsePattern;
import io.specmatic.core.Scenario;
import io.specmatic.core.TestResult;
import io.specmatic.core.log.CurrentDate;
import io.specmatic.core.log.LogMessage;
import io.specmatic.core.utilities.Utilities;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import io.specmatic.stub.HttpStubResponse;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B{\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\u0010\b\u0002\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012\u00a2\u0006\u0002\u0010\u0013J\u0012\u00102\u001a\u0002032\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012J\u000e\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u0005J\u000e\u00106\u001a\u0002032\u0006\u00107\u001a\u000208J\u000e\u00109\u001a\u0002032\u0006\u0010:\u001a\u00020\bJ\t\u0010;\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010<\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012H\u00c6\u0003J\t\u0010=\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010>\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010?\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010@\u001a\u00020\nH\u00c6\u0003J\u000b\u0010A\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\t\u0010B\u001a\u00020\nH\u00c6\u0003J\u000b\u0010C\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\u007f\u0010E\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012H\u00c6\u0001J\u0013\u0010F\u001a\u00020G2\b\u0010H\u001a\u0004\u0018\u00010IH\u00d6\u0003J\t\u0010J\u001a\u00020KH\u00d6\u0001J\u0006\u0010L\u001a\u00020GJ\u0006\u0010M\u001a\u000203J\b\u0010N\u001a\u00020\nH\u0002J\u0006\u0010O\u001a\u00020\nJ\b\u0010P\u001a\u00020QH\u0016J\b\u0010R\u001a\u00020\nH\u0016J\u0006\u0010S\u001a\u00020\nJ\u0006\u0010T\u001a\u00020UJ\t\u0010V\u001a\u00020\nH\u00d6\u0001R\u0013\u0010\r\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0015\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0018R\"\u0010\u0010\u001a\n\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010$\"\u0004\b,\u0010&R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0015\u00a8\u0006W"}, d2={"Lio/specmatic/core/log/HttpLogMessage;", "Lio/specmatic/core/log/LogMessage;", "requestTime", "Lio/specmatic/core/log/CurrentDate;", "request", "Lio/specmatic/core/HttpRequest;", "responseTime", "response", "Lio/specmatic/core/HttpResponse;", "contractPath", "", "examplePath", "targetServer", "comment", "scenario", "Lio/specmatic/core/Scenario;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lio/specmatic/core/log/CurrentDate;Lio/specmatic/core/HttpRequest;Lio/specmatic/core/log/CurrentDate;Lio/specmatic/core/HttpResponse;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lio/specmatic/core/Scenario;Ljava/lang/Exception;)V", "getComment", "()Ljava/lang/String;", "getContractPath", "setContractPath", "(Ljava/lang/String;)V", "getExamplePath", "setExamplePath", "getException", "()Ljava/lang/Exception;", "setException", "(Ljava/lang/Exception;)V", "getRequest", "()Lio/specmatic/core/HttpRequest;", "setRequest", "(Lio/specmatic/core/HttpRequest;)V", "getRequestTime", "()Lio/specmatic/core/log/CurrentDate;", "setRequestTime", "(Lio/specmatic/core/log/CurrentDate;)V", "getResponse", "()Lio/specmatic/core/HttpResponse;", "setResponse", "(Lio/specmatic/core/HttpResponse;)V", "getResponseTime", "setResponseTime", "getScenario", "()Lio/specmatic/core/Scenario;", "setScenario", "(Lio/specmatic/core/Scenario;)V", "getTargetServer", "addException", "", "addRequestWithCurrentTime", "httpRequest", "addResponse", "stubResponse", "Lio/specmatic/stub/HttpStubResponse;", "addResponseWithCurrentTime", "httpResponse", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "", "hashCode", "", "isTestLog", "logStartRequestTime", "target", "toDetails", "toJSONObject", "Lio/specmatic/core/value/JSONObjectValue;", "toLogString", "toName", "toResult", "Lio/specmatic/core/TestResult;", "toString", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nHttpLogMessage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpLogMessage.kt\nio/specmatic/core/log/HttpLogMessage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class HttpLogMessage
implements LogMessage {
    @NotNull
    private CurrentDate requestTime;
    @NotNull
    private HttpRequest request;
    @Nullable
    private CurrentDate responseTime;
    @Nullable
    private HttpResponse response;
    @NotNull
    private String contractPath;
    @Nullable
    private String examplePath;
    @NotNull
    private final String targetServer;
    @Nullable
    private final String comment;
    @Nullable
    private Scenario scenario;
    @Nullable
    private Exception exception;

    public HttpLogMessage(@NotNull CurrentDate requestTime, @NotNull HttpRequest request, @Nullable CurrentDate responseTime, @Nullable HttpResponse response, @NotNull String contractPath, @Nullable String examplePath, @NotNull String targetServer, @Nullable String comment, @Nullable Scenario scenario, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)targetServer, (String)"targetServer");
        this.requestTime = requestTime;
        this.request = request;
        this.responseTime = responseTime;
        this.response = response;
        this.contractPath = contractPath;
        this.examplePath = examplePath;
        this.targetServer = targetServer;
        this.comment = comment;
        this.scenario = scenario;
        this.exception = exception;
    }

    public /* synthetic */ HttpLogMessage(CurrentDate currentDate, HttpRequest httpRequest, CurrentDate currentDate2, HttpResponse httpResponse, String string, String string2, String string3, String string4, Scenario scenario, Exception exception, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            currentDate = new CurrentDate(null, 1, null);
        }
        if ((n & 2) != 0) {
            httpRequest = new HttpRequest(null, null, null, null, null, null, null, null, 255, null);
        }
        if ((n & 4) != 0) {
            currentDate2 = null;
        }
        if ((n & 8) != 0) {
            httpResponse = null;
        }
        if ((n & 0x10) != 0) {
            string = "";
        }
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        if ((n & 0x40) != 0) {
            string3 = "";
        }
        if ((n & 0x80) != 0) {
            string4 = null;
        }
        if ((n & 0x100) != 0) {
            scenario = null;
        }
        if ((n & 0x200) != 0) {
            exception = null;
        }
        this(currentDate, httpRequest, currentDate2, httpResponse, string, string2, string3, string4, scenario, exception);
    }

    @NotNull
    public final CurrentDate getRequestTime() {
        return this.requestTime;
    }

    public final void setRequestTime(@NotNull CurrentDate currentDate) {
        Intrinsics.checkNotNullParameter((Object)currentDate, (String)"<set-?>");
        this.requestTime = currentDate;
    }

    @NotNull
    public final HttpRequest getRequest() {
        return this.request;
    }

    public final void setRequest(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"<set-?>");
        this.request = httpRequest;
    }

    @Nullable
    public final CurrentDate getResponseTime() {
        return this.responseTime;
    }

    public final void setResponseTime(@Nullable CurrentDate currentDate) {
        this.responseTime = currentDate;
    }

    @Nullable
    public final HttpResponse getResponse() {
        return this.response;
    }

    public final void setResponse(@Nullable HttpResponse httpResponse) {
        this.response = httpResponse;
    }

    @NotNull
    public final String getContractPath() {
        return this.contractPath;
    }

    public final void setContractPath(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contractPath = string;
    }

    @Nullable
    public final String getExamplePath() {
        return this.examplePath;
    }

    public final void setExamplePath(@Nullable String string) {
        this.examplePath = string;
    }

    @NotNull
    public final String getTargetServer() {
        return this.targetServer;
    }

    @Nullable
    public final String getComment() {
        return this.comment;
    }

    @Nullable
    public final Scenario getScenario() {
        return this.scenario;
    }

    public final void setScenario(@Nullable Scenario scenario) {
        this.scenario = scenario;
    }

    @Nullable
    public final Exception getException() {
        return this.exception;
    }

    public final void setException(@Nullable Exception exception) {
        this.exception = exception;
    }

    public final void addRequestWithCurrentTime(@NotNull HttpRequest httpRequest) {
        Intrinsics.checkNotNullParameter((Object)httpRequest, (String)"httpRequest");
        this.requestTime = new CurrentDate(null, 1, null);
        this.request = httpRequest;
    }

    public final void addResponseWithCurrentTime(@NotNull HttpResponse httpResponse) {
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        this.responseTime = new CurrentDate(null, 1, null);
        this.response = httpResponse;
    }

    public final void addException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.exception = exception;
    }

    private final String target() {
        return !StringsKt.isBlank((CharSequence)this.targetServer) ? "to " + this.targetServer + " " : "";
    }

    @Override
    @NotNull
    public String toLogString() {
        List list;
        Object[] objectArray;
        List commentLines;
        String linePrefix = "  ";
        Object[] objectArray2 = new String[]{"", "--------------------"};
        List messagePrefix = CollectionsKt.listOf((Object[])objectArray2);
        if (this.comment != null) {
            Object[] objectArray3 = new String[]{linePrefix, StringsKt.prependIndent((String)this.comment, (String)linePrefix), linePrefix, linePrefix + "-----", linePrefix};
            v0 = CollectionsKt.listOf((Object[])objectArray3);
        } else {
            v0 = commentLines = CollectionsKt.emptyList();
        }
        if (!StringsKt.isBlank((CharSequence)this.contractPath)) {
            String string;
            String string2 = this.examplePath;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                string = linePrefix + "Example matched: " + this.examplePath;
            } else {
                string = null;
            }
            String exampleLine = string;
            objectArray = new String[]{linePrefix + "Contract matched: " + this.contractPath, exampleLine, ""};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            list = CollectionsKt.emptyList();
        }
        List contractPathLines = list;
        objectArray = new String[5];
        objectArray[0] = linePrefix + "Request " + this.target() + "at " + this.requestTime;
        objectArray[1] = this.request.toLogString(linePrefix + linePrefix);
        objectArray[2] = "";
        objectArray[3] = linePrefix + "Response at " + this.responseTime;
        HttpResponse httpResponse = this.response;
        objectArray[4] = httpResponse != null ? httpResponse.toLogString(linePrefix + linePrefix) : null;
        List mainMessage = CollectionsKt.listOf((Object[])objectArray);
        List messageSuffix = CollectionsKt.listOf((Object)"");
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)messagePrefix, (Iterable)commentLines), (Iterable)contractPathLines), (Iterable)mainMessage), (Iterable)messageSuffix);
        String string = System.lineSeparator();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lineSeparator(...)");
        return CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null);
    }

    @Override
    @NotNull
    public JSONObjectValue toJSONObject() {
        Map log2 = new LinkedHashMap();
        log2.put("requestTime", new StringValue(this.requestTime.toLogString()));
        log2.put("http-request", this.request.toJSON());
        Map map = log2;
        String string = "http-response";
        Object object = this.response;
        if (object == null || (object = ((HttpResponse)object).toJSON()) == null) {
            object = new JSONObjectValue(null, 1, null);
        }
        Object object2 = object;
        map.put(string, object2);
        map = log2;
        string = "responseTime";
        Object object3 = this.responseTime;
        if (object3 == null || (object3 = ((CurrentDate)object3).toLogString()) == null) {
            object3 = "";
        }
        object2 = new StringValue((String)object3);
        map.put(string, object2);
        log2.put("contractMatched", new StringValue(this.contractPath));
        return new JSONObjectValue(MapsKt.toMap((Map)log2));
    }

    public final void addResponse(@NotNull HttpStubResponse stubResponse2) {
        Intrinsics.checkNotNullParameter((Object)stubResponse2, (String)"stubResponse");
        this.addResponseWithCurrentTime(stubResponse2.getResponse());
        this.contractPath = stubResponse2.getContractPath();
        this.examplePath = stubResponse2.getExamplePath();
        this.scenario = stubResponse2.getScenario();
    }

    public final void logStartRequestTime() {
        this.requestTime = new CurrentDate(null, 1, null);
    }

    public final boolean isTestLog() {
        return this.scenario != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final TestResult toResult() {
        TestResult testResult;
        block5: {
            block4: {
                if (this.examplePath != null) break block4;
                if (this.scenario == null) break block5;
                HttpResponse httpResponse = this.response;
                if (CollectionsKt.contains((Iterable)HttpRequestPatternKt.getInvalidRequestStatuses(), (Object)(httpResponse != null ? Integer.valueOf(httpResponse.getStatus()) : null))) break block5;
            }
            testResult = TestResult.Success;
            return testResult;
        }
        if (this.scenario == null) {
            testResult = TestResult.MissingInSpec;
            return testResult;
        }
        testResult = TestResult.Failed;
        return testResult;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String toDetails() {
        Object object;
        if (this.examplePath != null) {
            object = "Request Matched Example: " + this.examplePath;
            return object;
        }
        if (this.scenario != null) {
            HttpResponse httpResponse = this.response;
            if (!CollectionsKt.contains((Iterable)HttpRequestPatternKt.getInvalidRequestStatuses(), (Object)(httpResponse != null ? Integer.valueOf(httpResponse.getStatus()) : null))) {
                Scenario scenario = this.scenario;
                object = "Request Matched Contract " + (scenario != null ? scenario.getApiDescription() : null);
                return object;
            }
        }
        if (this.exception != null) {
            String string;
            Exception exception = this.exception;
            if (exception != null) {
                Throwable p0 = exception;
                boolean bl = false;
                string = Utilities.exceptionCauseMessage(p0);
            } else {
                string = null;
            }
            object = "Invalid Request\n" + string;
            return object;
        }
        HttpResponse httpResponse = this.response;
        object = httpResponse;
        if (httpResponse == null) return "Request Didn't Match Contract";
        Value value2 = ((HttpResponse)object).getBody();
        object = value2;
        if (value2 == null) return "Request Didn't Match Contract";
        String string = object.toStringLiteral();
        object = string;
        if (string != null) return object;
        return "Request Didn't Match Contract";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toName() {
        String string;
        Scenario scenario;
        Scenario scenario2 = this.scenario;
        if (scenario2 == null) {
            return "Unknown Request";
        }
        Scenario scenario3 = scenario = scenario2;
        String string2 = null;
        HttpRequestPattern httpRequestPattern = null;
        HttpResponsePattern httpResponsePattern = null;
        Map map = null;
        List list = null;
        Map map2 = null;
        Map map3 = null;
        boolean bl = false;
        Map map4 = null;
        Map map5 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        BadRequestOrDefault badRequestOrDefault = null;
        String string3 = this.examplePath;
        if (string3 != null) {
            void p0;
            String string4 = string3;
            BadRequestOrDefault badRequestOrDefault2 = badRequestOrDefault;
            boolean bl4 = bl3;
            boolean bl5 = bl2;
            Map map6 = map5;
            Map map7 = map4;
            boolean bl6 = bl;
            Map map8 = map3;
            Map map9 = map2;
            List list2 = list;
            Map map10 = map;
            HttpResponsePattern httpResponsePattern2 = httpResponsePattern;
            HttpRequestPattern httpRequestPattern2 = httpRequestPattern;
            String string5 = string2;
            Scenario scenario4 = scenario3;
            boolean bl7 = false;
            File file = new File((String)p0);
            scenario3 = scenario4;
            string2 = string5;
            httpRequestPattern = httpRequestPattern2;
            httpResponsePattern = httpResponsePattern2;
            map = map10;
            list = list2;
            map2 = map9;
            map3 = map8;
            bl = bl6;
            map4 = map7;
            map5 = map6;
            bl2 = bl5;
            bl3 = bl4;
            badRequestOrDefault = badRequestOrDefault2;
            string = file.getName();
        } else {
            string = null;
        }
        return Scenario.copy$default(scenario3, string2, httpRequestPattern, httpResponsePattern, map, list, map2, map3, bl, map4, map5, bl2, bl3, badRequestOrDefault, string, false, null, null, null, null, null, null, null, null, null, null, null, null, null, 0xFFFDFFF, null).testDescription();
    }

    @NotNull
    public final CurrentDate component1() {
        return this.requestTime;
    }

    @NotNull
    public final HttpRequest component2() {
        return this.request;
    }

    @Nullable
    public final CurrentDate component3() {
        return this.responseTime;
    }

    @Nullable
    public final HttpResponse component4() {
        return this.response;
    }

    @NotNull
    public final String component5() {
        return this.contractPath;
    }

    @Nullable
    public final String component6() {
        return this.examplePath;
    }

    @NotNull
    public final String component7() {
        return this.targetServer;
    }

    @Nullable
    public final String component8() {
        return this.comment;
    }

    @Nullable
    public final Scenario component9() {
        return this.scenario;
    }

    @Nullable
    public final Exception component10() {
        return this.exception;
    }

    @NotNull
    public final HttpLogMessage copy(@NotNull CurrentDate requestTime, @NotNull HttpRequest request, @Nullable CurrentDate responseTime, @Nullable HttpResponse response, @NotNull String contractPath, @Nullable String examplePath, @NotNull String targetServer, @Nullable String comment, @Nullable Scenario scenario, @Nullable Exception exception) {
        Intrinsics.checkNotNullParameter((Object)requestTime, (String)"requestTime");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)contractPath, (String)"contractPath");
        Intrinsics.checkNotNullParameter((Object)targetServer, (String)"targetServer");
        return new HttpLogMessage(requestTime, request, responseTime, response, contractPath, examplePath, targetServer, comment, scenario, exception);
    }

    public static /* synthetic */ HttpLogMessage copy$default(HttpLogMessage httpLogMessage, CurrentDate currentDate, HttpRequest httpRequest, CurrentDate currentDate2, HttpResponse httpResponse, String string, String string2, String string3, String string4, Scenario scenario, Exception exception, int n, Object object) {
        if ((n & 1) != 0) {
            currentDate = httpLogMessage.requestTime;
        }
        if ((n & 2) != 0) {
            httpRequest = httpLogMessage.request;
        }
        if ((n & 4) != 0) {
            currentDate2 = httpLogMessage.responseTime;
        }
        if ((n & 8) != 0) {
            httpResponse = httpLogMessage.response;
        }
        if ((n & 0x10) != 0) {
            string = httpLogMessage.contractPath;
        }
        if ((n & 0x20) != 0) {
            string2 = httpLogMessage.examplePath;
        }
        if ((n & 0x40) != 0) {
            string3 = httpLogMessage.targetServer;
        }
        if ((n & 0x80) != 0) {
            string4 = httpLogMessage.comment;
        }
        if ((n & 0x100) != 0) {
            scenario = httpLogMessage.scenario;
        }
        if ((n & 0x200) != 0) {
            exception = httpLogMessage.exception;
        }
        return httpLogMessage.copy(currentDate, httpRequest, currentDate2, httpResponse, string, string2, string3, string4, scenario, exception);
    }

    @NotNull
    public String toString() {
        return "HttpLogMessage(requestTime=" + this.requestTime + ", request=" + this.request + ", responseTime=" + this.responseTime + ", response=" + this.response + ", contractPath=" + this.contractPath + ", examplePath=" + this.examplePath + ", targetServer=" + this.targetServer + ", comment=" + this.comment + ", scenario=" + this.scenario + ", exception=" + this.exception + ")";
    }

    public int hashCode() {
        int result2 = this.requestTime.hashCode();
        result2 = result2 * 31 + this.request.hashCode();
        result2 = result2 * 31 + (this.responseTime == null ? 0 : this.responseTime.hashCode());
        result2 = result2 * 31 + (this.response == null ? 0 : this.response.hashCode());
        result2 = result2 * 31 + this.contractPath.hashCode();
        result2 = result2 * 31 + (this.examplePath == null ? 0 : this.examplePath.hashCode());
        result2 = result2 * 31 + this.targetServer.hashCode();
        result2 = result2 * 31 + (this.comment == null ? 0 : this.comment.hashCode());
        result2 = result2 * 31 + (this.scenario == null ? 0 : this.scenario.hashCode());
        result2 = result2 * 31 + (this.exception == null ? 0 : this.exception.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HttpLogMessage)) {
            return false;
        }
        HttpLogMessage httpLogMessage = (HttpLogMessage)other;
        if (!Intrinsics.areEqual((Object)this.requestTime, (Object)httpLogMessage.requestTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.request, (Object)httpLogMessage.request)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.responseTime, (Object)httpLogMessage.responseTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.response, (Object)httpLogMessage.response)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.contractPath, (Object)httpLogMessage.contractPath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.examplePath, (Object)httpLogMessage.examplePath)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetServer, (Object)httpLogMessage.targetServer)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.comment, (Object)httpLogMessage.comment)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.scenario, (Object)httpLogMessage.scenario)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.exception, (Object)httpLogMessage.exception);
    }

    public HttpLogMessage() {
        this(null, null, null, null, null, null, null, null, null, null, 1023, null);
    }
}

