/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import io.specmatic.core.pattern.HasValue;
import io.specmatic.core.pattern.PairOfTypes;
import io.specmatic.core.pattern.Pattern;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.pattern.Row;
import io.specmatic.core.pattern.StringPatternKt;
import io.specmatic.core.pattern.URLScheme;
import io.specmatic.core.pattern.config.NegativePatternConfiguration;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u001a0\u0019j\u0002`\u001bH\u0016J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\t\u0010#\u001a\u00020$H\u00d6\u0001J\u001e\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020&0(2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u001a\u0010)\u001a\u00020\u00132\b\u0010*\u001a\u0004\u0018\u00010&2\u0006\u0010\"\u001a\u00020\u0016H\u0016J,\u0010+\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010-0,2\u0006\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u00020\u00162\u0006\u00100\u001a\u000201H\u0016J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u00010,2\u0006\u0010\"\u001a\u00020\u0016H\u0016J$\u00102\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010-0,2\u0006\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0018\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u0016H\u0016J\t\u00105\u001a\u00020\u0005H\u00d6\u0001R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u00066"}, d2={"Lio/specmatic/core/pattern/URLPattern;", "Lio/specmatic/core/pattern/Pattern;", "scheme", "Lio/specmatic/core/pattern/URLScheme;", "typeAlias", "", "(Lio/specmatic/core/pattern/URLScheme;Ljava/lang/String;)V", "pattern", "getPattern", "()Ljava/lang/String;", "getScheme", "()Lio/specmatic/core/pattern/URLScheme;", "getTypeAlias", "typeName", "getTypeName", "component1", "component2", "copy", "encompasses", "Lio/specmatic/core/Result;", "otherPattern", "thisResolver", "Lio/specmatic/core/Resolver;", "otherResolver", "typeStack", "", "Lio/specmatic/core/pattern/PairOfTypes;", "Lio/specmatic/core/pattern/TypeStack;", "equals", "", "other", "", "generate", "Lio/specmatic/core/value/StringValue;", "resolver", "hashCode", "", "listOf", "Lio/specmatic/core/value/Value;", "valueList", "", "matches", "sampleData", "negativeBasedOn", "Lkotlin/sequences/Sequence;", "Lio/specmatic/core/pattern/ReturnValue;", "row", "Lio/specmatic/core/pattern/Row;", "config", "Lio/specmatic/core/pattern/config/NegativePatternConfiguration;", "newBasedOn", "parse", "value", "toString", "specmatic-core"})
public final class URLPattern
implements Pattern {
    @NotNull
    private final URLScheme scheme;
    @Nullable
    private final String typeAlias;
    @NotNull
    private final String pattern;
    @NotNull
    private final String typeName;

    public URLPattern(@NotNull URLScheme scheme, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)((Object)scheme), (String)"scheme");
        this.scheme = scheme;
        this.typeAlias = typeAlias;
        this.pattern = "(url)";
        this.typeName = "url";
    }

    public /* synthetic */ URLPattern(URLScheme uRLScheme, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            uRLScheme = URLScheme.HTTPS;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(uRLScheme, string);
    }

    @NotNull
    public final URLScheme getScheme() {
        return this.scheme;
    }

    @Override
    @Nullable
    public String getTypeAlias() {
        return this.typeAlias;
    }

    @Override
    @NotNull
    public String getPattern() {
        return this.pattern;
    }

    @Override
    @NotNull
    public Result matches(@Nullable Value sampleData, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return sampleData instanceof StringValue ? (this.scheme.matches(this.parse(((StringValue)sampleData).getString(), resolver)) ? (Result)new Result.Success(null, null, 3, null) : (Result)new Result.Failure("Expected " + ((StringValue)sampleData).getString() + " to be " + this.scheme.getType(), null, null, null, null, 30, null)) : (Result)new Result.Failure("URLs can only be held in strings.", null, null, null, null, 30, null);
    }

    @Override
    @NotNull
    public StringValue generate(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = this.scheme.getPrefix();
        String string2 = StringPatternKt.randomString$default(0, 1, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String string3 = StringPatternKt.randomString$default(0, 1, null).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return new StringValue(string + string2 + ".com/" + string3);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> newBasedOn(@NotNull Row row, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new HasValue[]{new HasValue(this, null, 2, null)};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Sequence<Pattern> newBasedOn(@NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Object[] objectArray = new URLPattern[]{this};
        return SequencesKt.sequenceOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Sequence<ReturnValue<Pattern>> negativeBasedOn(@NotNull Row row, @NotNull Resolver resolver, @NotNull NegativePatternConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        return this.newBasedOn(row, resolver);
    }

    @Override
    @NotNull
    public StringValue parse(@NotNull String value2, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        String string = URI.create(value2).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return new StringValue(string);
    }

    @Override
    @NotNull
    public Result encompasses(@NotNull Pattern otherPattern, @NotNull Resolver thisResolver, @NotNull Resolver otherResolver, @NotNull Set<PairOfTypes> typeStack) {
        Intrinsics.checkNotNullParameter((Object)otherPattern, (String)"otherPattern");
        Intrinsics.checkNotNullParameter((Object)thisResolver, (String)"thisResolver");
        Intrinsics.checkNotNullParameter((Object)otherResolver, (String)"otherResolver");
        Intrinsics.checkNotNullParameter(typeStack, (String)"typeStack");
        Pattern pattern2 = otherPattern;
        return Intrinsics.areEqual((Object)pattern2, (Object)this) ? (Result)new Result.Success(null, null, 3, null) : (pattern2 instanceof URLPattern ? (Result)new Result.Failure("Expected " + this.scheme.getType() + ", got " + ((URLPattern)otherPattern).scheme.getType(), null, null, null, null, 30, null) : (Result)new Result.Failure("Expected " + this.getTypeName() + ", got " + otherPattern.getTypeName(), null, null, null, null, 30, null));
    }

    @Override
    @NotNull
    public Value listOf(@NotNull List<? extends Value> valueList, @NotNull Resolver resolver) {
        Intrinsics.checkNotNullParameter(valueList, (String)"valueList");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        return new JSONArrayValue(valueList);
    }

    @Override
    @NotNull
    public String getTypeName() {
        return this.typeName;
    }

    @NotNull
    public final URLScheme component1() {
        return this.scheme;
    }

    @Nullable
    public final String component2() {
        return this.typeAlias;
    }

    @NotNull
    public final URLPattern copy(@NotNull URLScheme scheme, @Nullable String typeAlias) {
        Intrinsics.checkNotNullParameter((Object)((Object)scheme), (String)"scheme");
        return new URLPattern(scheme, typeAlias);
    }

    public static /* synthetic */ URLPattern copy$default(URLPattern uRLPattern, URLScheme uRLScheme, String string, int n, Object object) {
        if ((n & 1) != 0) {
            uRLScheme = uRLPattern.scheme;
        }
        if ((n & 2) != 0) {
            string = uRLPattern.typeAlias;
        }
        return uRLPattern.copy(uRLScheme, string);
    }

    @NotNull
    public String toString() {
        return "URLPattern(scheme=" + this.scheme + ", typeAlias=" + this.typeAlias + ")";
    }

    public int hashCode() {
        int result2 = this.scheme.hashCode();
        result2 = result2 * 31 + (this.typeAlias == null ? 0 : this.typeAlias.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof URLPattern)) {
            return false;
        }
        URLPattern uRLPattern = (URLPattern)other;
        if (this.scheme != uRLPattern.scheme) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.typeAlias, (Object)uRLPattern.typeAlias);
    }

    public URLPattern() {
        this(null, null, 3, null);
    }
}

