/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.SpecmaticConfigKt;
import io.specmatic.core.log.LoggingKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0007H\u0002J\u0012\u0010\u0018\u001a\u00020\f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u0012\u001a6\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0015*\b\u0012\u0002\b\u0003\u0018\u00010\u00140\u0014 \u0015*\u001a\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003 \u0015*\b\u0012\u0002\b\u0003\u0018\u00010\u00140\u0014\u0018\u00010\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/specmatic/core/utilities/FileSystemChanges;", "", "key", "Ljava/nio/file/WatchKey;", "(Ljava/nio/file/WatchKey;)V", "events", "", "", "filesWithEvents", "getFilesWithEvents", "()Ljava/lang/String;", "hasNoEvents", "", "getHasNoEvents", "()Z", "interestingEvents", "getInterestingEvents", "()Ljava/util/List;", "rawEvents", "", "Ljava/nio/file/WatchEvent;", "kotlin.jvm.PlatformType", "interesting", "event", "parentDirectoryIsExamplesDir", "path", "Ljava/nio/file/Path;", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nFileSystemChanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileSystemChanges.kt\nio/specmatic/core/utilities/FileSystemChanges\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1549#2:52\n1620#2,3:53\n766#2:56\n857#2,2:57\n766#2:59\n857#2,2:60\n*S KotlinDebug\n*F\n+ 1 FileSystemChanges.kt\nio/specmatic/core/utilities/FileSystemChanges\n*L\n17#1:52\n17#1:53,3\n19#1:56\n19#1:57,2\n26#1:59\n26#1:60,2\n*E\n"})
public final class FileSystemChanges {
    @NotNull
    private final WatchKey key;
    private final List<WatchEvent<?>> rawEvents;
    @NotNull
    private final List<String> events;
    @NotNull
    private final String filesWithEvents;
    @NotNull
    private final List<String> interestingEvents;

    /*
     * WARNING - void declaration
     */
    public FileSystemChanges(@NotNull WatchKey key2) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        String it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)key2, (String)"key");
        this.key = key2;
        List<WatchEvent<?>> list = this.rawEvents = this.key.pollEvents();
        Intrinsics.checkNotNullExpressionValue(list, (String)"rawEvents");
        Iterable iterable = list;
        FileSystemChanges fileSystemChanges = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            WatchEvent watchEvent = (WatchEvent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object t = it.context();
            String string = t != null ? t.toString() : null;
            if (string == null) {
                string = "";
            }
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fileSystemChanges.events = (List)destination$iv$iv;
        this.filesWithEvents = CollectionsKt.joinToString$default((Iterable)this.events, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        $this$filter$iv = this.events;
        fileSystemChanges = this;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String event = (String)element$iv$iv;
            boolean bl = false;
            if (!this.interesting(event)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        fileSystemChanges.interestingEvents = (List)destination$iv$iv;
    }

    public final boolean getHasNoEvents() {
        return this.events.isEmpty();
    }

    @NotNull
    public final String getFilesWithEvents() {
        return this.filesWithEvents;
    }

    @NotNull
    public final List<String> getInterestingEvents() {
        return this.interestingEvents;
    }

    private final boolean interesting(String event) {
        try {
            Watchable watchable;
            File file = new File(event);
            String string = FilesKt.getExtension((File)file).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String extension = string;
            return SpecmaticConfigKt.getCONTRACT_EXTENSIONS().contains(extension) || Intrinsics.areEqual((Object)extension, (Object)"json") || StringsKt.endsWith$default((String)FilesKt.getNameWithoutExtension((File)file), (String)"_examples", (boolean)false, (int)2, null) || this.parentDirectoryIsExamplesDir((watchable = this.key.watchable()) instanceof Path ? (Path)watchable : null);
        }
        catch (Throwable e) {
            return false;
        }
    }

    private final boolean parentDirectoryIsExamplesDir(Path path2) {
        if (path2 == null) {
            return false;
        }
        LoggingKt.getLogger().debug("Checking if " + path2 + " is or is in an examples directory");
        return StringsKt.endsWith$default((String)((Object)path2).toString(), (String)"_examples", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)((Object)path2).toString(), (CharSequence)("_examples" + File.separator), (boolean)false, (int)2, null);
    }
}

