/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.SpecmaticConfigKt;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.log.StringLog;
import io.specmatic.core.utilities.FileSystemChanges;
import io.specmatic.core.utilities.Utilities;
import java.io.Closeable;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0014\u0010\u0012\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/specmatic/core/utilities/StubServerWatcher;", "", "contractPaths", "", "", "(Ljava/util/List;)V", "dataDirOf", "contractFile", "Ljava/io/File;", "dataDirOf$specmatic_core", "getFileSystemChanges", "Lkotlin/sequences/Sequence;", "Lio/specmatic/core/utilities/FileSystemChanges;", "getPaths", "registerForFileSystemChanges", "", "watchService", "Ljava/nio/file/WatchService;", "watchForChanges", "onChange", "Lkotlin/Function0;", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nStubServerWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StubServerWatcher.kt\nio/specmatic/core/utilities/StubServerWatcher\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n1313#2,2:79\n1549#3:81\n1620#3,3:82\n1855#3,2:85\n1549#3:87\n1620#3,3:88\n1360#3:91\n1446#3,2:92\n1549#3:94\n1620#3,3:95\n1448#3,3:98\n*S KotlinDebug\n*F\n+ 1 StubServerWatcher.kt\nio/specmatic/core/utilities/StubServerWatcher\n*L\n18#1:79,2\n37#1:81\n37#1:82,3\n39#1:85,2\n58#1:87\n58#1:88,3\n58#1:91\n58#1:92,2\n67#1:94\n67#1:95,3\n58#1:98,3\n*E\n"})
public final class StubServerWatcher {
    @NotNull
    private final List<String> contractPaths;

    public StubServerWatcher(@NotNull List<String> contractPaths) {
        Intrinsics.checkNotNullParameter(contractPaths, (String)"contractPaths");
        this.contractPaths = contractPaths;
    }

    public final void watchForChanges(@NotNull Function0<Unit> onChange) {
        Intrinsics.checkNotNullParameter(onChange, (String)"onChange");
        Sequence<FileSystemChanges> $this$forEach$iv = this.getFileSystemChanges();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileSystemChanges change = (FileSystemChanges)element$iv;
            boolean bl = false;
            if (change.getHasNoEvents()) {
                LoggingKt.getLogger().debug("Uninteresting file system event, skipping restart");
                continue;
            }
            if (change.getInterestingEvents().isEmpty()) {
                LoggingKt.getLogger().debug("Uninteresting file system events for " + change.getFilesWithEvents() + ", skipping restart");
                continue;
            }
            LoggingKt.getLogger().boundary();
            LoggingKt.consoleLog(new StringLog("Detected event(s) for " + change.getFilesWithEvents() + ", restarting stub server."));
            onChange.invoke();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void registerForFileSystemChanges(WatchService watchService) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)this.getPaths(this.contractPaths)));
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new File((String)it).toPath());
        }
        List paths = (List)destination$iv$iv;
        Iterable $this$forEach$iv = paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path contractPath = (Path)element$iv;
            boolean bl = false;
            WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE};
            contractPath.register(watchService, kindArray);
        }
    }

    private final Sequence<FileSystemChanges> getFileSystemChanges() {
        return SequencesKt.generateSequence((Function0)((Function0)new Function0<FileSystemChanges>(this){
            final /* synthetic */ StubServerWatcher this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final FileSystemChanges invoke() {
                FileSystemChanges fileSystemChanges;
                Closeable closeable = FileSystems.getDefault().newWatchService();
                StubServerWatcher stubServerWatcher = this.this$0;
                Throwable throwable = null;
                try {
                    FileSystemChanges fileSystemChanges2;
                    WatchKey watchKey;
                    WatchService watchService = (WatchService)closeable;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)watchService);
                    StubServerWatcher.access$registerForFileSystemChanges(stubServerWatcher, watchService);
                    WatchKey watchKey2 = watchKey = watchService.take();
                    if (watchKey2 != null) {
                        Intrinsics.checkNotNull((Object)watchKey2);
                        WatchKey key2 = watchKey;
                        boolean bl2 = false;
                        key2.reset();
                        fileSystemChanges2 = new FileSystemChanges(key2);
                    } else {
                        fileSystemChanges2 = null;
                    }
                    fileSystemChanges = fileSystemChanges2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                return fileSystemChanges;
            }
        }));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<String> getPaths(List<String> contractPaths) {
        $this$map$iv = contractPaths;
        $i$f$map = false;
        var4_4 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var9_10 = (String)item$iv$iv;
            var24_8 = destination$iv$iv;
            $i$a$-map-StubServerWatcher$getPaths$1 = false;
            var24_8.add(new File((String)it));
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            block6: {
                block9: {
                    block8: {
                        block7: {
                            block5: {
                                it = (File)element$iv$iv;
                                $i$a$-flatMap-StubServerWatcher$getPaths$2 = false;
                                if (!it.isFile()) break block5;
                                v0 = SpecmaticConfigKt.getCONTRACT_EXTENSIONS();
                                v1 = FilesKt.getExtension((File)it).toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toLowerCase(...)");
                                if (!v0.contains(v1)) break block5;
                                v2 = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)it.getAbsoluteFile().getParentFile().getPath()), (Iterable)this.getPaths(CollectionsKt.listOf((Object)this.dataDirOf$specmatic_core(it))));
                                break block6;
                            }
                            if (!it.isFile() || !StringsKt.equals((String)FilesKt.getExtension((File)it), (String)"yaml", (boolean)true)) break block7;
                            v2 = CollectionsKt.listOf((Object)it.getAbsolutePath());
                            break block6;
                        }
                        if (!it.isFile() || !StringsKt.equals((String)FilesKt.getExtension((File)it), (String)"json", (boolean)true)) break block8;
                        v2 = CollectionsKt.listOf((Object)it.getAbsoluteFile().getParentFile().getPath());
                        break block6;
                    }
                    if (!it.isDirectory()) break block9;
                    v3 = CollectionsKt.listOf((Object)it.getAbsolutePath());
                    v4 = this;
                    v5 /* !! */  = var11_12 = it.listFiles();
                    if (var11_12 == null) ** GOTO lbl-1000
                    Intrinsics.checkNotNull((Object)v5 /* !! */ );
                    v5 /* !! */  = ArraysKt.toList((Object[])var11_12);
                    if (v5 /* !! */  != null) {
                        var12_13 = (Iterable)v5 /* !! */ ;
                        var13_14 = v4;
                        var14_15 = v3;
                        $i$f$map = false;
                        var16_17 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var21_22 = (File)item$iv$iv;
                            var22_23 = destination$iv$iv;
                            $i$a$-map-StubServerWatcher$getPaths$2$1 = false;
                            var22_23.add(file.getAbsolutePath());
                        }
                        var22_23 = (List)destination$iv$iv;
                        v3 = var14_15;
                        v4 = var13_14;
                        v6 = var22_23;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v6 = CollectionsKt.emptyList();
                    }
                    v2 = CollectionsKt.plus((Collection)v3, (Iterable)v4.getPaths(v6));
                    break block6;
                }
                v2 = CollectionsKt.emptyList();
            }
            list$iv$iv = v2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String dataDirOf$specmatic_core(@NotNull File contractFile) {
        Intrinsics.checkNotNullParameter((Object)contractFile, (String)"contractFile");
        File examplesDir = Utilities.examplesDirFor(contractFile.getAbsoluteFile().getParent() + "/" + contractFile.getName(), "_data");
        return examplesDir.getAbsoluteFile().getParent() + "/" + examplesDir.getName();
    }

    public static final /* synthetic */ void access$registerForFileSystemChanges(StubServerWatcher $this, WatchService watchService) {
        $this.registerForFileSystemChanges(watchService);
    }
}

