/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.utilities.YAMLSerialisationKt;
import io.specmatic.core.value.BooleanValue;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.NullValue;
import io.specmatic.core.value.NumberValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a@\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\n0\b\"\u0004\b\u0000\u0010\n2\u000e\u0010\u000b\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0014\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u0002H\n0\rH\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000eH\u0002\u001a\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\t\u001a\f\u0010\u0014\u001a\u00020\t*\u00020\tH\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"yamlFactory", "Lcom/fasterxml/jackson/dataformat/yaml/YAMLFactory;", "kotlin.jvm.PlatformType", "yamlMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getYamlMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "convertToMap", "", "", "T", "data", "using", "Lkotlin/Function1;", "", "toValue", "Lio/specmatic/core/value/Value;", "any", "yamlStringToValue", "stringContent", "cleanBOM", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nYAMLSerialisation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLSerialisation.kt\nio/specmatic/core/utilities/YAMLSerialisationKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1179#2,2:38\n1253#2,4:40\n1549#2:45\n1620#2,3:46\n1#3:44\n*S KotlinDebug\n*F\n+ 1 YAMLSerialisation.kt\nio/specmatic/core/utilities/YAMLSerialisationKt\n*L\n23#1:38,2\n23#1:40,4\n30#1:45\n30#1:46,3\n*E\n"})
public final class YAMLSerialisationKt {
    private static final YAMLFactory yamlFactory = new YAMLFactory().disable(YAMLGenerator.Feature.WRITE_DOC_START_MARKER).enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
    @NotNull
    private static final ObjectMapper yamlMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper((JsonFactory)yamlFactory));

    @NotNull
    public static final ObjectMapper getYamlMapper() {
        return yamlMapper;
    }

    @NotNull
    public static final Value yamlStringToValue(@NotNull String stringContent) {
        Intrinsics.checkNotNullParameter((Object)stringContent, (String)"stringContent");
        String cleaned = YAMLSerialisationKt.cleanBOM(stringContent);
        Object object = yamlMapper.readValue(cleaned, Object.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readValue(...)");
        Object raw = object;
        return YAMLSerialisationKt.toValue(raw);
    }

    private static final String cleanBOM(String $this$cleanBOM) {
        return StringsKt.removePrefix((String)$this$cleanBOM, (CharSequence)"\ufeff");
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> Map<String, T> convertToMap(Map<?, ?> data2, Function1<Object, ? extends T> using) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = data2.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object k = entry.getKey();
            Object v = entry.getValue();
            entry = TuplesKt.to((Object)String.valueOf(k), (Object)using.invoke(v));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Value toValue(Object any) {
        Value value2;
        Object object = any;
        if (object == null) {
            value2 = NullValue.INSTANCE;
        } else if (object instanceof Map) {
            Map p0 = YAMLSerialisationKt.convertToMap((Map)any, toValue.1.INSTANCE);
            boolean bl = false;
            value2 = new JSONObjectValue(p0);
        } else if (object instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)any;
            boolean $i$f$map = false;
            Iterable bl = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void p0;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(YAMLSerialisationKt.toValue(p0));
            }
            List p0 = (List)destination$iv$iv;
            boolean bl3 = false;
            value2 = new JSONArrayValue(p0);
        } else if (object instanceof String) {
            value2 = new StringValue((String)any);
        } else if (object instanceof Boolean) {
            value2 = new BooleanValue((Boolean)any);
        } else if (object instanceof Number) {
            value2 = new NumberValue((Number)any);
        } else {
            throw new ContractException("Unknown value type: " + Reflection.getOrCreateKotlinClass(any.getClass()).getSimpleName(), null, null, null, false, 30, null);
        }
        return value2;
    }

    public static final /* synthetic */ Value access$toValue(Object any) {
        return YAMLSerialisationKt.toValue(any);
    }
}

