/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.reports;

import io.specmatic.conversions.OpenApiSpecification;
import io.specmatic.conversions.SpringRequestMappingKt;
import io.specmatic.core.Feature;
import io.specmatic.core.Scenario;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.utilities.Utilities;
import io.specmatic.reports.CentralContractRepoReportJson;
import io.specmatic.reports.SpecificationOperation;
import io.specmatic.reports.SpecificationRow;
import io.specmatic.stub.API;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\n\u001a\u00020\u0007H\u0002\u00a8\u0006\u000e"}, d2={"Lio/specmatic/reports/CentralContractRepoReport;", "", "()V", "findSpecifications", "", "Ljava/io/File;", "currentDirectoryPath", "", "generate", "Lio/specmatic/reports/CentralContractRepoReportJson;", "currentWorkingDir", "getSpecificationRows", "Lio/specmatic/reports/SpecificationRow;", "specifications", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nCentralContractRepoReport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CentralContractRepoReport.kt\nio/specmatic/reports/CentralContractRepoReport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1603#2,9:68\n1855#2:77\n1856#2:79\n1612#2:80\n766#2:81\n857#2,2:82\n1549#2:84\n1620#2,2:85\n1549#2:87\n1620#2,3:88\n1622#2:91\n1#3:78\n*S KotlinDebug\n*F\n+ 1 CentralContractRepoReport.kt\nio/specmatic/reports/CentralContractRepoReport\n*L\n22#1:68,9\n22#1:77\n22#1:79\n22#1:80\n33#1:81\n33#1:82,2\n38#1:84\n38#1:85,2\n42#1:87\n42#1:88,3\n38#1:91\n22#1:78\n*E\n"})
public final class CentralContractRepoReport {
    @NotNull
    public final CentralContractRepoReportJson generate(@NotNull String currentWorkingDir) {
        Intrinsics.checkNotNullParameter((Object)currentWorkingDir, (String)"currentWorkingDir");
        String searchPath = new File(currentWorkingDir).getCanonicalPath();
        LoggingKt.getLogger().log("Searching for specification files at: " + searchPath);
        Intrinsics.checkNotNull((Object)searchPath);
        List<File> specifications = this.findSpecifications(searchPath);
        return new CentralContractRepoReportJson(this.getSpecificationRows(CollectionsKt.sorted((Iterable)specifications), searchPath));
    }

    public static /* synthetic */ CentralContractRepoReportJson generate$default(CentralContractRepoReport centralContractRepoReport, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return centralContractRepoReport.generate(string);
    }

    /*
     * WARNING - void declaration
     */
    private final List<SpecificationRow> getSpecificationRows(List<? extends File> specifications, String currentWorkingDir) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        File spec;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Object object;
        Object it;
        void $this$mapNotNullTo$iv$iv;
        File currentWorkingDirPath = new File(currentWorkingDir).getAbsoluteFile();
        Iterable $this$mapNotNull$iv = specifications;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Pair pair = $this$forEach$iv$iv$iv.iterator();
        while (pair.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = pair.next();
            boolean bl = false;
            it = (File)element$iv$iv;
            boolean bl2 = false;
            try {
                String string = FilesKt.readText$default((File)it, null, (int)1, null);
                String string2 = ((File)it).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                Feature feature = OpenApiSpecification.Companion.fromYAML$default(OpenApiSpecification.Companion, string, string2, null, null, null, null, null, null, null, null, false, 2044, null).toFeature();
                object = new Pair(it, (Object)feature);
            }
            catch (Throwable e) {
                LoggingKt.getLogger().log("Could not parse " + ((File)it).getPath() + " due to the following error:");
                LoggingKt.getLogger().log(Utilities.exceptionCauseMessage(e));
                object = null;
            }
            if (object == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            pair = (Pair)element$iv$iv;
            boolean bl = false;
            spec = (File)pair.component1();
            Feature feature = (Feature)pair.component2();
            if (feature.getScenarios().isEmpty()) {
                LoggingKt.getLogger().log("Excluding specification: " + spec.getPath() + " as it does not have any paths ");
            }
            boolean bl4 = !((Collection)feature.getScenarios()).isEmpty();
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Collection<SpecificationOperation> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            pair = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            spec = (File)pair.component1();
            Feature feature = (Feature)pair.component2();
            File file = new File("").getCanonicalFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getCanonicalFile(...)");
            Intrinsics.checkNotNullExpressionValue((Object)FilesKt.relativeTo((File)spec, (File)file).getPath(), (String)"getPath(...)");
            it = feature.getScenarios();
            String string = feature.getServiceType();
            boolean $i$f$map2 = false;
            void var21_28 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                Scenario scenario = (Scenario)item$iv$iv2;
                collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(new SpecificationOperation(SpringRequestMappingKt.convertPathParameterStyle(it2.getPath()), it2.getMethod(), it2.getHttpResponsePattern().getStatus()));
            }
            collection = (List)destination$iv$iv2;
            List list = collection;
            String string3 = string;
            Object object2 = object;
            collection2.add(new SpecificationRow((String)object2, string3, list));
        }
        return (List)destination$iv$iv;
    }

    private final List<File> findSpecifications(String currentDirectoryPath) {
        File currentDirectory = new File(currentDirectoryPath);
        List specifications = new ArrayList();
        File[] fileArray = currentDirectory.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        for (File file : fileArray) {
            if (file.isDirectory()) {
                String string = file.getCanonicalPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
                specifications.addAll((Collection)this.findSpecifications(string));
                continue;
            }
            String string = file.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
            if (!API.hasOpenApiFileExtension(string)) continue;
            String string2 = file.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
            if (!API.isOpenAPI(string2)) continue;
            Intrinsics.checkNotNull((Object)file);
            specifications.add(file);
        }
        return specifications;
    }
}

