/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.test;

import io.specmatic.core.DefaultMismatchMessages;
import io.specmatic.core.Feature;
import io.specmatic.core.HttpRequest;
import io.specmatic.core.HttpResponse;
import io.specmatic.core.Result;
import io.specmatic.core.Scenario;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.pattern.HasException;
import io.specmatic.core.pattern.HasFailure;
import io.specmatic.core.pattern.HasValue;
import io.specmatic.core.pattern.ReturnValue;
import io.specmatic.core.value.JSONArrayValue;
import io.specmatic.core.value.JSONObjectValue;
import io.specmatic.core.value.NullValue;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import io.specmatic.test.ResponseMonitorKt;
import io.specmatic.test.Sleeper;
import io.specmatic.test.TestExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 12\u00020\u0001:\u000212B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\tH\u0002J\n\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\u001a\u0010\u001e\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160 0\u001fH\u0002J(\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0018\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00070 0#H\u0002J\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f2\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010&\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020\u00070 0\u001f*\u00020\u0007H\u0002J\f\u0010'\u001a\u00020$*\u00020\u0007H\u0002J\f\u0010(\u001a\u00020\u0007*\u00020\u0007H\u0002J\u0016\u0010)\u001a\u0004\u0018\u00010\u0016*\u00020\u00072\u0006\u0010*\u001a\u00020\u001aH\u0002J \u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001a0,*\u00020-2\u0006\u0010.\u001a\u00020\u001aH\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0005*\u00020\u0016H\u0002J\f\u0010/\u001a\u00020$*\u00020-H\u0002J\f\u00100\u001a\u00020\u0007*\u00020-H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lio/specmatic/test/ResponseMonitor;", "", "feature", "Lio/specmatic/core/Feature;", "originalScenario", "Lio/specmatic/core/Scenario;", "response", "Lio/specmatic/core/HttpResponse;", "maxRetry", "", "backOffDelay", "", "sleeper", "Lio/specmatic/test/Sleeper;", "(Lio/specmatic/core/Feature;Lio/specmatic/core/Scenario;Lio/specmatic/core/HttpResponse;IJLio/specmatic/test/Sleeper;)V", "getOriginalScenario", "()Lio/specmatic/core/Scenario;", "checkStatus", "monitorScenario", "executor", "Lio/specmatic/test/TestExecutor;", "monitorLink", "Lio/specmatic/test/ResponseMonitor$Link;", "extractLinksFromHeader", "", "headerValue", "", "getBackOffDelay", "retryCount", "getProcessingScenario", "getScenarioAndLink", "Lio/specmatic/core/pattern/ReturnValue;", "Lkotlin/Pair;", "validateMonitorResponse", "monitorValue", "Lio/specmatic/core/pattern/HasValue;", "Lio/specmatic/core/HttpRequest;", "waitForResponse", "checkCompletion", "convertToOriginalRequest", "convertToOriginalResponse", "extractMonitorLinkFromHeader", "key", "getMapOrEmpty", "", "Lio/specmatic/core/value/JSONObjectValue;", "path", "toRequest", "toResponse", "Companion", "Link", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nResponseMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResponseMonitor.kt\nio/specmatic/test/ResponseMonitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1549#2:190\n1620#2,3:191\n1549#2:194\n1620#2,2:195\n1549#2:197\n1620#2,3:198\n1622#2:201\n288#2,2:203\n1603#2,9:205\n1855#2:214\n1856#2:216\n1612#2:217\n288#2,2:218\n1#3:202\n1#3:215\n*S KotlinDebug\n*F\n+ 1 ResponseMonitor.kt\nio/specmatic/test/ResponseMonitor\n*L\n92#1:190\n92#1:191,3\n93#1:194\n93#1:195,2\n94#1:197\n94#1:198,3\n93#1:201\n125#1:203,2\n169#1:205,9\n169#1:214\n169#1:216\n169#1:217\n178#1:218,2\n169#1:215\n*E\n"})
public final class ResponseMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Feature feature;
    @NotNull
    private final Scenario originalScenario;
    @NotNull
    private final HttpResponse response;
    private final int maxRetry;
    private final long backOffDelay;
    @NotNull
    private final Sleeper sleeper;
    @NotNull
    private static final String headerKey = "Link";
    @NotNull
    private static final String requestPath = "request";
    @NotNull
    private static final String responsePath = "response";

    public ResponseMonitor(@NotNull Feature feature, @NotNull Scenario originalScenario, @NotNull HttpResponse response, int maxRetry, long backOffDelay, @NotNull Sleeper sleeper) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)originalScenario, (String)"originalScenario");
        Intrinsics.checkNotNullParameter((Object)response, (String)responsePath);
        Intrinsics.checkNotNullParameter((Object)sleeper, (String)"sleeper");
        this.feature = feature;
        this.originalScenario = originalScenario;
        this.response = response;
        this.maxRetry = maxRetry;
        this.backOffDelay = backOffDelay;
        this.sleeper = sleeper;
    }

    public /* synthetic */ ResponseMonitor(Feature feature, Scenario scenario, HttpResponse httpResponse, int n, long l, Sleeper sleeper, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 3;
        }
        if ((n2 & 0x10) != 0) {
            l = 1000L;
        }
        if ((n2 & 0x20) != 0) {
            sleeper = ResponseMonitorKt.getDefaultSleeper();
        }
        this(feature, scenario, httpResponse, n, l, sleeper);
    }

    @NotNull
    public final Scenario getOriginalScenario() {
        return this.originalScenario;
    }

    @NotNull
    public final ReturnValue<HttpResponse> waitForResponse(@NotNull TestExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ReturnValue<Pair<Scenario, Link>> result2 = this.getScenarioAndLink();
        if (!(result2 instanceof HasValue)) {
            if (result2 instanceof HasException) {
                return ((HasException)result2).cast();
            }
            if (result2 instanceof HasFailure) {
                return ((HasFailure)result2).cast();
            }
            throw new NoWhenBranchMatchedException();
        }
        Pair<Scenario, Link> pair = result2.getValue();
        Scenario monitorScenario = (Scenario)pair.component1();
        Link monitorLink = (Link)pair.component2();
        int n = this.maxRetry;
        for (int i = 0; i < n; ++i) {
            int count = i;
            boolean bl = false;
            try {
                HttpResponse response = this.checkStatus(monitorScenario, executor, monitorLink);
                Scenario.matches$default(monitorScenario, response, null, null, 6, null).throwOnFailure();
                ReturnValue<Pair<HttpRequest, HttpResponse>> monitorComplete = this.checkCompletion(response);
                if (monitorComplete instanceof HasValue) {
                    return this.validateMonitorResponse((HasValue)monitorComplete);
                }
                long delay = this.getBackOffDelay(count);
                if (count >= this.maxRetry - 1) continue;
                this.sleeper.sleep(delay);
                continue;
            }
            catch (Exception e) {
                return new HasException(e, null, null, 6, null);
            }
        }
        return new HasFailure("Max retries exceeded, monitor link: " + monitorLink);
    }

    private final ReturnValue<HttpResponse> validateMonitorResponse(HasValue<Pair<HttpRequest, HttpResponse>> monitorValue) {
        HttpResponse responseFromMonitor;
        Pair<HttpRequest, HttpResponse> pair = monitorValue.getValue();
        HttpRequest requestFromMonitor = (HttpRequest)pair.component1();
        io.specmatic.core.Result result2 = Scenario.matches$default(this.originalScenario, requestFromMonitor, responseFromMonitor = (HttpResponse)pair.component2(), DefaultMismatchMessages.INSTANCE, this.feature.getFlagsBased(), false, false, 16, null).breadCrumb("MONITOR");
        return result2 instanceof Result.Failure ? (ReturnValue)new HasFailure((Result.Failure)result2, "Monitor request / response doesn't match scenario") : (ReturnValue)new HasValue(responseFromMonitor, null, 2, null);
    }

    private final ReturnValue<Pair<Scenario, Link>> getScenarioAndLink() {
        Scenario scenario = this.getProcessingScenario();
        if (scenario == null) {
            return new HasFailure("No accepted response scenario found for " + this.originalScenario.getApiDescription());
        }
        Scenario processingScenario = scenario;
        io.specmatic.core.Result processingScenarioResult = Scenario.matches$default(processingScenario, this.response, null, null, 6, null);
        if (processingScenarioResult instanceof Result.Failure) {
            return new HasFailure((Result.Failure)processingScenarioResult, "Response doesn't match processing scenario");
        }
        Link monitorLink = this.extractMonitorLinkFromHeader(this.response, headerKey);
        Object object = monitorLink;
        if (object == null || (object = this.monitorScenario((Link)object)) == null) {
            return new HasFailure("No monitor scenario found matching link: " + monitorLink);
        }
        Object monitorScenario = object;
        return new HasValue(new Pair(monitorScenario, (Object)monitorLink), null, 2, null);
    }

    private final HttpResponse checkStatus(Scenario monitorScenario, TestExecutor executor, Link monitorLink) {
        HttpRequest request = Scenario.generateHttpRequest$default(monitorScenario, null, 1, null).updatePath(monitorLink.toPath());
        return executor.execute(request);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Link> extractLinksFromHeader(String headerValue) {
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)headerValue, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void link;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{";"};
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)link), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it2;
                String string = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it2))).toString());
            }
            List parts = (List)destination$iv$iv2;
            String url = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)((String)parts.get(0)), (CharSequence)"<"), (CharSequence)">");
            String rel = StringsKt.removeSurrounding((String)StringsKt.removePrefix((String)((String)parts.get(1)), (CharSequence)"rel="), (CharSequence)"\"");
            String string = (String)CollectionsKt.getOrNull((List)parts, (int)2);
            String title = string != null && (string = StringsKt.removePrefix((String)string, (CharSequence)"title=")) != null ? StringsKt.removeSurrounding((String)string, (CharSequence)"\"") : null;
            collection.add(new Link(url, rel, title));
        }
        return (List)destination$iv$iv;
    }

    private final long getBackOffDelay(int retryCount) {
        return this.backOffDelay * (long)Math.pow(2.0, retryCount);
    }

    private final HttpResponse convertToOriginalResponse(HttpResponse $this$convertToOriginalResponse) {
        if (!($this$convertToOriginalResponse.getBody() instanceof JSONObjectValue)) {
            throw new ContractException("Monitor response body is not an object", null, null, null, false, 30, null);
        }
        return this.toResponse((JSONObjectValue)$this$convertToOriginalResponse.getBody());
    }

    private final HttpRequest convertToOriginalRequest(HttpResponse $this$convertToOriginalRequest) {
        if (!($this$convertToOriginalRequest.getBody() instanceof JSONObjectValue)) {
            throw new ContractException("Monitor response body is not an object", null, null, null, false, 30, null);
        }
        return this.toRequest((JSONObjectValue)$this$convertToOriginalRequest.getBody());
    }

    private final ReturnValue<Pair<HttpRequest, HttpResponse>> checkCompletion(HttpResponse $this$checkCompletion) {
        Object $this$checkCompletion_u24lambda_u244;
        Object object = $this$checkCompletion;
        try {
            $this$checkCompletion_u24lambda_u244 = object;
            boolean bl = false;
            $this$checkCompletion_u24lambda_u244 = Result.constructor-impl((Object)TuplesKt.to((Object)this.convertToOriginalRequest((HttpResponse)$this$checkCompletion_u24lambda_u244), (Object)this.convertToOriginalResponse((HttpResponse)$this$checkCompletion_u24lambda_u244)));
        }
        catch (Throwable bl) {
            $this$checkCompletion_u24lambda_u244 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$checkCompletion_u24lambda_u244;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            return new HasException(it, null, null, 6, null);
        }
        Pair pair = (Pair)object;
        HttpRequest request = (HttpRequest)pair.component1();
        HttpResponse response = (HttpResponse)pair.component2();
        return new HasValue(TuplesKt.to((Object)request, (Object)response), null, 2, null);
    }

    private final Link extractMonitorLinkFromHeader(HttpResponse $this$extractMonitorLinkFromHeader, String key2) {
        Object v1;
        block2: {
            String string = $this$extractMonitorLinkFromHeader.getHeaders().get(key2);
            if (string == null) {
                return null;
            }
            String headerValue = string;
            Iterable $this$firstOrNull$iv = this.extractLinksFromHeader(headerValue);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Link it = (Link)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTitle(), (Object)"monitor")) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    private final Scenario getProcessingScenario() {
        if (!Feature.isAcceptedResponsePossible$default(this.feature, this.originalScenario, null, 2, null)) {
            return null;
        }
        Feature feature = this.feature;
        String string = this.originalScenario.getPath();
        String string2 = this.originalScenario.getMethod();
        String string3 = this.originalScenario.getRequestContentType();
        return Feature.scenarioAssociatedTo$default(feature, string2, string, 202, string3, null, 16, null);
    }

    private final HttpRequest toRequest(JSONObjectValue $this$toRequest) {
        Object object = $this$toRequest.getJsonObject().get(requestPath);
        JSONObjectValue jSONObjectValue = object instanceof JSONObjectValue ? (JSONObjectValue)object : null;
        if (jSONObjectValue == null) {
            throw new ContractException("Expected a json object", requestPath, null, null, false, 28, null);
        }
        JSONObjectValue requestObject = jSONObjectValue;
        String string = this.originalScenario.getPath();
        object = requestObject.getString("method");
        Map<String, String> map = this.getMapOrEmpty(requestObject, "header");
        Value value2 = requestObject.getJsonObject().get("body");
        if (value2 == null) {
            value2 = NullValue.INSTANCE;
        }
        Value value3 = value2;
        return new HttpRequest((String)object, string, map, value3, null, null, null, null, 240, null);
    }

    private final HttpResponse toResponse(JSONObjectValue $this$toResponse) {
        Value value2 = $this$toResponse.getJsonObject().get(responsePath);
        JSONObjectValue jSONObjectValue = value2 instanceof JSONObjectValue ? (JSONObjectValue)value2 : null;
        if (jSONObjectValue == null) {
            throw new ContractException("Expected a json object", responsePath, null, null, false, 28, null);
        }
        JSONObjectValue responseObject = jSONObjectValue;
        Object object = responseObject.findFirstChildByName("statusCode");
        if (object == null || (object = object.toStringLiteral()) == null || (object = StringsKt.toIntOrNull((String)object)) == null) {
            throw new ContractException("Missing or invalid status code", responsePath, null, null, false, 28, null);
        }
        int statusCode = (Integer)object;
        Map<String, String> map = this.getMapOrEmpty(responseObject, "header");
        Value value3 = responseObject.getJsonObject().get("body");
        if (value3 == null) {
            value3 = NullValue.INSTANCE;
        }
        return new HttpResponse(statusCode, map, value3, null, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getMapOrEmpty(JSONObjectValue $this$getMapOrEmpty, String path2) {
        void $this$mapNotNullTo$iv$iv;
        Value value2 = $this$getMapOrEmpty.getJsonObject().get(path2);
        JSONArrayValue jSONArrayValue = value2 instanceof JSONArrayValue ? (JSONArrayValue)value2 : null;
        if (jSONArrayValue == null) {
            return MapsKt.emptyMap();
        }
        JSONArrayValue value3 = jSONArrayValue;
        Iterable $this$mapNotNull$iv = value3.getList();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Value it = (Value)element$iv$iv;
            boolean bl2 = false;
            JSONObjectValue jSONObjectValue = it instanceof JSONObjectValue ? (JSONObjectValue)it : null;
            if (jSONObjectValue == null) {
                pair = null;
            } else {
                JSONObjectValue header = jSONObjectValue;
                Value value4 = header.getJsonObject().get("name");
                if ((value4 instanceof StringValue ? (StringValue)value4 : null) == null) {
                    pair = null;
                } else {
                    StringValue headerName;
                    headerName = headerName;
                    Value value5 = header.getJsonObject().get("value");
                    if ((value5 instanceof StringValue ? (StringValue)value5 : null) == null) {
                        pair = null;
                    } else {
                        StringValue headerValue;
                        headerValue = headerValue;
                        pair = TuplesKt.to((Object)headerName.getString(), (Object)headerValue.getString());
                    }
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final Scenario monitorScenario(Link $this$monitorScenario) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.feature.getScenarios();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Scenario it = (Scenario)element$iv;
                boolean bl = false;
                if (!(it.getHttpRequestPattern().getHttpPathPattern() == null ? false : it.getHttpRequestPattern().matchesPath($this$monitorScenario.toPath(), it.getResolver()) instanceof Result.Success)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/specmatic/test/ResponseMonitor$Companion;", "", "()V", "headerKey", "", "requestPath", "responsePath", "isMonitorLinkPresent", "", "response", "Lio/specmatic/core/HttpResponse;", "specmatic-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMonitorLinkPresent(@NotNull HttpResponse response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)ResponseMonitor.responsePath);
            return response.getHeaders().containsKey(ResponseMonitor.headerKey);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Lio/specmatic/test/ResponseMonitor$Link;", "", "url", "", "rel", "title", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRel", "()Ljava/lang/String;", "getTitle", "getUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toPath", "toString", "specmatic-core"})
    public static final class Link {
        @NotNull
        private final String url;
        @NotNull
        private final String rel;
        @Nullable
        private final String title;

        public Link(@NotNull String url, @NotNull String rel, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)rel, (String)"rel");
            this.url = url;
            this.rel = rel;
            this.title = title;
        }

        public /* synthetic */ Link(String string, String string2, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = null;
            }
            this(string, string2, string3);
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final String getRel() {
            return this.rel;
        }

        @Nullable
        public final String getTitle() {
            return this.title;
        }

        @NotNull
        public final String toPath() {
            return this.url;
        }

        @NotNull
        public final String component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.rel;
        }

        @Nullable
        public final String component3() {
            return this.title;
        }

        @NotNull
        public final Link copy(@NotNull String url, @NotNull String rel, @Nullable String title) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)rel, (String)"rel");
            return new Link(url, rel, title);
        }

        public static /* synthetic */ Link copy$default(Link link, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = link.url;
            }
            if ((n & 2) != 0) {
                string2 = link.rel;
            }
            if ((n & 4) != 0) {
                string3 = link.title;
            }
            return link.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "Link(url=" + this.url + ", rel=" + this.rel + ", title=" + this.title + ")";
        }

        public int hashCode() {
            int result2 = this.url.hashCode();
            result2 = result2 * 31 + this.rel.hashCode();
            result2 = result2 * 31 + (this.title == null ? 0 : this.title.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Link)) {
                return false;
            }
            Link link = (Link)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)link.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.rel, (Object)link.rel)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.title, (Object)link.title);
        }
    }
}

