/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.test.asserts;

import io.ktor.http.HeaderValueWithParametersKt;
import io.specmatic.core.Result;
import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.value.StringValue;
import io.specmatic.core.value.Value;
import io.specmatic.test.asserts.ArrayAssertType;
import io.specmatic.test.asserts.Assert;
import io.specmatic.test.asserts.AssertArray;
import io.specmatic.test.asserts.AssertComparison;
import io.specmatic.test.asserts.AssertComparisonKt;
import io.specmatic.test.asserts.AssertKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ6\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J0\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011H\u0016J:\u0010\u0018\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u00160\u00032\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u00112\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lio/specmatic/test/asserts/AssertArray;", "Lio/specmatic/test/asserts/Assert;", "keys", "", "", "lookupKey", "arrayAssertType", "Lio/specmatic/test/asserts/ArrayAssertType;", "(Ljava/util/List;Ljava/lang/String;Lio/specmatic/test/asserts/ArrayAssertType;)V", "getArrayAssertType", "()Lio/specmatic/test/asserts/ArrayAssertType;", "getKeys", "()Ljava/util/List;", "getLookupKey", "()Ljava/lang/String;", "dynamicAsserts", "currentFactStore", "", "Lio/specmatic/core/value/Value;", "ifNotExists", "Lkotlin/Function1;", "execute", "Lio/specmatic/core/Result;", "actualFactStore", "toResultIfAny", "Companion", "specmatic-core"})
@SourceDebugExtension(value={"SMAP\nAssertArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AssertArray.kt\nio/specmatic/test/asserts/AssertArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n1#2:62\n1549#3:63\n1620#3,3:64\n288#3,2:67\n1549#3:69\n1620#3,3:70\n*S KotlinDebug\n*F\n+ 1 AssertArray.kt\nio/specmatic/test/asserts/AssertArray\n*L\n26#1:63\n26#1:64,3\n37#1:67,2\n46#1:69\n46#1:70,3\n*E\n"})
public final class AssertArray
implements Assert {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> keys;
    @NotNull
    private final String lookupKey;
    @NotNull
    private final ArrayAssertType arrayAssertType;

    public AssertArray(@NotNull List<String> keys, @NotNull String lookupKey, @NotNull ArrayAssertType arrayAssertType) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)lookupKey, (String)"lookupKey");
        Intrinsics.checkNotNullParameter((Object)((Object)arrayAssertType), (String)"arrayAssertType");
        this.keys = keys;
        this.lookupKey = lookupKey;
        this.arrayAssertType = arrayAssertType;
        CharSequence charSequence = this.getKeys().get(CollectionsKt.getLastIndex(this.getKeys()) - 1);
        if (!new Regex("\\[\\*]|\\[\\d+]").matches(charSequence)) {
            boolean bl = false;
            String string = this.getCombinedKey();
            throw new ContractException("Array Asserts can only be used on arrays", string, null, null, false, 28, null);
        }
    }

    @Override
    @NotNull
    public List<String> getKeys() {
        return this.keys;
    }

    @NotNull
    public final String getLookupKey() {
        return this.lookupKey;
    }

    @NotNull
    public final ArrayAssertType getArrayAssertType() {
        return this.arrayAssertType;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public io.specmatic.core.Result execute(@NotNull Map<String, ? extends Value> currentFactStore, @NotNull Map<String, ? extends Value> actualFactStore) {
        void $this$mapTo$iv$iv;
        Object $this$execute_u24lambda_u241;
        Intrinsics.checkNotNullParameter(currentFactStore, (String)"currentFactStore");
        Intrinsics.checkNotNullParameter(actualFactStore, (String)"actualFactStore");
        AssertComparison comparisonAssert = new AssertComparison(this.getKeys(), this.lookupKey, true);
        Object object = this;
        try {
            $this$execute_u24lambda_u241 = object;
            boolean bl = false;
            $this$execute_u24lambda_u241 = Result.constructor-impl((Object)Assert.dynamicAsserts$default(comparisonAssert, currentFactStore, null, 2, null));
        }
        catch (Throwable bl) {
            $this$execute_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$execute_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable e = throwable;
            boolean bl = false;
            return AssertKt.toFailure(e);
        }
        List asserts = (List)object;
        Iterable $this$map$iv = asserts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AssertComparison assertComparison = (AssertComparison)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.execute(currentFactStore, actualFactStore));
        }
        List results2 = (List)destination$iv$iv;
        return this.toResultIfAny(results2, currentFactStore, actualFactStore);
    }

    private final io.specmatic.core.Result toResultIfAny(List<? extends io.specmatic.core.Result> $this$toResultIfAny, Map<String, ? extends Value> currentFactStore, Map<String, ? extends Value> actualFactStore) {
        io.specmatic.core.Result result2;
        Object v2;
        List<String> indexedKeys2;
        Value expectedValue;
        block4: {
            Value value2 = actualFactStore.get(this.lookupKey);
            if (value2 == null) {
                String string = this.lookupKey;
                String string2 = "Could not resolve " + HeaderValueWithParametersKt.quote((String)this.lookupKey) + " in store";
                return new Result.Failure(string2, null, string, null, null, 26, null);
            }
            expectedValue = value2;
            List<String> list = (List<String>)CollectionsKt.firstOrNull((List)Assert.generateDynamicPaths$default(this, this.getKeys(), currentFactStore, null, toResultIfAny.indexedKeys.1.INSTANCE, 4, null));
            if (list == null) {
                list = this.getKeys();
            }
            indexedKeys2 = list;
            Iterable $this$firstOrNull$iv = $this$toResultIfAny;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                io.specmatic.core.Result it = (io.specmatic.core.Result)element$iv;
                boolean bl = false;
                if (!(it instanceof Result.Success)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        if ((result2 = (io.specmatic.core.Result)v2) == null) {
            String string = this.combinedKey(this.withWildCard(indexedKeys2));
            String string3 = "None of the values matched " + HeaderValueWithParametersKt.quote((String)this.lookupKey) + " of value " + expectedValue.displayableValue();
            result2 = new Result.Failure(string3, null, string, null, null, 26, null);
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<AssertArray> dynamicAsserts(@NotNull Map<String, ? extends Value> currentFactStore, @NotNull Function1<? super String, ? extends Value> ifNotExists) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(currentFactStore, (String)"currentFactStore");
        Intrinsics.checkNotNullParameter(ifNotExists, (String)"ifNotExists");
        List<String> keysWithoutAssertingArray = this.getKeys().subList(0, this.getKeys().size() - 2);
        List<String> assertingArrayKeys = this.getKeys().subList(this.getKeys().size() - 2, this.getKeys().size());
        Iterable $this$map$iv = Assert.generateDynamicPaths$default(this, keysWithoutAssertingArray, currentFactStore, null, ifNotExists, 4, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void keys;
            List list = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new AssertArray(CollectionsKt.plus((Collection)((Collection)keys), (Iterable)assertingArrayKeys), this.lookupKey, this.arrayAssertType));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/specmatic/test/asserts/AssertArray$Companion;", "", "()V", "parse", "Lio/specmatic/test/asserts/AssertArray;", "keys", "", "", "value", "Lio/specmatic/core/value/Value;", "specmatic-core"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AssertArray parse(@NotNull List<String> keys, @NotNull Value value2) {
            Intrinsics.checkNotNullParameter(keys, (String)"keys");
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            if (!(value2 instanceof StringValue)) {
                return null;
            }
            MatchResult matchResult = Regex.find$default((Regex)AssertComparisonKt.getASSERT_PATTERN(), (CharSequence)((StringValue)value2).getNativeValue(), (int)0, (int)2, null);
            if (matchResult == null) {
                return null;
            }
            MatchResult match = matchResult;
            return Intrinsics.areEqual((Object)((String)match.getGroupValues().get(1)), (Object)"array_has") ? new AssertArray(keys, (String)match.getGroupValues().get(2), ArrayAssertType.ARRAY_HAS) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

