/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core;

import io.specmatic.core.HttpResponse;
import io.specmatic.core.HttpResponsePattern;
import io.specmatic.core.Resolver;
import io.specmatic.core.Result;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/specmatic/core/BadRequestOrDefault;", "", "badRequestResponses", "", "", "Lio/specmatic/core/HttpResponsePattern;", "defaultResponse", "(Ljava/util/Map;Lio/specmatic/core/HttpResponsePattern;)V", "matches", "Lio/specmatic/core/Result;", "httpResponse", "Lio/specmatic/core/HttpResponse;", "resolver", "Lio/specmatic/core/Resolver;", "supports", "", "httpStatus", "core"})
public final class BadRequestOrDefault {
    @NotNull
    private final Map<Integer, HttpResponsePattern> badRequestResponses;
    @Nullable
    private final HttpResponsePattern defaultResponse;

    public BadRequestOrDefault(@NotNull Map<Integer, HttpResponsePattern> badRequestResponses, @Nullable HttpResponsePattern defaultResponse) {
        Intrinsics.checkNotNullParameter(badRequestResponses, (String)"badRequestResponses");
        this.badRequestResponses = badRequestResponses;
        this.defaultResponse = defaultResponse;
    }

    @NotNull
    public final Result matches(@NotNull HttpResponse httpResponse, @NotNull Resolver resolver) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)httpResponse, (String)"httpResponse");
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Integer n = httpResponse.getStatus();
        if (this.badRequestResponses.containsKey(n)) {
            object = ((HttpResponsePattern)MapsKt.getValue(this.badRequestResponses, (Object)httpResponse.getStatus())).matchesResponse(httpResponse, resolver);
        } else {
            object = this.defaultResponse;
            if (object == null || (object = ((HttpResponsePattern)object).matchesResponse(httpResponse, resolver)) == null || (object = ((Result)object).partialSuccess("The response matched the default response, but the contract should declare a " + httpResponse.getStatus() + " response.")) == null) {
                object = new Result.Failure("Neither is the status code declared nor is there a default response.", null, null, null, null, 30, null);
            }
        }
        return object;
    }

    public final boolean supports(int httpStatus) {
        Integer n = httpStatus;
        return this.badRequestResponses.containsKey(n) || this.defaultResponse != null;
    }
}

