/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.config.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.specmatic.core.Source;
import io.specmatic.core.SourceProvider;
import io.specmatic.core.config.v3.Consumes;
import io.specmatic.core.config.v3.ConsumesDeserializer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001:\u0003$%&BC\b\u0016\u0012\n\b\u0003\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0003\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0010\b\u0003\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0010\b\u0003\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eB5\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u0011J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u0011\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J\u0011\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007H\u00c6\u0003J9\u0010\u001a\u001a\u00020\u00002\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0010\b\u0002\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u0007J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0007J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\bH\u00d6\u0001J\u0006\u0010#\u001a\u00020\rR\u0019\u0010\t\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006'"}, d2={"Lio/specmatic/core/config/v2/ContractConfig;", "", "git", "Lio/specmatic/core/config/v2/ContractConfig$GitContractSource;", "filesystem", "Lio/specmatic/core/config/v2/ContractConfig$FileSystemContractSource;", "provides", "", "", "consumes", "Lio/specmatic/core/config/v3/Consumes;", "(Lio/specmatic/core/config/v2/ContractConfig$GitContractSource;Lio/specmatic/core/config/v2/ContractConfig$FileSystemContractSource;Ljava/util/List;Ljava/util/List;)V", "source", "Lio/specmatic/core/Source;", "(Lio/specmatic/core/Source;)V", "contractSource", "Lio/specmatic/core/config/v2/ContractConfig$ContractSource;", "(Lio/specmatic/core/config/v2/ContractConfig$ContractSource;Ljava/util/List;Ljava/util/List;)V", "getConsumes", "()Ljava/util/List;", "getContractSource", "()Lio/specmatic/core/config/v2/ContractConfig$ContractSource;", "getProvides", "component1", "component2", "component3", "copy", "equals", "", "other", "getFilesystemSource", "getGitSource", "hashCode", "", "toString", "transform", "ContractSource", "FileSystemContractSource", "GitContractSource", "core"})
public final class ContractConfig {
    @JsonIgnore
    @Nullable
    private final ContractSource contractSource;
    @Nullable
    private final List<String> provides;
    @Nullable
    private final List<Consumes> consumes;

    public ContractConfig(@Nullable ContractSource contractSource, @Nullable List<String> provides, @Nullable List<? extends Consumes> consumes) {
        this.contractSource = contractSource;
        this.provides = provides;
        this.consumes = consumes;
    }

    public /* synthetic */ ContractConfig(ContractSource contractSource, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            contractSource = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        if ((n & 4) != 0) {
            list2 = null;
        }
        this(contractSource, list, list2);
    }

    @Nullable
    public final ContractSource getContractSource() {
        return this.contractSource;
    }

    @Nullable
    public final List<String> getProvides() {
        return this.provides;
    }

    @Nullable
    public final List<Consumes> getConsumes() {
        return this.consumes;
    }

    public ContractConfig(@JsonProperty(value="git") @Nullable GitContractSource git, @JsonProperty(value="filesystem") @Nullable FileSystemContractSource filesystem, @JsonProperty(value="provides") @Nullable List<String> provides, @JsonDeserialize(using=ConsumesDeserializer.class) @JsonProperty(value="consumes") @Nullable List<? extends Consumes> consumes) {
        GitContractSource gitContractSource = git;
        this(gitContractSource != null ? (ContractSource)gitContractSource : (ContractSource)filesystem, provides, consumes);
    }

    public /* synthetic */ ContractConfig(GitContractSource gitContractSource, FileSystemContractSource fileSystemContractSource, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gitContractSource = null;
        }
        if ((n & 2) != 0) {
            fileSystemContractSource = null;
        }
        if ((n & 4) != 0) {
            list = null;
        }
        if ((n & 8) != 0) {
            list2 = null;
        }
        this(gitContractSource, fileSystemContractSource, list, list2);
    }

    public ContractConfig(@NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this(source.getProvider() == SourceProvider.git ? (ContractSource)new GitContractSource(source) : (source.getDirectory() != null ? (ContractSource)new FileSystemContractSource(source) : null), source.getTest(), source.getStub());
    }

    @JsonProperty(value="git")
    @Nullable
    public final GitContractSource getGitSource() {
        ContractSource contractSource = this.contractSource;
        return contractSource instanceof GitContractSource ? (GitContractSource)contractSource : null;
    }

    @JsonProperty(value="filesystem")
    @Nullable
    public final FileSystemContractSource getFilesystemSource() {
        ContractSource contractSource = this.contractSource;
        return contractSource instanceof FileSystemContractSource ? (FileSystemContractSource)contractSource : null;
    }

    @NotNull
    public final Source transform() {
        Object object = this.contractSource;
        if (object == null || (object = object.transform(this.provides, this.consumes)) == null) {
            object = new Source(null, null, null, this.provides, this.consumes, null, 39, null);
        }
        return object;
    }

    @Nullable
    public final ContractSource component1() {
        return this.contractSource;
    }

    @Nullable
    public final List<String> component2() {
        return this.provides;
    }

    @Nullable
    public final List<Consumes> component3() {
        return this.consumes;
    }

    @NotNull
    public final ContractConfig copy(@Nullable ContractSource contractSource, @Nullable List<String> provides, @Nullable List<? extends Consumes> consumes) {
        return new ContractConfig(contractSource, provides, consumes);
    }

    public static /* synthetic */ ContractConfig copy$default(ContractConfig contractConfig, ContractSource contractSource, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            contractSource = contractConfig.contractSource;
        }
        if ((n & 2) != 0) {
            list = contractConfig.provides;
        }
        if ((n & 4) != 0) {
            list2 = contractConfig.consumes;
        }
        return contractConfig.copy(contractSource, list, list2);
    }

    @NotNull
    public String toString() {
        return "ContractConfig(contractSource=" + this.contractSource + ", provides=" + this.provides + ", consumes=" + this.consumes + ")";
    }

    public int hashCode() {
        int result2 = this.contractSource == null ? 0 : this.contractSource.hashCode();
        result2 = result2 * 31 + (this.provides == null ? 0 : ((Object)this.provides).hashCode());
        result2 = result2 * 31 + (this.consumes == null ? 0 : ((Object)this.consumes).hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ContractConfig)) {
            return false;
        }
        ContractConfig contractConfig = (ContractConfig)other;
        if (!Intrinsics.areEqual((Object)this.contractSource, (Object)contractConfig.contractSource)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.provides, contractConfig.provides)) {
            return false;
        }
        return Intrinsics.areEqual(this.consumes, contractConfig.consumes);
    }

    public ContractConfig() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J(\u0010\u0002\u001a\u00020\u00032\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005H&\u00a8\u0006\t"}, d2={"Lio/specmatic/core/config/v2/ContractConfig$ContractSource;", "", "transform", "Lio/specmatic/core/Source;", "provides", "", "", "consumes", "Lio/specmatic/core/config/v3/Consumes;", "core"})
    public static interface ContractSource {
        @NotNull
        public Source transform(@Nullable List<String> var1, @Nullable List<? extends Consumes> var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\n\u001a\u00020\u0006H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0006H\u00d6\u0001J(\u0010\u0013\u001a\u00020\u00032\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0015H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lio/specmatic/core/config/v2/ContractConfig$FileSystemContractSource;", "Lio/specmatic/core/config/v2/ContractConfig$ContractSource;", "source", "Lio/specmatic/core/Source;", "(Lio/specmatic/core/Source;)V", "directory", "", "(Ljava/lang/String;)V", "getDirectory", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "transform", "provides", "", "consumes", "Lio/specmatic/core/config/v3/Consumes;", "core"})
    public static final class FileSystemContractSource
    implements ContractSource {
        @NotNull
        private final String directory;

        public FileSystemContractSource(@NotNull String directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            this.directory = directory;
        }

        public /* synthetic */ FileSystemContractSource(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = ".";
            }
            this(string);
        }

        @NotNull
        public final String getDirectory() {
            return this.directory;
        }

        public FileSystemContractSource(@NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            String string = source.getDirectory();
            if (string == null) {
                string = ".";
            }
            this(string);
        }

        @Override
        @NotNull
        public Source transform(@Nullable List<String> provides, @Nullable List<? extends Consumes> consumes) {
            SourceProvider sourceProvider = SourceProvider.filesystem;
            String string = this.directory;
            List list = consumes;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            List list2 = list;
            return new Source(sourceProvider, null, null, provides, list2, string, 6, null);
        }

        @NotNull
        public final String component1() {
            return this.directory;
        }

        @NotNull
        public final FileSystemContractSource copy(@NotNull String directory) {
            Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
            return new FileSystemContractSource(directory);
        }

        public static /* synthetic */ FileSystemContractSource copy$default(FileSystemContractSource fileSystemContractSource, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = fileSystemContractSource.directory;
            }
            return fileSystemContractSource.copy(string);
        }

        @NotNull
        public String toString() {
            return "FileSystemContractSource(directory=" + this.directory + ")";
        }

        public int hashCode() {
            return this.directory.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileSystemContractSource)) {
                return false;
            }
            FileSystemContractSource fileSystemContractSource = (FileSystemContractSource)other;
            return Intrinsics.areEqual((Object)this.directory, (Object)fileSystemContractSource.directory);
        }

        public FileSystemContractSource() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J!\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J(\u0010\u0016\u001a\u00020\u00032\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0018H\u0016R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u001b"}, d2={"Lio/specmatic/core/config/v2/ContractConfig$GitContractSource;", "Lio/specmatic/core/config/v2/ContractConfig$ContractSource;", "source", "Lio/specmatic/core/Source;", "(Lio/specmatic/core/Source;)V", "url", "", "branch", "(Ljava/lang/String;Ljava/lang/String;)V", "getBranch", "()Ljava/lang/String;", "getUrl", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "transform", "provides", "", "consumes", "Lio/specmatic/core/config/v3/Consumes;", "core"})
    public static final class GitContractSource
    implements ContractSource {
        @Nullable
        private final String url;
        @Nullable
        private final String branch;

        public GitContractSource(@Nullable String url, @Nullable String branch) {
            this.url = url;
            this.branch = branch;
        }

        public /* synthetic */ GitContractSource(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = null;
            }
            if ((n & 2) != 0) {
                string2 = null;
            }
            this(string, string2);
        }

        @Nullable
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getBranch() {
            return this.branch;
        }

        public GitContractSource(@NotNull Source source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this(source.getRepository(), source.getBranch());
        }

        @Override
        @NotNull
        public Source transform(@Nullable List<String> provides, @Nullable List<? extends Consumes> consumes) {
            List list = consumes;
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            return new Source(SourceProvider.git, this.url, this.branch, provides, list, null, 32, null);
        }

        @Nullable
        public final String component1() {
            return this.url;
        }

        @Nullable
        public final String component2() {
            return this.branch;
        }

        @NotNull
        public final GitContractSource copy(@Nullable String url, @Nullable String branch) {
            return new GitContractSource(url, branch);
        }

        public static /* synthetic */ GitContractSource copy$default(GitContractSource gitContractSource, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = gitContractSource.url;
            }
            if ((n & 2) != 0) {
                string2 = gitContractSource.branch;
            }
            return gitContractSource.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "GitContractSource(url=" + this.url + ", branch=" + this.branch + ")";
        }

        public int hashCode() {
            int result2 = this.url == null ? 0 : this.url.hashCode();
            result2 = result2 * 31 + (this.branch == null ? 0 : this.branch.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GitContractSource)) {
                return false;
            }
            GitContractSource gitContractSource = (GitContractSource)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)gitContractSource.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.branch, (Object)gitContractSource.branch);
        }

        public GitContractSource() {
            this(null, null, 3, null);
        }
    }
}

