/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.examples.module;

import io.specmatic.conversions.ExampleFromFile;
import io.specmatic.core.Feature;
import io.specmatic.core.FeatureKt;
import io.specmatic.core.Result;
import io.specmatic.core.Results;
import io.specmatic.core.examples.module.ExampleValidationModule;
import io.specmatic.core.examples.server.InteractiveExamplesMismatchMessages;
import io.specmatic.core.examples.server.ScenarioFilter;
import io.specmatic.core.examples.server.SchemaExample;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.pattern.HasFailure;
import io.specmatic.core.value.NullValue;
import io.specmatic.mock.ScenarioStub;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fJ4\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J@\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u001a\b\u0002\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\u00150\u00122\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0016\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u001a"}, d2={"Lio/specmatic/core/examples/module/ExampleValidationModule;", "", "()V", "validateExample", "Lio/specmatic/core/Result;", "feature", "Lio/specmatic/core/Feature;", "example", "Lio/specmatic/conversions/ExampleFromFile;", "schemaExample", "Lio/specmatic/core/examples/server/SchemaExample;", "Lio/specmatic/core/Results;", "scenarioStub", "Lio/specmatic/mock/ScenarioStub;", "exampleFile", "Ljava/io/File;", "contractFile", "validateExamples", "", "", "examples", "", "scenarioFilter", "Lio/specmatic/core/examples/server/ScenarioFilter;", "validateInlineExamples", "validateSchemaExample", "core"})
@SourceDebugExtension(value={"SMAP\nExampleValidationModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExampleValidationModule.kt\nio/specmatic/core/examples/module/ExampleValidationModule\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n453#2:102\n403#2:103\n1238#3,2:104\n1603#3,9:106\n1855#3:115\n1856#3:117\n1612#3:118\n1241#3:119\n1179#3,2:120\n1253#3,4:122\n1#4:116\n*S KotlinDebug\n*F\n+ 1 ExampleValidationModule.kt\nio/specmatic/core/examples/module/ExampleValidationModule\n*L\n25#1:102\n25#1:103\n25#1:104,2\n28#1:106,9\n28#1:115\n28#1:117\n28#1:118\n25#1:119\n46#1:120,2\n46#1:122,4\n28#1:116\n*E\n"})
public final class ExampleValidationModule {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Result> validateInlineExamples(@NotNull Feature feature, @NotNull Map<String, ? extends List<ScenarioStub>> examples, @NotNull ScenarioFilter scenarioFilter) {
        void $this$mapValuesTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter(examples, (String)"examples");
        Intrinsics.checkNotNullParameter((Object)scenarioFilter, (String)"scenarioFilter");
        Feature updatedFeature = scenarioFilter.filter(feature);
        Map<String, ? extends List<ScenarioStub>> $this$mapValues$iv = examples;
        boolean $i$f$mapValues = false;
        Map<String, ? extends List<ScenarioStub>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String name = (String)entry2.getKey();
            List exampleList = (List)entry2.getValue();
            LoggingKt.getLogger().debug("Validating " + name);
            Iterable $this$mapNotNull$iv = exampleList;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Result it$iv$iv2;
                Object element$iv$iv$iv2;
                Object element$iv$iv = element$iv$iv$iv2 = iterator.next();
                boolean bl3 = false;
                ScenarioStub example = (ScenarioStub)element$iv$iv;
                boolean bl4 = false;
                Results results2 = this.validateExample(updatedFeature, example);
                if ((!results2.hasResults() ? null : results2.toResultIfAny()) == null) continue;
                it$iv$iv2 = it$iv$iv2;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv2);
            }
            List it = (List)destination$iv$iv2;
            boolean bl6 = false;
            Result result2 = Result.Companion.fromResults(it);
            map3.put(k, result2);
        }
        Map results3 = destination$iv$iv;
        return results3;
    }

    public static /* synthetic */ Map validateInlineExamples$default(ExampleValidationModule exampleValidationModule, Feature feature, Map map, ScenarioFilter scenarioFilter, int n, Object object) {
        if ((n & 2) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 4) != 0) {
            scenarioFilter = new ScenarioFilter(null, null, null, 7, null);
        }
        return exampleValidationModule.validateInlineExamples(feature, map, scenarioFilter);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Result> validateExamples(@NotNull Feature feature, @NotNull List<? extends File> examples, @NotNull ScenarioFilter scenarioFilter) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter(examples, (String)"examples");
        Intrinsics.checkNotNullParameter((Object)scenarioFilter, (String)"scenarioFilter");
        Feature updatedFeature = scenarioFilter.filter(feature);
        Iterable $this$associate$iv = examples;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            File exampleFile = (File)element$iv$iv;
            boolean bl = false;
            LoggingKt.getLogger().debug("Validating " + exampleFile.getName());
            Pair pair = TuplesKt.to((Object)exampleFile.getCanonicalPath(), (Object)this.validateExample(updatedFeature, exampleFile));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map results2 = destination$iv$iv;
        return results2;
    }

    public static /* synthetic */ Map validateExamples$default(ExampleValidationModule exampleValidationModule, Feature feature, List list, ScenarioFilter scenarioFilter, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            scenarioFilter = new ScenarioFilter(null, null, null, 7, null);
        }
        return exampleValidationModule.validateExamples(feature, list, scenarioFilter);
    }

    @NotNull
    public final Result validateExample(@NotNull File contractFile, @NotNull File exampleFile) {
        Intrinsics.checkNotNullParameter((Object)contractFile, (String)"contractFile");
        Intrinsics.checkNotNullParameter((Object)exampleFile, (String)"exampleFile");
        Feature feature = FeatureKt.parseContractFileToFeature$default(contractFile, null, null, null, null, null, null, null, null, false, 1022, null);
        return this.validateExample(feature, exampleFile);
    }

    @NotNull
    public final Results validateExample(@NotNull Feature feature, @NotNull ScenarioStub scenarioStub) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)scenarioStub, (String)"scenarioStub");
        return feature.matchResultFlagBased(scenarioStub, InteractiveExamplesMismatchMessages.INSTANCE);
    }

    private final Result validateExample(Feature feature, ExampleFromFile example) {
        return feature.matchResultFlagBased(example.getRequest(), example.getResponse(), InteractiveExamplesMismatchMessages.INSTANCE, example.isPartial()).toResultIfAnyWithCauses();
    }

    private final Result validateExample(Feature feature, SchemaExample schemaExample) {
        if (schemaExample.getValue() instanceof NullValue) {
            return new Result.Success(null, null, 3, null);
        }
        return feature.matchResultSchemaFlagBased(schemaExample.getDiscriminatorBasedOn(), schemaExample.getSchemaBasedOn(), schemaExample.getValue(), InteractiveExamplesMismatchMessages.INSTANCE, schemaExample.getFile().getName());
    }

    @NotNull
    public final Result validateExample(@NotNull Feature feature, @NotNull File exampleFile) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)exampleFile, (String)"exampleFile");
        return (Result)ExampleFromFile.Companion.fromFile(exampleFile).realise((Function2)new Function2<ExampleFromFile, String, Result>(this, feature){
            final /* synthetic */ ExampleValidationModule this$0;
            final /* synthetic */ Feature $feature;
            {
                this.this$0 = $receiver;
                this.$feature = $feature;
                super(2);
            }

            @NotNull
            public final Result invoke(@NotNull ExampleFromFile example, @Nullable String string) {
                Intrinsics.checkNotNullParameter((Object)example, (String)"example");
                return ExampleValidationModule.access$validateExample(this.this$0, this.$feature, example);
            }
        }, (Function1)new Function1<HasFailure<ExampleFromFile>, Result>(this, feature, exampleFile){
            final /* synthetic */ ExampleValidationModule this$0;
            final /* synthetic */ Feature $feature;
            final /* synthetic */ File $exampleFile;
            {
                this.this$0 = $receiver;
                this.$feature = $feature;
                this.$exampleFile = $exampleFile;
                super(1);
            }

            @NotNull
            public final Result invoke(@NotNull HasFailure<ExampleFromFile> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return this.this$0.validateSchemaExample(this.$feature, this.$exampleFile);
            }
        }, validateExample.3.INSTANCE);
    }

    @NotNull
    public final Result validateSchemaExample(@NotNull Feature feature, @NotNull File exampleFile) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)exampleFile, (String)"exampleFile");
        return (Result)SchemaExample.Companion.fromFile(exampleFile).realise((Function2)new Function2<SchemaExample, String, Result>(this, feature){
            final /* synthetic */ ExampleValidationModule this$0;
            final /* synthetic */ Feature $feature;
            {
                this.this$0 = $receiver;
                this.$feature = $feature;
                super(2);
            }

            @NotNull
            public final Result invoke(@NotNull SchemaExample example, @Nullable String string) {
                Intrinsics.checkNotNullParameter((Object)example, (String)"example");
                return ExampleValidationModule.access$validateExample(this.this$0, this.$feature, example);
            }
        }, validateSchemaExample.2.INSTANCE, validateSchemaExample.3.INSTANCE);
    }

    public static final /* synthetic */ Result access$validateExample(ExampleValidationModule $this, Feature feature, ExampleFromFile example) {
        return $this.validateExample(feature, example);
    }

    public static final /* synthetic */ Result access$validateExample(ExampleValidationModule $this, Feature feature, SchemaExample schemaExample) {
        return $this.validateExample(feature, schemaExample);
    }
}

