/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.log;

import io.specmatic.core.log.CompositePrinter;
import io.specmatic.core.log.LogMessage;
import io.specmatic.core.log.LogStrategy;
import io.specmatic.core.log.LogTail;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.log.NonVerbose;
import io.specmatic.core.log.StringLog;
import io.specmatic.core.log.ThreadSafeLog;
import io.specmatic.core.log.Verbose;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000b\u001a\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019\u001a\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u000b\u001a\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b\u001a\u0016\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019\u001a\u0014\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\f0!\u001a\u0006\u0010\"\u001a\u00020\u0012\u001a\u0006\u0010#\u001a\u00020\f\u001a'\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0006\u0010&\u001a\u00020\u00122\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H%0!\u00a2\u0006\u0002\u0010'\"\u0017\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0002\u0010\u0003\u001a\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u001a\u0004\b\b\u0010\u0005\"\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"DebugLogger", "Lio/specmatic/core/log/ThreadSafeLog;", "getDebugLogger$annotations", "()V", "getDebugLogger", "()Lio/specmatic/core/log/ThreadSafeLog;", "InfoLogger", "getInfoLogger$annotations", "getInfoLogger", "dontPrintToConsole", "Lkotlin/Function1;", "Lio/specmatic/core/log/LogMessage;", "", "getDontPrintToConsole", "()Lkotlin/jvm/functions/Function1;", "ignoreLog", "getIgnoreLog", "logger", "Lio/specmatic/core/log/LogStrategy;", "getLogger", "()Lio/specmatic/core/log/LogStrategy;", "setLogger", "(Lio/specmatic/core/log/LogStrategy;)V", "consoleDebug", "event", "", "e", "", "msg", "consoleLog", "logException", "", "fn", "Lkotlin/Function0;", "newLogger", "resetLogger", "withLogger", "T", "logStrategy", "(Lio/specmatic/core/log/LogStrategy;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "core"})
public final class LoggingKt {
    @NotNull
    private static LogStrategy logger = LoggingKt.newLogger();
    @NotNull
    private static final ThreadSafeLog DebugLogger = new ThreadSafeLog(new Verbose(new CompositePrinter(null, 1, null), false, 2, null));
    @NotNull
    private static final ThreadSafeLog InfoLogger = new ThreadSafeLog(new NonVerbose(new CompositePrinter(null, 1, null), false, 2, null));
    @NotNull
    private static final Function1<LogMessage, Unit> dontPrintToConsole = dontPrintToConsole.1.INSTANCE;
    @NotNull
    private static final Function1<LogMessage, Unit> ignoreLog = ignoreLog.1.INSTANCE;

    @NotNull
    public static final LogStrategy getLogger() {
        return logger;
    }

    public static final void setLogger(@NotNull LogStrategy logStrategy) {
        Intrinsics.checkNotNullParameter((Object)logStrategy, (String)"<set-?>");
        logger = logStrategy;
    }

    @NotNull
    public static final LogStrategy newLogger() {
        return new ThreadSafeLog(new NonVerbose(new CompositePrinter(null, 1, null), false, 2, null));
    }

    public static final void resetLogger() {
        logger = new NonVerbose(new CompositePrinter(null, 1, null), false, 2, null);
    }

    @NotNull
    public static final ThreadSafeLog getDebugLogger() {
        return DebugLogger;
    }

    public static /* synthetic */ void getDebugLogger$annotations() {
    }

    @NotNull
    public static final ThreadSafeLog getInfoLogger() {
        return InfoLogger;
    }

    public static /* synthetic */ void getInfoLogger$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T withLogger(@NotNull LogStrategy logStrategy, @NotNull Function0<? extends T> fn) {
        Intrinsics.checkNotNullParameter((Object)logStrategy, (String)"logStrategy");
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        LogStrategy oldLogger = logger;
        logger = logStrategy;
        try {
            Object object = fn.invoke();
            return (T)object;
        }
        finally {
            logger = oldLogger;
        }
    }

    public static final int logException(@NotNull Function0<Unit> fn) {
        int n;
        Intrinsics.checkNotNullParameter(fn, (String)"fn");
        try {
            fn.invoke();
            n = 0;
        }
        catch (Throwable e) {
            LogStrategy.DefaultImpls.log$default(logger, e, null, 2, null);
            n = 1;
        }
        return n;
    }

    public static final void consoleLog(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LoggingKt.consoleLog(new StringLog(event));
    }

    public static final void consoleLog(@NotNull LogMessage event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LogTail.INSTANCE.append(event);
        logger.log(event);
    }

    public static final void consoleLog(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LogTail.INSTANCE.append(LogStrategy.DefaultImpls.ofTheException$default(logger, e, null, 2, null));
        LogStrategy.DefaultImpls.log$default(logger, e, null, 2, null);
    }

    public static final void consoleLog(@NotNull Throwable e, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        LogTail.INSTANCE.append(logger.ofTheException(e, msg));
        logger.log(e, msg);
    }

    public static final void consoleDebug(@NotNull String event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LoggingKt.consoleDebug(new StringLog(event));
    }

    public static final void consoleDebug(@NotNull LogMessage event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LogTail.INSTANCE.append(event);
        logger.debug(event);
    }

    public static final void consoleDebug(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        LogTail.INSTANCE.append(LogStrategy.DefaultImpls.ofTheException$default(logger, e, null, 2, null));
        LogStrategy.DefaultImpls.debug$default(logger, e, null, 2, null);
    }

    public static final void consoleDebug(@NotNull Throwable e, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        LogTail.INSTANCE.append(logger.ofTheException(e, msg));
        logger.debug(e, msg);
    }

    @NotNull
    public static final Function1<LogMessage, Unit> getDontPrintToConsole() {
        return dontPrintToConsole;
    }

    @NotNull
    public static final Function1<LogMessage, Unit> getIgnoreLog() {
        return ignoreLog;
    }
}

