/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.pattern;

import io.specmatic.core.pattern.ContractException;
import io.specmatic.core.value.StringValue;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lio/specmatic/core/pattern/ISO8601;", "", "()V", "Companion", "core"})
public final class ISO8601 {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/specmatic/core/pattern/ISO8601$Companion;", "", "()V", "currentTime", "", "getCurrentTime", "()Ljava/lang/String;", "validatedStringValue", "Lio/specmatic/core/value/StringValue;", "time", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StringValue validatedStringValue(@NotNull String time) {
            StringValue stringValue;
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            try {
                LocalTime.parse(time, DateTimeFormatter.ISO_TIME);
                stringValue = new StringValue(time);
            }
            catch (Exception e) {
                throw new ContractException("Error while parsing " + time + " as per ISO 8601: " + e.getMessage(), null, null, null, false, 30, null);
            }
            return stringValue;
        }

        @NotNull
        public final String getCurrentTime() {
            String string = LocalTime.now().format(DateTimeFormatter.ISO_TIME);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

