/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.git.SystemGit;
import io.specmatic.core.utilities.ContractPathData;
import io.specmatic.core.utilities.ContractSource;
import io.specmatic.core.utilities.ContractSourceEntry;
import io.specmatic.core.utilities.ContractsSelectorPredicate;
import io.specmatic.core.utilities.GitSource;
import io.specmatic.core.utilities.Utilities;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\bH\u00c6\u0003J5\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J&\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010%\u001a\u00020\bH\u0016J\u0010\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0*0\u00042\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\"0\u0004H\u0016J\t\u0010,\u001a\u00020\bH\u00d6\u0001R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006-"}, d2={"Lio/specmatic/core/utilities/GitMonoRepo;", "Lio/specmatic/core/utilities/ContractSource;", "Lio/specmatic/core/utilities/GitSource;", "testContracts", "", "Lio/specmatic/core/utilities/ContractSourceEntry;", "stubContracts", "type", "", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "getType", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "equals", "", "other", "", "getLatest", "", "sourceGit", "Lio/specmatic/core/git/SystemGit;", "hashCode", "", "install", "loadContracts", "Lio/specmatic/core/utilities/ContractPathData;", "selector", "Lio/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "pathDescriptor", "path", "pushUpdates", "stubDirectoryToContractPath", "Lkotlin/Pair;", "contractPathDataList", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nGitMonoRepo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitMonoRepo.kt\nio/specmatic/core/utilities/GitMonoRepo\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1549#2:59\n1620#2,3:60\n1603#2,9:63\n1855#2:72\n288#2,2:73\n1856#2:76\n1612#2:77\n1#3:75\n*S KotlinDebug\n*F\n+ 1 GitMonoRepo.kt\nio/specmatic/core/utilities/GitMonoRepo\n*L\n38#1:59\n38#1:60,3\n50#1:63,9\n50#1:72\n51#1:73,2\n50#1:76\n50#1:77\n50#1:75\n*E\n"})
public final class GitMonoRepo
implements ContractSource,
GitSource {
    @NotNull
    private final List<ContractSourceEntry> testContracts;
    @NotNull
    private final List<ContractSourceEntry> stubContracts;
    @Nullable
    private final String type;

    public GitMonoRepo(@NotNull List<ContractSourceEntry> testContracts, @NotNull List<ContractSourceEntry> stubContracts, @Nullable String type) {
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.type = type;
    }

    @Override
    @NotNull
    public List<ContractSourceEntry> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<ContractSourceEntry> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return path2;
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        System.out.println((Object)"Checking list of mono repo paths...");
        List contracts = CollectionsKt.plus((Collection)this.getTestContracts(), (Iterable)this.getStubContracts());
        for (ContractSourceEntry contract : contracts) {
            String existenceMessage = new File(contract.getPath()).exists() ? contract.getPath() + " exists" : contract.getPath() + " NOT FOUND!";
            System.out.println((Object)existenceMessage);
        }
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        return FilesKt.resolve((File)workingDirectory, (String)Utilities.gitRootDir());
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        File monoRepoBaseDir = new File(new SystemGit(null, null, null, 7, null).gitRoot());
        File configFileLocation = new File(configFilePath).getAbsoluteFile().getParentFile();
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContractSourceEntry contractSourceEntry = (ContractSourceEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = monoRepoBaseDir.getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCanonicalPath(...)");
            Intrinsics.checkNotNull((Object)configFileLocation);
            String string2 = FilesKt.resolve((File)configFileLocation, (String)it.getPath()).getCanonicalPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getCanonicalPath(...)");
            collection.add(new ContractPathData(string, string2, this.getType(), null, null, it.getPath(), it.getPort(), 24, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<String, String>> stubDirectoryToContractPath(@NotNull List<ContractPathData> contractPathDataList) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractPathDataList, (String)"contractPathDataList");
        Iterable $this$mapNotNull$iv = this.getStubContracts();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            String string;
            Object v1;
            ContractSourceEntry contractSourceEntry;
            block5: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                contractSourceEntry = (ContractSourceEntry)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$firstOrNull$iv = contractPathDataList;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ContractPathData it = (ContractPathData)element$iv;
                    boolean bl3 = false;
                    String string2 = it.getSpecificationPath();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (!Intrinsics.areEqual((Object)string2, (Object)contractSourceEntry.getPath())) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            ContractPathData contractPathData = v1;
            if (contractPathData == null || (string = contractPathData.getBaseDir()) == null) {
                pair = null;
            } else {
                String directory = string;
                pair = TuplesKt.to((Object)directory, (Object)contractSourceEntry.getPath());
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ContractSourceEntry> component1() {
        return this.testContracts;
    }

    @NotNull
    public final List<ContractSourceEntry> component2() {
        return this.stubContracts;
    }

    @Nullable
    public final String component3() {
        return this.type;
    }

    @NotNull
    public final GitMonoRepo copy(@NotNull List<ContractSourceEntry> testContracts, @NotNull List<ContractSourceEntry> stubContracts, @Nullable String type) {
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new GitMonoRepo(testContracts, stubContracts, type);
    }

    public static /* synthetic */ GitMonoRepo copy$default(GitMonoRepo gitMonoRepo, List list, List list2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = gitMonoRepo.testContracts;
        }
        if ((n & 2) != 0) {
            list2 = gitMonoRepo.stubContracts;
        }
        if ((n & 4) != 0) {
            string = gitMonoRepo.type;
        }
        return gitMonoRepo.copy(list, list2, string);
    }

    @NotNull
    public String toString() {
        return "GitMonoRepo(testContracts=" + this.testContracts + ", stubContracts=" + this.stubContracts + ", type=" + this.type + ")";
    }

    public int hashCode() {
        int result2 = ((Object)this.testContracts).hashCode();
        result2 = result2 * 31 + ((Object)this.stubContracts).hashCode();
        result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitMonoRepo)) {
            return false;
        }
        GitMonoRepo gitMonoRepo = (GitMonoRepo)other;
        if (!Intrinsics.areEqual(this.testContracts, gitMonoRepo.testContracts)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.stubContracts, gitMonoRepo.stubContracts)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.type, (Object)gitMonoRepo.type);
    }
}

