/*
 * Decompiled with CFR 0.152.
 */
package io.specmatic.core.utilities;

import io.specmatic.core.git.SystemGit;
import io.specmatic.core.log.LoggingKt;
import io.specmatic.core.utilities.ContractPathData;
import io.specmatic.core.utilities.ContractSource;
import io.specmatic.core.utilities.ContractSourceEntry;
import io.specmatic.core.utilities.ContractsSelectorPredicate;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00052\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010&\u001a\u00020\u0003H\u0016J\u0010\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H\u0016J\u0010\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030+0\u00052\f\u0010,\u001a\b\u0012\u0004\u0012\u00020#0\u0005H\u0016J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\n\u00a8\u0006."}, d2={"Lio/specmatic/core/utilities/LocalFileSystemSource;", "Lio/specmatic/core/utilities/ContractSource;", "directory", "", "testContracts", "", "Lio/specmatic/core/utilities/ContractSourceEntry;", "stubContracts", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getDirectory", "()Ljava/lang/String;", "getStubContracts", "()Ljava/util/List;", "getTestContracts", "type", "getType", "component1", "component2", "component3", "copy", "directoryRelativeTo", "Ljava/io/File;", "workingDirectory", "equals", "", "other", "", "getLatest", "", "sourceGit", "Lio/specmatic/core/git/SystemGit;", "hashCode", "", "install", "loadContracts", "Lio/specmatic/core/utilities/ContractPathData;", "selector", "Lio/specmatic/core/utilities/ContractsSelectorPredicate;", "configFilePath", "pathDescriptor", "path", "pushUpdates", "stubDirectoryToContractPath", "Lkotlin/Pair;", "contractPathDataList", "toString", "core"})
@SourceDebugExtension(value={"SMAP\nLocalFileSystemSource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalFileSystemSource.kt\nio/specmatic/core/utilities/LocalFileSystemSource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1549#2:59\n1620#2,3:60\n1549#2:63\n1620#2,3:64\n*S KotlinDebug\n*F\n+ 1 LocalFileSystemSource.kt\nio/specmatic/core/utilities/LocalFileSystemSource\n*L\n40#1:59\n40#1:60,3\n54#1:63\n54#1:64,3\n*E\n"})
public final class LocalFileSystemSource
implements ContractSource {
    @NotNull
    private final String directory;
    @NotNull
    private final List<ContractSourceEntry> testContracts;
    @NotNull
    private final List<ContractSourceEntry> stubContracts;
    @NotNull
    private final String type;

    public LocalFileSystemSource(@NotNull String directory, @NotNull List<ContractSourceEntry> testContracts, @NotNull List<ContractSourceEntry> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        this.directory = directory;
        this.testContracts = testContracts;
        this.stubContracts = stubContracts;
        this.type = "filesystem";
    }

    public /* synthetic */ LocalFileSystemSource(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".";
        }
        this(string, list, list2);
    }

    @NotNull
    public final String getDirectory() {
        return this.directory;
    }

    @Override
    @NotNull
    public List<ContractSourceEntry> getTestContracts() {
        return this.testContracts;
    }

    @Override
    @NotNull
    public List<ContractSourceEntry> getStubContracts() {
        return this.stubContracts;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String pathDescriptor(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return path2;
    }

    @Override
    public void install(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        LoggingKt.getLogger().log("No installation needed as this source is a directory on the local file system");
    }

    @Override
    @NotNull
    public File directoryRelativeTo(@NotNull File workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        if (new File(this.directory).isAbsolute()) {
            return new File(this.directory);
        }
        return FilesKt.resolve((File)workingDirectory, (String)this.directory);
    }

    @Override
    public void getLatest(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        LoggingKt.getLogger().log("No need to get latest as this source is a directory on the local file system");
    }

    @Override
    public void pushUpdates(@NotNull SystemGit sourceGit) {
        Intrinsics.checkNotNullParameter((Object)sourceGit, (String)"sourceGit");
        LoggingKt.getLogger().log("No need to push updates as this source is a directory on the local file system");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ContractPathData> loadContracts(@NotNull ContractsSelectorPredicate selector, @NotNull String workingDirectory, @NotNull String configFilePath) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Iterable $this$map$iv = selector.select(this);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ContractSourceEntry contractSourceEntry = (ContractSourceEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File resolvedPath = FilesKt.resolve((File)new File(this.directory), (String)it.getPath());
            String string = resolvedPath.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            collection.add(new ContractPathData(this.directory, string, this.getType(), null, null, resolvedPath.getCanonicalPath(), it.getPort(), 24, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<String, String>> stubDirectoryToContractPath(@NotNull List<ContractPathData> contractPathDataList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(contractPathDataList, (String)"contractPathDataList");
        Iterable $this$map$iv = this.getStubContracts();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void contractSourceEntry;
            ContractSourceEntry contractSourceEntry2 = (ContractSourceEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)this.directory, (Object)contractSourceEntry.getPath()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String component1() {
        return this.directory;
    }

    @NotNull
    public final List<ContractSourceEntry> component2() {
        return this.testContracts;
    }

    @NotNull
    public final List<ContractSourceEntry> component3() {
        return this.stubContracts;
    }

    @NotNull
    public final LocalFileSystemSource copy(@NotNull String directory, @NotNull List<ContractSourceEntry> testContracts, @NotNull List<ContractSourceEntry> stubContracts) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter(testContracts, (String)"testContracts");
        Intrinsics.checkNotNullParameter(stubContracts, (String)"stubContracts");
        return new LocalFileSystemSource(directory, testContracts, stubContracts);
    }

    public static /* synthetic */ LocalFileSystemSource copy$default(LocalFileSystemSource localFileSystemSource, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = localFileSystemSource.directory;
        }
        if ((n & 2) != 0) {
            list = localFileSystemSource.testContracts;
        }
        if ((n & 4) != 0) {
            list2 = localFileSystemSource.stubContracts;
        }
        return localFileSystemSource.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "LocalFileSystemSource(directory=" + this.directory + ", testContracts=" + this.testContracts + ", stubContracts=" + this.stubContracts + ")";
    }

    public int hashCode() {
        int result2 = this.directory.hashCode();
        result2 = result2 * 31 + ((Object)this.testContracts).hashCode();
        result2 = result2 * 31 + ((Object)this.stubContracts).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LocalFileSystemSource)) {
            return false;
        }
        LocalFileSystemSource localFileSystemSource = (LocalFileSystemSource)other;
        if (!Intrinsics.areEqual((Object)this.directory, (Object)localFileSystemSource.directory)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.testContracts, localFileSystemSource.testContracts)) {
            return false;
        }
        return Intrinsics.areEqual(this.stubContracts, localFileSystemSource.stubContracts);
    }
}

