/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.grpc;

import io.specto.hoverfly.junit.core.HoverflyConfig;
import io.specto.hoverfly.junit.core.config.HoverflyConfiguration;
import io.specto.hoverfly.junit.core.config.LogLevel;
import io.specto.hoverfly.junit.grpc.HoverflyConfigValidator;
import io.specto.hoverfly.junit.grpc.HoverflyGrpcConfiguration;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcConfig
extends HoverflyConfig {
    private static final String DEFAULT_LICENCE_FILE_NAME = "hoverfly_license";
    private static final String DEFAULT_BINARY_NAME_FORMAT = "hoverfly2_%s_%s%s";
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.INFO;
    private Logger hoverflyLogger = LoggerFactory.getLogger((String)"hoverfly-grpc");

    public HoverflyConfiguration build() {
        HoverflyGrpcConfiguration configs = new HoverflyGrpcConfiguration(this.proxyPort, this.adminPort, this.proxyLocalHost, this.destination, this.proxyCaCert, this.captureHeaders, this.webServer, this.hoverflyLogger, DEFAULT_LOG_LEVEL, this.statefulCapture, this.incrementalCapture, this.simulationPreprocessor);
        configs.setBinaryNameFormat(DEFAULT_BINARY_NAME_FORMAT);
        configs.setCommands(Arrays.asList("-license-path", HoverflyConfigValidator.findLicenseFileOnClasspath(DEFAULT_LICENCE_FILE_NAME)));
        HoverflyConfigValidator validator = new HoverflyConfigValidator();
        return validator.validate(configs);
    }
}

