/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RequestFieldMatcher<T> {
    private MatcherType matcher;
    private T value;

    public RequestFieldMatcher() {
    }

    public RequestFieldMatcher(MatcherType matcher, T value) {
        this.matcher = matcher;
        this.value = value;
    }

    public MatcherType getMatcher() {
        return this.matcher;
    }

    public void setMatcher(MatcherType matcher) {
        this.matcher = matcher;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public static RequestFieldMatcher newExactMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.EXACT, value);
    }

    public static RequestFieldMatcher newGlobMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.GLOB, value);
    }

    public static RequestFieldMatcher newRegexMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.REGEX, value);
    }

    public static RequestFieldMatcher newXmlMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.XML, value);
    }

    public static RequestFieldMatcher newXpathMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.XPATH, value);
    }

    public static RequestFieldMatcher newJsonMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.JSON, value);
    }

    public static RequestFieldMatcher newJsonPartialMatcher(String value) {
        return new RequestFieldMatcher<String>(MatcherType.JSONPARTIAL, value);
    }

    public static RequestFieldMatcher newJsonPathMatch(String value) {
        return new RequestFieldMatcher<String>(MatcherType.JSONPATH, value);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public static enum MatcherType {
        EXACT,
        GLOB,
        REGEX,
        XML,
        XPATH,
        JSON,
        JSONPARTIAL,
        JSONPATH;


        @JsonCreator
        public static MatcherType fromValue(String value) {
            return value == null ? null : MatcherType.valueOf(value.toUpperCase());
        }

        @JsonValue
        public String getValue() {
            return this.name().toLowerCase();
        }
    }
}

