/*
 * Decompiled with CFR 0.152.
 */
package io.specto.hoverfly.junit;

import io.specto.hoverfly.junit.HoverflyConfig;
import io.specto.hoverfly.junit.HoverflyMode;
import io.specto.hoverfly.junit.HoverflyRuleUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyStore;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.StartedProcess;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

class Hoverfly {
    private static final Logger LOGGER = LoggerFactory.getLogger(Hoverfly.class);
    private static final int BOOT_TIMEOUT_SECONDS = 10;
    private static final String HEALTH_CHECK_URL = "http://localhost:%s/api/stats";
    private static final String SIMULATION_URL = "http://localhost:%s/api/v2/simulation";
    private static final String BINARY_VERSION = "0.9.1";
    private static final String BINARY_PATH = "hoverfly_v%s_%s_%s";
    private final HoverflyConfig hoverflyConfig;
    private final HoverflyMode hoverflyMode;
    private final Integer proxyPort;
    private final Integer adminPort;
    private StartedProcess startedProcess;
    private Path binaryPath;

    Hoverfly(HoverflyConfig hoverflyConfig, HoverflyMode hoverflyMode) {
        this.hoverflyConfig = hoverflyConfig;
        this.hoverflyMode = hoverflyMode;
        this.proxyPort = hoverflyConfig.getProxyPort() == 0 ? HoverflyRuleUtils.findUnusedPort() : hoverflyConfig.getProxyPort();
        this.adminPort = hoverflyConfig.getAdminPort() == 0 ? HoverflyRuleUtils.findUnusedPort() : hoverflyConfig.getAdminPort();
    }

    void start() throws IOException, URISyntaxException {
        this.setTrustStore();
        this.setProxySystemProperties();
        String binaryName = String.format(BINARY_PATH, BINARY_VERSION, HoverflyRuleUtils.getOs(), HoverflyRuleUtils.getArchitectureType()) + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        LOGGER.info("Selecting the following binary based on the current operating system: {}", (Object)binaryName);
        this.binaryPath = this.extractBinary(binaryName);
        LOGGER.info("Executing binary at {}", (Object)this.binaryPath);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.binaryPath.toString());
        commands.add("-db");
        commands.add("memory");
        commands.add("-pp");
        commands.add(this.proxyPort.toString());
        commands.add("-ap");
        commands.add(this.adminPort.toString());
        if (this.hoverflyMode == HoverflyMode.CAPTURE) {
            commands.add("-capture");
        }
        this.startedProcess = new ProcessExecutor().command(commands).redirectOutput((OutputStream)Slf4jStream.of((Logger)LOGGER).asInfo()).directory(this.binaryPath.getParent().toFile()).start();
        this.waitForHoverflyToStart();
    }

    void stop() {
        LOGGER.info("Destroying hoverfly process");
        this.startedProcess.getProcess().destroy();
        try {
            Files.deleteIfExists(this.binaryPath);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to delete hoverfly binary", e);
        }
    }

    boolean isHealthy(int adminPort) {
        boolean isHealthy = false;
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(String.format(HEALTH_CHECK_URL, adminPort)).openConnection();
            con.setRequestMethod("GET");
            LOGGER.debug("Hoverfly health check status code is: {}", (Object)con.getResponseCode());
            isHealthy = con.getResponseCode() == 200;
        }
        catch (IOException e) {
            LOGGER.debug("Exception curling health check", (Throwable)e);
        }
        return isHealthy;
    }

    void importSimulation(URI serviceDataURI) throws IOException {
        HttpURLConnection con = (HttpURLConnection)new URL(String.format(SIMULATION_URL, this.adminPort)).openConnection();
        con.setRequestMethod("PUT");
        con.setDoOutput(true);
        try (OutputStream os = con.getOutputStream();){
            if (serviceDataURI.getScheme().startsWith("http")) {
                IOUtils.copy((InputStream)serviceDataURI.toURL().openStream(), (OutputStream)os);
            } else {
                Files.copy(Paths.get(serviceDataURI), os);
            }
            os.flush();
        }
        con.connect();
        int responseCode = con.getResponseCode();
        if (responseCode < 200 || responseCode > 299) {
            String result = new BufferedReader(new InputStreamReader(con.getErrorStream())).lines().collect(Collectors.joining("\n"));
            throw new RuntimeException("Submit simulation data failed with error: " + result);
        }
    }

    void exportSimulation(URI serviceDataURI) {
        LOGGER.info("Storing captured data");
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(String.format(SIMULATION_URL, this.adminPort)).openConnection();
            con.setRequestMethod("GET");
            Path path = Paths.get(serviceDataURI);
            Files.deleteIfExists(path);
            Files.copy(con.getInputStream(), path, new CopyOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to persist captured data", e);
        }
    }

    private void setProxySystemProperties() {
        LOGGER.info("Setting proxy host to {}", (Object)"localhost");
        System.setProperty("http.proxyHost", "localhost");
        System.setProperty("https.proxyHost", "localhost");
        if (this.hoverflyConfig.isProxyLocalHost()) {
            System.setProperty("http.nonProxyHosts", "");
        } else {
            System.setProperty("http.nonProxyHosts", "local|*.local|169.254/16|*.169.254/16");
        }
        LOGGER.info("Setting proxy proxyPort to {}", (Object)this.hoverflyConfig.getProxyPort());
        System.setProperty("http.proxyPort", this.proxyPort.toString());
        System.setProperty("https.proxyPort", this.proxyPort.toString());
    }

    private void waitForHoverflyToStart() {
        Instant now = Instant.now();
        while (Duration.between(now, Instant.now()).getSeconds() < 10L) {
            if (this.isHealthy(this.adminPort)) {
                return;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalStateException("Hoverfly has not become healthy in 10 seconds");
    }

    private Path extractBinary(String binaryName) throws IOException {
        URI sourceHoverflyUrl = HoverflyRuleUtils.findResourceOnClasspath(binaryName);
        Path temporaryHoverflyPath = Files.createTempFile(binaryName, "", new FileAttribute[0]);
        LOGGER.info("Storing binary in temporary directory {}", (Object)temporaryHoverflyPath);
        File temporaryHoverflyFile = temporaryHoverflyPath.toFile();
        FileUtils.copyURLToFile((URL)sourceHoverflyUrl.toURL(), (File)temporaryHoverflyFile);
        if (SystemUtils.IS_OS_WINDOWS) {
            temporaryHoverflyFile.setExecutable(true);
            temporaryHoverflyFile.setReadable(true);
            temporaryHoverflyFile.setWritable(true);
        } else {
            Files.setPosixFilePermissions(temporaryHoverflyPath, new HashSet<PosixFilePermission>(Arrays.asList(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.OWNER_READ)));
        }
        return temporaryHoverflyPath;
    }

    private void setTrustStore() {
        try {
            InputStream trustStream = HoverflyRuleUtils.findResourceOnClasspath("hoverfly.jks").toURL().openStream();
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(trustStream, "hoverfly".toCharArray());
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(trustStore);
            TrustManager[] trustManagers = trustFactory.getTrustManagers();
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, trustManagers, null);
            SSLContext.setDefault(sslContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set hoverfly trust store", e);
        }
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }
}

