/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.spiffeid;

import io.spiffe.exception.InvalidSpiffeIdException;
import io.spiffe.spiffeid.TrustDomain;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class SpiffeId {
    static final String SPIFFE_SCHEME = "spiffe";
    static final String SCHEME_PREFIX = "spiffe://";
    static final String EMPTY = "Cannot be empty";
    static final String MISSING_TRUST_DOMAIN = "Trust domain is missing";
    static final String WRONG_SCHEME = "Scheme is missing or invalid";
    static final String BAD_TRUST_DOMAIN_CHAR = "Trust domain characters are limited to lowercase letters, numbers, dots, dashes, and underscores";
    static final String BAD_PATH_SEGMENT_CHAR = "Path segment characters are limited to letters, numbers, dots, dashes, and underscores";
    static final String DOT_SEGMENT = "Path cannot contain dot segments";
    static final String EMPTY_SEGMENT = "Path cannot contain empty segments";
    static final String TRAILING_SLASH = "Path cannot have a trailing slash";
    private final TrustDomain trustDomain;
    private final String path;

    private SpiffeId(TrustDomain trustDomain, String path) {
        this.trustDomain = trustDomain;
        this.path = path;
    }

    public static SpiffeId fromSegments(@NonNull TrustDomain trustDomain, String ... segments) {
        if (trustDomain == null) {
            throw new NullPointerException("trustDomain is marked non-null but is null");
        }
        StringBuilder path = new StringBuilder();
        for (String p : segments) {
            SpiffeId.validatePath(p);
            path.append('/');
            path.append(p);
        }
        return new SpiffeId(trustDomain, path.toString());
    }

    public static SpiffeId parse(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new IllegalArgumentException(EMPTY);
        }
        if (!id.contains(SCHEME_PREFIX)) {
            throw new InvalidSpiffeIdException(WRONG_SCHEME);
        }
        String rest = id.substring(SCHEME_PREFIX.length());
        int i = 0;
        for (char c : rest.toCharArray()) {
            if (c == '/') break;
            if (!TrustDomain.isValidTrustDomainChar(c)) {
                throw new InvalidSpiffeIdException(BAD_TRUST_DOMAIN_CHAR);
            }
            ++i;
        }
        if (i == 0) {
            throw new InvalidSpiffeIdException(MISSING_TRUST_DOMAIN);
        }
        String td = rest.substring(0, i);
        String path = rest.substring(i);
        if (StringUtils.isNotBlank((CharSequence)path)) {
            SpiffeId.validatePath(path);
        }
        return new SpiffeId(new TrustDomain(td), path);
    }

    public boolean memberOf(TrustDomain trustDomain) {
        return this.trustDomain.equals(trustDomain);
    }

    public String toString() {
        return String.format("%s://%s%s", SPIFFE_SCHEME, this.trustDomain.toString(), this.path);
    }

    public static void validatePath(String path) {
        int segmentEnd;
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException(EMPTY);
        }
        int segmentStart = 0;
        for (segmentEnd = 0; segmentEnd < path.length(); ++segmentEnd) {
            char c = path.charAt(segmentEnd);
            if (c == '/') {
                switch (path.substring(segmentStart, segmentEnd)) {
                    case "/": {
                        throw new InvalidSpiffeIdException(EMPTY_SEGMENT);
                    }
                    case "/.": 
                    case "/..": {
                        throw new InvalidSpiffeIdException(DOT_SEGMENT);
                    }
                }
                segmentStart = segmentEnd;
                continue;
            }
            if (SpiffeId.isValidPathSegmentChar(c)) continue;
            throw new InvalidSpiffeIdException(BAD_PATH_SEGMENT_CHAR);
        }
        switch (path.substring(segmentStart, segmentEnd)) {
            case "/": {
                throw new InvalidSpiffeIdException(TRAILING_SLASH);
            }
            case "/.": 
            case "/..": {
                throw new InvalidSpiffeIdException(DOT_SEGMENT);
            }
        }
    }

    private static boolean isValidPathSegmentChar(char c) {
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        if (c >= 'A' && c <= 'Z') {
            return true;
        }
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-' || c == '.' || c == '_';
    }

    @Generated
    public TrustDomain getTrustDomain() {
        return this.trustDomain;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpiffeId)) {
            return false;
        }
        SpiffeId other = (SpiffeId)o;
        TrustDomain this$trustDomain = this.getTrustDomain();
        TrustDomain other$trustDomain = other.getTrustDomain();
        if (this$trustDomain == null ? other$trustDomain != null : !((Object)this$trustDomain).equals(other$trustDomain)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TrustDomain $trustDomain = this.getTrustDomain();
        result = result * 59 + ($trustDomain == null ? 43 : ((Object)$trustDomain).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }
}

