/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;

public enum JwtSignatureAlgorithm {
    ES256("ES256"),
    ES384("ES384"),
    ES512("ES512"),
    RS256("RS256"),
    RS384("RS384"),
    RS512("RS512"),
    PS256("PS256"),
    PS384("PS384"),
    PS512("PS512");

    private final String name;

    private JwtSignatureAlgorithm(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static JwtSignatureAlgorithm parse(@NonNull String s) {
        JwtSignatureAlgorithm algorithm;
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        if (s.equals(RS256.getName())) {
            algorithm = RS256;
        } else if (s.equals(RS384.getName())) {
            algorithm = RS384;
        } else if (s.equals(RS512.getName())) {
            algorithm = RS512;
        } else if (s.equals(ES256.getName())) {
            algorithm = ES256;
        } else if (s.equals(ES384.getName())) {
            algorithm = ES384;
        } else if (s.equals(ES512.getName())) {
            algorithm = ES512;
        } else if (s.equals(PS256.getName())) {
            algorithm = PS256;
        } else if (s.equals(PS384.getName())) {
            algorithm = PS384;
        } else if (s.equals(PS512.getName())) {
            algorithm = PS512;
        } else {
            throw new IllegalArgumentException("Unsupported JWT algorithm: " + s);
        }
        return algorithm;
    }

    public static enum Family {
        RSA("RSA", RS256, RS384, RS512, PS256, PS384, PS512),
        EC("EC", ES256, ES384, ES512);

        private final String name;
        private final Set<JwtSignatureAlgorithm> algorithms;

        private Family(String name, JwtSignatureAlgorithm ... algs) {
            this.name = name;
            this.algorithms = new HashSet<JwtSignatureAlgorithm>();
            Collections.addAll(this.algorithms, algs);
        }

        public String getName() {
            return this.name;
        }

        public boolean contains(JwtSignatureAlgorithm a) {
            return this.algorithms.contains((Object)a);
        }

        public static Family parse(String s) {
            Family family;
            if (s.equals(RSA.getName())) {
                family = RSA;
            } else if (s.equals(EC.getName())) {
                family = EC;
            } else {
                throw new IllegalArgumentException("Unsupported JWT family algorithm: " + s);
            }
            return family;
        }
    }
}

