/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.svid.x509svid;

import io.spiffe.exception.X509SvidException;
import io.spiffe.internal.AsymmetricKeyAlgorithm;
import io.spiffe.internal.CertificateUtils;
import io.spiffe.internal.KeyFileFormat;
import io.spiffe.spiffeid.SpiffeId;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

public final class X509Svid {
    private final SpiffeId spiffeId;
    private final List<X509Certificate> chain;
    private final PrivateKey privateKey;
    private final String hint;

    private X509Svid(SpiffeId spiffeId, List<X509Certificate> chain, PrivateKey privateKey, String hint) {
        this.spiffeId = spiffeId;
        this.chain = chain;
        this.privateKey = privateKey;
        this.hint = hint;
    }

    public X509Certificate getLeaf() {
        return this.chain.get(0);
    }

    public String getHint() {
        return this.hint;
    }

    public List<X509Certificate> getChain() {
        return Collections.unmodifiableList(this.chain);
    }

    public static X509Svid load(@NonNull Path certsFilePath, @NonNull Path privateKeyFilePath) throws X509SvidException {
        byte[] privateKeyBytes;
        byte[] certsBytes;
        if (certsFilePath == null) {
            throw new NullPointerException("certsFilePath is marked non-null but is null");
        }
        if (privateKeyFilePath == null) {
            throw new NullPointerException("privateKeyFilePath is marked non-null but is null");
        }
        try {
            certsBytes = Files.readAllBytes(certsFilePath);
        }
        catch (IOException e) {
            throw new X509SvidException("Cannot read certificate file", e);
        }
        try {
            privateKeyBytes = Files.readAllBytes(privateKeyFilePath);
        }
        catch (IOException e) {
            throw new X509SvidException("Cannot read private key file", e);
        }
        return X509Svid.createX509Svid(certsBytes, privateKeyBytes, KeyFileFormat.PEM, null);
    }

    public static X509Svid parse(@NonNull byte[] certsBytes, @NonNull byte[] privateKeyBytes) throws X509SvidException {
        if (certsBytes == null) {
            throw new NullPointerException("certsBytes is marked non-null but is null");
        }
        if (privateKeyBytes == null) {
            throw new NullPointerException("privateKeyBytes is marked non-null but is null");
        }
        return X509Svid.parse(certsBytes, privateKeyBytes, null);
    }

    public static X509Svid parse(@NonNull byte[] certsBytes, @NonNull byte[] privateKeyBytes, String hint) throws X509SvidException {
        if (certsBytes == null) {
            throw new NullPointerException("certsBytes is marked non-null but is null");
        }
        if (privateKeyBytes == null) {
            throw new NullPointerException("privateKeyBytes is marked non-null but is null");
        }
        return X509Svid.createX509Svid(certsBytes, privateKeyBytes, KeyFileFormat.PEM, hint);
    }

    public static X509Svid parseRaw(@NonNull byte[] certsBytes, @NonNull byte[] privateKeyBytes) throws X509SvidException {
        if (certsBytes == null) {
            throw new NullPointerException("certsBytes is marked non-null but is null");
        }
        if (privateKeyBytes == null) {
            throw new NullPointerException("privateKeyBytes is marked non-null but is null");
        }
        return X509Svid.parseRaw(certsBytes, privateKeyBytes, null);
    }

    public static X509Svid parseRaw(@NonNull byte[] certsBytes, @NonNull byte[] privateKeyBytes, String hint) throws X509SvidException {
        if (certsBytes == null) {
            throw new NullPointerException("certsBytes is marked non-null but is null");
        }
        if (privateKeyBytes == null) {
            throw new NullPointerException("privateKeyBytes is marked non-null but is null");
        }
        return X509Svid.createX509Svid(certsBytes, privateKeyBytes, KeyFileFormat.DER, hint);
    }

    public X509Certificate[] getChainArray() {
        return this.chain.toArray(new X509Certificate[0]);
    }

    private static X509Svid createX509Svid(byte[] certsBytes, byte[] privateKeyBytes, KeyFileFormat keyFileFormat, String hint) throws X509SvidException {
        List<X509Certificate> x509Certificates = X509Svid.generateX509Certificates(certsBytes);
        PrivateKey privateKey = X509Svid.generatePrivateKey(privateKeyBytes, keyFileFormat, x509Certificates);
        SpiffeId spiffeId = X509Svid.getSpiffeId(x509Certificates);
        X509Svid.validateLeafCertificate(x509Certificates.get(0));
        if (x509Certificates.size() > 1) {
            X509Svid.validateSigningCertificates(x509Certificates);
        }
        return new X509Svid(spiffeId, x509Certificates, privateKey, hint);
    }

    private static SpiffeId getSpiffeId(List<X509Certificate> x509Certificates) throws X509SvidException {
        SpiffeId spiffeId;
        try {
            spiffeId = CertificateUtils.getSpiffeId(x509Certificates.get(0));
        }
        catch (CertificateException e) {
            throw new X509SvidException(e.getMessage(), e);
        }
        return spiffeId;
    }

    private static PrivateKey generatePrivateKey(byte[] privateKeyBytes, KeyFileFormat keyFileFormat, List<X509Certificate> x509Certificates) throws X509SvidException {
        PrivateKey privateKey;
        String publicKeyCertAlgorithm = x509Certificates.get(0).getPublicKey().getAlgorithm();
        AsymmetricKeyAlgorithm algorithm = AsymmetricKeyAlgorithm.parse(publicKeyCertAlgorithm);
        try {
            privateKey = CertificateUtils.generatePrivateKey(privateKeyBytes, algorithm, keyFileFormat);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new X509SvidException("Private Key could not be parsed from key bytes", e);
        }
        return privateKey;
    }

    private static List<X509Certificate> generateX509Certificates(byte[] certsBytes) throws X509SvidException {
        List<X509Certificate> x509Certificates;
        try {
            x509Certificates = CertificateUtils.generateCertificates(certsBytes);
        }
        catch (CertificateParsingException e) {
            throw new X509SvidException("Certificate could not be parsed from cert bytes", e);
        }
        return x509Certificates;
    }

    private static void validateSigningCertificates(List<X509Certificate> certificates) throws X509SvidException {
        for (int i = 1; i < certificates.size(); ++i) {
            X509Svid.verifyCaCert(certificates.get(i));
        }
    }

    private static void verifyCaCert(X509Certificate cert) throws X509SvidException {
        if (!CertificateUtils.isCA(cert)) {
            throw new X509SvidException("Signing certificate must have CA flag set to true");
        }
        if (!CertificateUtils.hasKeyUsageCertSign(cert)) {
            throw new X509SvidException("Signing certificate must have 'keyCertSign' as key usage");
        }
    }

    private static void validateLeafCertificate(X509Certificate leaf) throws X509SvidException {
        if (CertificateUtils.isCA(leaf)) {
            throw new X509SvidException("Leaf certificate must not have CA flag set to true");
        }
        X509Svid.validateKeyUsageOfLeafCertificate(leaf);
    }

    private static void validateKeyUsageOfLeafCertificate(X509Certificate leaf) throws X509SvidException {
        if (!CertificateUtils.hasKeyUsageDigitalSignature(leaf)) {
            throw new X509SvidException("Leaf certificate must have 'digitalSignature' as key usage");
        }
        if (CertificateUtils.hasKeyUsageCertSign(leaf)) {
            throw new X509SvidException("Leaf certificate must not have 'keyCertSign' as key usage");
        }
        if (CertificateUtils.hasKeyUsageCRLSign(leaf)) {
            throw new X509SvidException("Leaf certificate must not have 'cRLSign' as key usage");
        }
    }

    @Generated
    public SpiffeId getSpiffeId() {
        return this.spiffeId;
    }

    @Generated
    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof X509Svid)) {
            return false;
        }
        X509Svid other = (X509Svid)o;
        SpiffeId this$spiffeId = this.getSpiffeId();
        SpiffeId other$spiffeId = other.getSpiffeId();
        if (this$spiffeId == null ? other$spiffeId != null : !((Object)this$spiffeId).equals(other$spiffeId)) {
            return false;
        }
        List<X509Certificate> this$chain = this.getChain();
        List<X509Certificate> other$chain = other.getChain();
        if (this$chain == null ? other$chain != null : !((Object)this$chain).equals(other$chain)) {
            return false;
        }
        PrivateKey this$privateKey = this.getPrivateKey();
        PrivateKey other$privateKey = other.getPrivateKey();
        if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
            return false;
        }
        String this$hint = this.getHint();
        String other$hint = other.getHint();
        return !(this$hint == null ? other$hint != null : !this$hint.equals(other$hint));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SpiffeId $spiffeId = this.getSpiffeId();
        result = result * 59 + ($spiffeId == null ? 43 : ((Object)$spiffeId).hashCode());
        List<X509Certificate> $chain = this.getChain();
        result = result * 59 + ($chain == null ? 43 : ((Object)$chain).hashCode());
        PrivateKey $privateKey = this.getPrivateKey();
        result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
        String $hint = this.getHint();
        result = result * 59 + ($hint == null ? 43 : $hint.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "X509Svid(spiffeId=" + this.getSpiffeId() + ", chain=" + this.getChain() + ", privateKey=" + this.getPrivateKey() + ", hint=" + this.getHint() + ")";
    }
}

