/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.workloadapi.retry;

import io.spiffe.workloadapi.retry.ExponentialBackoffPolicy;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class RetryHandler {
    private final ScheduledExecutorService executor;
    private final ExponentialBackoffPolicy exponentialBackoffPolicy;
    private Duration nextDelay;
    private int retryCount;

    public RetryHandler(ExponentialBackoffPolicy exponentialBackoffPolicy, ScheduledExecutorService executor) {
        this.nextDelay = exponentialBackoffPolicy.getInitialDelay();
        this.exponentialBackoffPolicy = exponentialBackoffPolicy;
        this.executor = executor;
    }

    public void scheduleRetry(Runnable runnable) {
        if (this.executor.isShutdown()) {
            return;
        }
        if (this.exponentialBackoffPolicy.reachedMaxRetries(this.retryCount)) {
            return;
        }
        this.executor.schedule(runnable, this.nextDelay.getSeconds(), TimeUnit.SECONDS);
        this.nextDelay = this.exponentialBackoffPolicy.nextDelay(this.nextDelay);
        ++this.retryCount;
    }

    public boolean shouldRetry() {
        return !this.exponentialBackoffPolicy.reachedMaxRetries(this.retryCount);
    }

    public void reset() {
        this.nextDelay = this.exponentialBackoffPolicy.getInitialDelay();
        this.retryCount = 0;
    }

    public Duration getNextDelay() {
        return this.nextDelay;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

