/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.provider.SpiffeKeyManagerFactory;
import io.spiffe.provider.SpiffeKeyStore;
import io.spiffe.provider.SpiffeTrustManagerFactory;
import java.security.Provider;
import java.security.Security;

public final class SpiffeProvider
extends Provider {
    private static final String SPIFFE_KEY_MANAGER_FACTORY = String.format("KeyManagerFactory.%s", "Spiffe");
    private static final String SPIFFE_TRUST_MANAGER_FACTORY = String.format("TrustManagerFactory.%s", "Spiffe");
    private static final String SPIFFE_KEYSTORE = String.format("KeyStore.%s", "Spiffe");

    public SpiffeProvider() {
        super("Spiffe", 0.6, "SPIFFE based KeyStore and TrustStore");
        super.put(SPIFFE_KEY_MANAGER_FACTORY, SpiffeKeyManagerFactory.class.getName());
        super.put(SPIFFE_TRUST_MANAGER_FACTORY, SpiffeTrustManagerFactory.class.getName());
        super.put(SPIFFE_KEYSTORE, SpiffeKeyStore.class.getName());
    }

    public static void install() {
        if (Security.getProvider("Spiffe") == null) {
            Security.addProvider(new SpiffeProvider());
        }
    }
}

