/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.redis.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.netflix.spinnaker.cats.cache.NamedCacheFactory;
import com.netflix.spinnaker.cats.cache.WriteableCache;
import com.netflix.spinnaker.cats.redis.cache.RedisCache;
import com.netflix.spinnaker.cats.redis.cache.RedisCacheOptions;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;

public class RedisNamedCacheFactory
implements NamedCacheFactory {
    private final RedisClientDelegate redisClientDelegate;
    private final ObjectMapper objectMapper;
    private final RedisCacheOptions options;
    private final RedisCache.CacheMetrics cacheMetrics;

    public RedisNamedCacheFactory(RedisClientDelegate redisClientDelegate, ObjectMapper objectMapper, RedisCacheOptions options, RedisCache.CacheMetrics cacheMetrics) {
        this.redisClientDelegate = redisClientDelegate;
        this.objectMapper = objectMapper;
        this.options = options;
        this.cacheMetrics = cacheMetrics;
    }

    public WriteableCache getCache(String name) {
        return new RedisCache(name, this.redisClientDelegate, this.objectMapper, this.options, this.cacheMetrics);
    }
}

