/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.config;

import com.netflix.spinnaker.cats.cluster.DefaultNodeIdentity;
import com.netflix.spinnaker.cats.cluster.NodeIdentity;
import com.netflix.spinnaker.cats.cluster.ShardingFilter;
import com.netflix.spinnaker.cats.redis.cluster.CachingPodsObserver;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"caching.write-enabled"}, matchIfMissing=true)
public class RedisShardingFilterConfiguration {
    @Bean
    @ConditionalOnExpression(value="${redis.enabled:true} && ${redis.scheduler.enabled:true} && ${cache-sharding.enabled:false}")
    ShardingFilter shardingFilter(RedisClientDelegate redisClientDelegate, DynamicConfigService dynamicConfigService) {
        return new CachingPodsObserver(redisClientDelegate, (NodeIdentity)new DefaultNodeIdentity(), dynamicConfigService);
    }
}

