/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.redis.cluster;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.spinnaker.cats.agent.Agent;
import com.netflix.spinnaker.cats.cluster.NodeIdentity;
import com.netflix.spinnaker.cats.cluster.ShardingFilter;
import com.netflix.spinnaker.kork.dynamicconfig.DynamicConfigService;
import com.netflix.spinnaker.kork.jedis.RedisClientDelegate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingPodsObserver
implements ShardingFilter,
Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CachingPodsObserver.class);
    private static final String REPLICA_SSET_KEY = "clouddriver:caching:replicas";
    private static final String CORE_PROVIDER = "com.netflix.spinnaker.clouddriver.core.provider.CoreProvider";
    private final RedisClientDelegate redisClientDelegate;
    private final NodeIdentity nodeIdentity;
    private final long replicaKeyTtl;
    private int podCount = 0;
    private int podIndex = -1;
    private static final String HEARTBEAT_REFRESH_SCRIPT = "redis.call('zadd', KEYS[1], ARGV[1], ARGV[2]) redis.call('zremrangebyscore', KEYS[1], '-inf', ARGV[3]) return redis.call('zrange', KEYS[1], '0', '-1')";

    public CachingPodsObserver(RedisClientDelegate redisClientDelegate, NodeIdentity nodeIdentity, DynamicConfigService dynamicConfigService) {
        this.redisClientDelegate = redisClientDelegate;
        this.nodeIdentity = nodeIdentity;
        long observerIntervalSeconds = ((Integer)dynamicConfigService.getConfig(Integer.class, "cache-sharding.heartbeat-interval-seconds", (Object)30)).intValue();
        this.replicaKeyTtl = ((Integer)dynamicConfigService.getConfig(Integer.class, "cache-sharding.replica-ttl-seconds", (Object)60)).intValue();
        ScheduledExecutorService podsObserverExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(CachingPodsObserver.class.getSimpleName() + "-%d").build());
        podsObserverExecutorService.scheduleAtFixedRate(this, 0L, observerIntervalSeconds, TimeUnit.SECONDS);
        this.refreshHeartbeat();
        logger.info("Account based sharding is enabled for all caching pods.");
    }

    @Override
    public void run() {
        try {
            this.refreshHeartbeat();
        }
        catch (Throwable t) {
            logger.error("Failed to manage replicas heartbeat", t);
        }
    }

    private void refreshHeartbeat() {
        String now = String.valueOf(System.currentTimeMillis());
        String expiry = String.valueOf(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(this.replicaKeyTtl));
        Object evalResponse = this.redisClientDelegate.withScriptingClient(client -> client.eval(HEARTBEAT_REFRESH_SCRIPT, Collections.singletonList(REPLICA_SSET_KEY), Arrays.asList(expiry, this.nodeIdentity.getNodeIdentity(), now)));
        if (evalResponse instanceof List) {
            List replicaList = (List)evalResponse;
            this.podCount = replicaList.size();
            this.podIndex = replicaList.stream().sorted().collect(Collectors.toList()).indexOf(this.nodeIdentity.getNodeIdentity());
            logger.debug("caching pods = {} and this pod's index = {}", (Object)this.podCount, (Object)this.podIndex);
        } else {
            logger.error("Something is wrong, please check if the eval script and params are valid");
        }
        if (this.podCount == 0 || this.podIndex == -1) {
            logger.error("No caching pod heartbeat records detected. Sharding logic can't be applied!!!!");
        }
    }

    public boolean filter(Agent agent) {
        if (agent.getProviderName().equals(CORE_PROVIDER)) {
            return true;
        }
        return this.podCount == 1 || Math.abs(this.getAccountName(agent.getAgentType()).hashCode() % this.podCount) == this.podIndex;
    }

    private String getAccountName(String agentType) {
        if (agentType.contains("/")) {
            return agentType.substring(0, agentType.indexOf(47));
        }
        return agentType;
    }
}

