/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.cats.agent.CacheResult;
import com.netflix.spinnaker.cats.provider.ProviderCache;
import com.netflix.spinnaker.clouddriver.cache.OnDemandMetricsSupportable;
import com.netflix.spinnaker.clouddriver.cache.OnDemandType;
import com.netflix.spinnaker.kork.annotations.Beta;
import com.netflix.spinnaker.moniker.Moniker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public interface OnDemandAgent {
    public static final Logger logger = LoggerFactory.getLogger(OnDemandAgent.class);

    public String getProviderName();

    public String getOnDemandAgentType();

    public OnDemandMetricsSupportable getMetricsSupport();

    public boolean handles(OnDemandType var1, String var2);

    default public Moniker convertOnDemandDetails(Map<String, String> details) {
        if (details == null || details.isEmpty()) {
            return null;
        }
        try {
            String sequence = details.get("sequence");
            return Moniker.builder().app(details.get("application")).stack(details.get("stack")).detail(details.get("detail")).cluster(details.get("cluster")).sequence(sequence != null ? Integer.valueOf(sequence) : null).build();
        }
        catch (Exception e) {
            logger.warn("Unable to build moniker", (Throwable)e);
            return null;
        }
    }

    @Nullable
    public OnDemandResult handle(ProviderCache var1, Map<String, ?> var2);

    public Collection<Map<String, Object>> pendingOnDemandRequests(ProviderCache var1);

    default public Map<String, Object> pendingOnDemandRequest(ProviderCache providerCache, String id) {
        Collection<Map<String, Object>> pendingOnDemandRequests = this.pendingOnDemandRequests(providerCache);
        return pendingOnDemandRequests.stream().filter(m -> id.equals(m.get("id"))).findFirst().orElse(null);
    }

    public static class OnDemandResult {
        String sourceAgentType;
        Collection<String> authoritativeTypes = new ArrayList<String>();
        CacheResult cacheResult;
        Map<String, Collection<String>> evictions = new HashMap<String, Collection<String>>();

        public OnDemandResult() {
        }

        public OnDemandResult(String sourceAgentType, CacheResult cacheResult, Map<String, Collection<String>> evictions) {
            this.sourceAgentType = sourceAgentType;
            this.cacheResult = cacheResult;
            this.evictions = evictions;
        }

        @Generated
        public String getSourceAgentType() {
            return this.sourceAgentType;
        }

        @Generated
        public Collection<String> getAuthoritativeTypes() {
            return this.authoritativeTypes;
        }

        @Generated
        public CacheResult getCacheResult() {
            return this.cacheResult;
        }

        @Generated
        public Map<String, Collection<String>> getEvictions() {
            return this.evictions;
        }

        @Generated
        public OnDemandResult setSourceAgentType(String sourceAgentType) {
            this.sourceAgentType = sourceAgentType;
            return this;
        }

        @Generated
        public OnDemandResult setAuthoritativeTypes(Collection<String> authoritativeTypes) {
            this.authoritativeTypes = authoritativeTypes;
            return this;
        }

        @Generated
        public OnDemandResult setCacheResult(CacheResult cacheResult) {
            this.cacheResult = cacheResult;
            return this;
        }

        @Generated
        public OnDemandResult setEvictions(Map<String, Collection<String>> evictions) {
            this.evictions = evictions;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OnDemandResult)) {
                return false;
            }
            OnDemandResult other = (OnDemandResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$sourceAgentType = this.getSourceAgentType();
            String other$sourceAgentType = other.getSourceAgentType();
            if (this$sourceAgentType == null ? other$sourceAgentType != null : !this$sourceAgentType.equals(other$sourceAgentType)) {
                return false;
            }
            Collection<String> this$authoritativeTypes = this.getAuthoritativeTypes();
            Collection<String> other$authoritativeTypes = other.getAuthoritativeTypes();
            if (this$authoritativeTypes == null ? other$authoritativeTypes != null : !((Object)this$authoritativeTypes).equals(other$authoritativeTypes)) {
                return false;
            }
            CacheResult this$cacheResult = this.getCacheResult();
            CacheResult other$cacheResult = other.getCacheResult();
            if (this$cacheResult == null ? other$cacheResult != null : !this$cacheResult.equals(other$cacheResult)) {
                return false;
            }
            Map<String, Collection<String>> this$evictions = this.getEvictions();
            Map<String, Collection<String>> other$evictions = other.getEvictions();
            return !(this$evictions == null ? other$evictions != null : !((Object)this$evictions).equals(other$evictions));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OnDemandResult;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourceAgentType = this.getSourceAgentType();
            result = result * 59 + ($sourceAgentType == null ? 43 : $sourceAgentType.hashCode());
            Collection<String> $authoritativeTypes = this.getAuthoritativeTypes();
            result = result * 59 + ($authoritativeTypes == null ? 43 : ((Object)$authoritativeTypes).hashCode());
            CacheResult $cacheResult = this.getCacheResult();
            result = result * 59 + ($cacheResult == null ? 43 : $cacheResult.hashCode());
            Map<String, Collection<String>> $evictions = this.getEvictions();
            result = result * 59 + ($evictions == null ? 43 : ((Object)$evictions).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "OnDemandAgent.OnDemandResult(sourceAgentType=" + this.getSourceAgentType() + ", authoritativeTypes=" + this.getAuthoritativeTypes() + ", cacheResult=" + this.getCacheResult() + ", evictions=" + this.getEvictions() + ")";
        }
    }
}

