/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.cats.cache;

import com.netflix.spinnaker.cats.cache.CacheData;
import com.netflix.spinnaker.cats.cache.CacheFilter;
import com.netflix.spinnaker.cats.cache.UnsupportedCacheMethodException;
import com.netflix.spinnaker.kork.annotations.Beta;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

@Beta
public interface Cache {
    public CacheData get(String var1, String var2);

    public CacheData get(String var1, String var2, CacheFilter var3);

    default public boolean exists(String type, String identifier) {
        return !this.existingIdentifiers(type, Collections.singleton(identifier)).isEmpty();
    }

    default public Collection<String> existingIdentifiers(String type, String ... identifiers) {
        if (identifiers.length == 0) {
            return Collections.emptySet();
        }
        return this.existingIdentifiers(type, Arrays.asList(identifiers));
    }

    public Collection<String> existingIdentifiers(String var1, Collection<String> var2);

    public Collection<String> getIdentifiers(String var1);

    public Collection<String> filterIdentifiers(String var1, String var2);

    public Collection<CacheData> getAll(String var1);

    public Collection<CacheData> getAll(String var1, CacheFilter var2);

    public Collection<CacheData> getAll(String var1, Collection<String> var2);

    public Collection<CacheData> getAll(String var1, Collection<String> var2, CacheFilter var3);

    public Collection<CacheData> getAll(String var1, String ... var2);

    default public boolean supportsGetAllByApplication() {
        return false;
    }

    default public Map<String, Collection<CacheData>> getAllByApplication(String type, String application) {
        throw new UnsupportedCacheMethodException("Method only implemented for StoreType.SQL");
    }

    default public Map<String, Collection<CacheData>> getAllByApplication(String type, String application, CacheFilter cacheFilter) {
        throw new UnsupportedCacheMethodException("Method only implemented for StoreType.SQL");
    }

    default public Map<String, Collection<CacheData>> getAllByApplication(Collection<String> types, String application, Map<String, CacheFilter> cacheFilters) {
        throw new UnsupportedCacheMethodException("Method only implemented for StoreType.SQL");
    }
}

