/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.cache;

import com.netflix.spinnaker.kork.annotations.Beta;
import java.util.function.Supplier;

@Beta
public interface OnDemandMetricsSupportable {
    public static final String ON_DEMAND_TOTAL_TIME = "onDemand_total";
    public static final String DATA_READ = "onDemand_read";
    public static final String DATA_TRANSFORM = "onDemand_transform";
    public static final String ON_DEMAND_STORE = "onDemand_store";
    public static final String CACHE_WRITE = "onDemand_cache";
    public static final String CACHE_EVICT = "onDemand_evict";
    public static final String ON_DEMAND_ERROR = "onDemand_error";
    public static final String ON_DEMAND_COUNT = "onDemand_count";

    public <T> T readData(Supplier<T> var1);

    public <T> T transformData(Supplier<T> var1);

    public <T> T onDemandStore(Supplier<T> var1);

    public <T> T cacheWrite(Supplier<T> var1);

    default public void cacheWrite(Runnable closure) {
        this.cacheWrite(() -> {
            closure.run();
            return null;
        });
    }

    public <T> T cacheEvict(Supplier<T> var1);

    default public void cacheEvict(Runnable closure) {
        this.cacheEvict(() -> {
            closure.run();
            return null;
        });
    }

    public void countError();

    public void countOnDemand();

    public void recordTotalRunTimeNanos(long var1);
}

