/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spinnaker.clouddriver.appengine.deploy.validators;

import com.netflix.spinnaker.clouddriver.appengine.gitClient.AppengineGitCredentialType;
import com.netflix.spinnaker.clouddriver.appengine.gitClient.AppengineGitCredentials;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineInstance;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineModelUtil;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineServerGroup;
import com.netflix.spinnaker.clouddriver.appengine.model.AppengineTrafficSplit;
import com.netflix.spinnaker.clouddriver.appengine.model.ScalingPolicyType;
import com.netflix.spinnaker.clouddriver.appengine.model.ShardBy;
import com.netflix.spinnaker.clouddriver.appengine.provider.view.AppengineClusterProvider;
import com.netflix.spinnaker.clouddriver.appengine.provider.view.AppengineInstanceProvider;
import com.netflix.spinnaker.clouddriver.appengine.provider.view.AppengineLoadBalancerProvider;
import com.netflix.spinnaker.clouddriver.appengine.security.AppengineNamedAccountCredentials;
import com.netflix.spinnaker.clouddriver.deploy.ValidationErrors;
import com.netflix.spinnaker.credentials.CredentialsRepository;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;

public class StandardAppengineAttributeValidator
implements GroovyObject {
    private static final Object namePattern;
    private static final Object prefixPattern;
    private String context;
    private ValidationErrors errors;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    private static /* synthetic */ SoftReference $callSiteArray;

    public StandardAppengineAttributeValidator(String context, ValidationErrors errors) {
        MetaClass metaClass;
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string = context;
        this.context = ShortTypeHandling.castToString((Object)string);
        ValidationErrors validationErrors = errors;
        this.errors = (ValidationErrors)ScriptBytecodeAdapter.castToType((Object)validationErrors, ValidationErrors.class);
    }

    public Object validateCredentials(String credentials, CredentialsRepository<AppengineNamedAccountCredentials> credentialsRepository) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        Object result = callSiteArray[0].callCurrent((GroovyObject)this, (Object)credentials, (Object)"account");
        if (DefaultTypeTransformation.booleanUnbox((Object)result)) {
            Object appengineCredentials = callSiteArray[1].call(credentialsRepository, (Object)credentials);
            if (!DefaultTypeTransformation.booleanUnbox((Object)appengineCredentials)) {
                callSiteArray[2].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".account"}), (Object)new GStringImpl(new Object[]{this.context}, new String[]{"", ".account.notFound"}));
                boolean bl = false;
                result = bl;
            }
        }
        return result;
    }

    public Object validateGitCredentials(AppengineGitCredentials gitCredentials, AppengineGitCredentialType gitCredentialType, String accountName, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[3].callCurrent((GroovyObject)this, (Object)gitCredentialType, (Object)attribute))) {
            Object supportedCredentialTypes = callSiteArray[4].call((Object)gitCredentials);
            Object credentialTypeSupported = callSiteArray[5].call(supportedCredentialTypes, (Object)gitCredentialType);
            if (DefaultTypeTransformation.booleanUnbox((Object)credentialTypeSupported)) {
                return true;
            }
            callSiteArray[6].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[7].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid"}), (Object)new GStringImpl(new Object[]{accountName, callSiteArray[8].call(supportedCredentialTypes, (Object)", ")}, new String[]{" (Account ", " supports only the following git credential types: ", ""})));
            return false;
        }
        return false;
    }

    public Object validateNotEmpty(Object value, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)"") && ScriptBytecodeAdapter.compareNotEqual((Object)value, null) && ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]))) {
                return true;
            }
            callSiteArray[9].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)"") && ScriptBytecodeAdapter.compareNotEqual((Object)value, null) && ScriptBytecodeAdapter.compareNotEqual((Object)value, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]))) {
            return true;
        }
        callSiteArray[10].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
        return false;
    }

    public Object validateApplication(String value, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].callCurrent((GroovyObject)this, (Object)value, (Object)attribute))) {
            return callSiteArray[12].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, prefixPattern);
        }
        return false;
    }

    public Object validateStack(String value, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[13].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, prefixPattern);
    }

    public Object validateDetails(String value, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)value)) {
            return true;
        }
        return callSiteArray[14].callCurrent((GroovyObject)this, (Object)value, (Object)attribute, namePattern);
    }

    public Object validateByRegex(String value, String attribute, String regex) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.matchRegex((Object)value, (Object)regex)) {
            return true;
        }
        callSiteArray[15].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, regex}, new String[]{"", ".", ".invalid (Must match ", ")"}));
        return false;
    }

    public Object validateTrafficSplit(AppengineTrafficSplit trafficSplit, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callCurrent((GroovyObject)this, (Object)trafficSplit, (Object)attribute))) {
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGroovyObjectGetProperty((Object)trafficSplit))) {
                return callSiteArray[18].callCurrent((GroovyObject)this, callSiteArray[19].callGroovyObjectGetProperty((Object)trafficSplit), callSiteArray[20].callGroovyObjectGetProperty((Object)trafficSplit), callSiteArray[21].call((Object)attribute, (Object)".allocations"));
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[22].callGroovyObjectGetProperty((Object)trafficSplit))) {
                return true;
            }
            callSiteArray[23].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".empty"}));
            return false;
        }
        return false;
    }

    public Object validateMaxNotLessThanMin(Integer minValue, Integer maxValue, String minAttribute, String maxAttribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareLessThan((Object)maxValue, (Object)minValue)) {
            callSiteArray[24].call((Object)this.errors, (Object)maxAttribute, (Object)new GStringImpl(new Object[]{this.context, maxAttribute, this.context, minAttribute}, new String[]{"", ".", " must not be less than ", ".", "."}));
            return false;
        }
        return true;
    }

    public Object validateNonNegative(Integer value, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)value) && ScriptBytecodeAdapter.compareLessThan((Object)value, (Object)0)) {
            callSiteArray[25].call((Object)this.errors, (Object)attribute, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".negative"}));
            return false;
        }
        return true;
    }

    public Object validateAllocations(Map<String, Double> allocations, ShardBy shardBy, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        Reference decimalPlaces = new Reference(ScriptBytecodeAdapter.compareEqual((Object)((Object)shardBy), (Object)callSiteArray[26].callGetProperty(ShardBy.class)) ? callSiteArray[27].callGetProperty(AppengineModelUtil.class) : callSiteArray[28].callGetProperty(AppengineModelUtil.class));
        Reference serverGroupsWithInvalidAllocations = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        public final class _validateAllocations_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference decimalPlaces;
            private /* synthetic */ Reference serverGroupsWithInvalidAllocations;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateAllocations_closure1(Object _outerInstance, Object _thisObject, Reference decimalPlaces, Reference serverGroupsWithInvalidAllocations) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _validateAllocations_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.decimalPlaces = reference2 = decimalPlaces;
                this.serverGroupsWithInvalidAllocations = reference = serverGroupsWithInvalidAllocations;
            }

            public Object doCall(Object serverGroupName, Object allocation) {
                CallSite[] callSiteArray = _validateAllocations_closure1.$getCallSiteArray();
                if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[0].call((Object)((Double)ScriptBytecodeAdapter.asType((Object)allocation, Double.class)), this.decimalPlaces.get()), (Object)allocation)) {
                    return callSiteArray[1].call(this.serverGroupsWithInvalidAllocations.get(), serverGroupName);
                }
                return null;
            }

            public Object call(Object serverGroupName, Object allocation) {
                CallSite[] callSiteArray = _validateAllocations_closure1.$getCallSiteArray();
                return callSiteArray[2].callCurrent((GroovyObject)this, serverGroupName, allocation);
            }

            @Generated
            public Object getDecimalPlaces() {
                CallSite[] callSiteArray = _validateAllocations_closure1.$getCallSiteArray();
                return this.decimalPlaces.get();
            }

            @Generated
            public Object getServerGroupsWithInvalidAllocations() {
                CallSite[] callSiteArray = _validateAllocations_closure1.$getCallSiteArray();
                return this.serverGroupsWithInvalidAllocations.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateAllocations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "round";
                stringArray[1] = "leftShift";
                stringArray[2] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _validateAllocations_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateAllocations_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateAllocations_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[29].call(allocations, (Object)new _validateAllocations_closure1(this, this, decimalPlaces, serverGroupsWithInvalidAllocations));
        if (DefaultTypeTransformation.booleanUnbox((Object)serverGroupsWithInvalidAllocations.get())) {
            Boolean pluralize = ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[30].call(serverGroupsWithInvalidAllocations.get()), (Object)1);
            callSiteArray[31].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[32].call(callSiteArray[33].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), (Object)new GStringImpl(new Object[]{DefaultTypeTransformation.booleanUnbox((Object)pluralize) ? "s" : "", callSiteArray[34].call(serverGroupsWithInvalidAllocations.get(), (Object)", ")}, new String[]{"(Allocation", " invalid for ", ". "})), (Object)new GStringImpl(new Object[]{callSiteArray[35].call((Object)shardBy), decimalPlaces.get()}, new String[]{"Allocations for shard type ", " can have up to ", " decimal places.)"})));
            return false;
        }
        public final class _validateAllocations_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateAllocations_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validateAllocations_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object k, Object v) {
                CallSite[] callSiteArray = _validateAllocations_closure2.$getCallSiteArray();
                return v;
            }

            public Object call(Object k, Object v) {
                CallSite[] callSiteArray = _validateAllocations_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, k, v);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateAllocations_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "doCall";
                return new CallSiteArray(_validateAllocations_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateAllocations_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[36].call((Object)((Double)ScriptBytecodeAdapter.asType((Object)callSiteArray[37].call(callSiteArray[38].call(allocations, (Object)new _validateAllocations_closure2(this, this))), Double.class)), decimalPlaces.get()), (Object)1)) {
            callSiteArray[39].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Allocations must sum to 1)"}));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object validateServerGroupsCanBeEnabled(Collection<String> serverGroupNames, String loadBalancerName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider appengineClusterProvider, String attribute) {
        void var3_3;
        Reference loadBalancerName2 = new Reference((Object)loadBalancerName);
        Reference credentials2 = new Reference((Object)var3_3);
        Reference appengineClusterProvider2 = new Reference((Object)appengineClusterProvider);
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        public final class _validateServerGroupsCanBeEnabled_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateServerGroupsCanBeEnabled_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateServerGroupsCanBeEnabled_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_validateServerGroupsCanBeEnabled_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateServerGroupsCanBeEnabled_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _validateServerGroupsCanBeEnabled_closure4
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference appengineClusterProvider;
            private /* synthetic */ Reference credentials;
            private /* synthetic */ Reference loadBalancerName;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateServerGroupsCanBeEnabled_closure4(Object _outerInstance, Object _thisObject, Reference appengineClusterProvider, Reference credentials, Reference loadBalancerName) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.appengineClusterProvider = reference3 = appengineClusterProvider;
                this.credentials = reference2 = credentials;
                this.loadBalancerName = reference = loadBalancerName;
            }

            public Object doCall(Map reject, Object serverGroupName) {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure4.$getCallSiteArray();
                Object serverGroup = callSiteArray[0].call(this.appengineClusterProvider.get(), callSiteArray[1].callGroovyObjectGetProperty(this.credentials.get()), callSiteArray[2].callGroovyObjectGetProperty(this.credentials.get()), serverGroupName);
                if (!DefaultTypeTransformation.booleanUnbox((Object)serverGroup)) {
                    callSiteArray[3].call(callSiteArray[4].callGetProperty((Object)reject), serverGroupName);
                    return reject;
                }
                if (DefaultTypeTransformation.booleanUnbox((Object)this.loadBalancerName.get()) && ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[5].call(callSiteArray[6].callGetPropertySafe(serverGroup), this.loadBalancerName.get()), (Object)true)) {
                    callSiteArray[7].call(callSiteArray[8].callGetProperty((Object)reject), serverGroupName);
                    return reject;
                }
                return reject;
            }

            public Object call(Map reject, Object serverGroupName) {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure4.$getCallSiteArray();
                return callSiteArray[9].callCurrent((GroovyObject)this, (Object)reject, serverGroupName);
            }

            @Generated
            public AppengineClusterProvider getAppengineClusterProvider() {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure4.$getCallSiteArray();
                return (AppengineClusterProvider)ScriptBytecodeAdapter.castToType((Object)this.appengineClusterProvider.get(), AppengineClusterProvider.class);
            }

            @Generated
            public AppengineNamedAccountCredentials getCredentials() {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure4.$getCallSiteArray();
                return (AppengineNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), AppengineNamedAccountCredentials.class));
            }

            @Generated
            public String getLoadBalancerName() {
                CallSite[] callSiteArray = _validateServerGroupsCanBeEnabled_closure4.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.loadBalancerName.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateServerGroupsCanBeEnabled_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getServerGroup";
                stringArray[1] = "name";
                stringArray[2] = "region";
                stringArray[3] = "leftShift";
                stringArray[4] = "notFound";
                stringArray[5] = "contains";
                stringArray[6] = "loadBalancers";
                stringArray[7] = "leftShift";
                stringArray[8] = "notRegisteredWithLoadBalancer";
                stringArray[9] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[10];
                _validateServerGroupsCanBeEnabled_closure4.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateServerGroupsCanBeEnabled_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateServerGroupsCanBeEnabled_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object rejectedServerGroups = callSiteArray[40].call(serverGroupNames, callSiteArray[41].call((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[0]), (Object)new _validateServerGroupsCanBeEnabled_closure3(this, this)), (Object)new _validateServerGroupsCanBeEnabled_closure4(this, this, appengineClusterProvider2, credentials2, loadBalancerName2));
        Boolean valid = true;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGetProperty(rejectedServerGroups))) {
            Object notFound = callSiteArray[43].callGetProperty(rejectedServerGroups);
            callSiteArray[44].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[45].call(notFound), (Object)1) ? "s" : "", callSiteArray[46].call(notFound, (Object)", ")}, new String[]{"", ".", ".invalid (Server group", " ", " not found)."}));
            boolean bl = false;
            valid = bl;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].callGetProperty(rejectedServerGroups))) {
            Object notRegistered = callSiteArray[48].callGetProperty(rejectedServerGroups);
            callSiteArray[49].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[50].call((Object)new GStringImpl(new Object[]{this.context, attribute, ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[51].call(notRegistered), (Object)1) ? "s" : "", callSiteArray[52].call(notRegistered, (Object)", ")}, new String[]{"", ".", ".invalid (Server group", " ", " "}), (Object)new GStringImpl(new Object[]{(String)loadBalancerName2.get()}, new String[]{"not registered with load balancer ", ")."})));
            boolean bl = false;
            valid = bl;
        }
        return valid;
    }

    public Object validateLoadBalancerCanBeDeleted(String loadBalancerName, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)loadBalancerName, (Object)"default")) {
            callSiteArray[53].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Cannot delete default service)."}));
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public Object validateInstances(List<String> instanceIds, AppengineNamedAccountCredentials credentials, AppengineInstanceProvider appengineInstanceProvider, String attribute) {
        void var3_3;
        void var2_2;
        Reference instanceIds2 = new Reference(instanceIds);
        Reference credentials2 = new Reference((Object)var2_2);
        Reference appengineInstanceProvider2 = new Reference((Object)var3_3);
        Reference attribute2 = new Reference((Object)attribute);
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        public final class _validateInstances_closure5
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference appengineInstanceProvider;
            private /* synthetic */ Reference credentials;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstances_closure5(Object _outerInstance, Object _thisObject, Reference appengineInstanceProvider, Reference credentials) {
                Reference reference;
                Reference reference2;
                CallSite[] callSiteArray = _validateInstances_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.appengineInstanceProvider = reference2 = appengineInstanceProvider;
                this.credentials = reference = credentials;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _validateInstances_closure5.$getCallSiteArray();
                return callSiteArray[0].call(this.appengineInstanceProvider.get(), callSiteArray[1].callGroovyObjectGetProperty(this.credentials.get()), callSiteArray[2].callGroovyObjectGetProperty(this.credentials.get()), it);
            }

            @Generated
            public AppengineInstanceProvider getAppengineInstanceProvider() {
                CallSite[] callSiteArray = _validateInstances_closure5.$getCallSiteArray();
                return (AppengineInstanceProvider)ScriptBytecodeAdapter.castToType((Object)this.appengineInstanceProvider.get(), AppengineInstanceProvider.class);
            }

            @Generated
            public AppengineNamedAccountCredentials getCredentials() {
                CallSite[] callSiteArray = _validateInstances_closure5.$getCallSiteArray();
                return (AppengineNamedAccountCredentials)((Object)ScriptBytecodeAdapter.castToType((Object)this.credentials.get(), AppengineNamedAccountCredentials.class));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _validateInstances_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstances_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getInstance";
                stringArray[1] = "name";
                stringArray[2] = "region";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[3];
                _validateInstances_closure5.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateInstances_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstances_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Object instances = callSiteArray[54].call((Object)((List)instanceIds2.get()), (Object)new _validateInstances_closure5(this, this, appengineInstanceProvider2, credentials2));
        Reference valid = new Reference((Object)true);
        public final class _validateInstances_closure6
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference instanceIds;
            private /* synthetic */ Reference attribute;
            private /* synthetic */ Reference valid;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _validateInstances_closure6(Object _outerInstance, Object _thisObject, Reference instanceIds, Reference attribute, Reference valid) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _validateInstances_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.instanceIds = reference3 = instanceIds;
                this.attribute = reference2 = attribute;
                this.valid = reference = valid;
            }

            public Object doCall(AppengineInstance instance, int i) {
                CallSite[] callSiteArray = _validateInstances_closure6.$getCallSiteArray();
                Object name = callSiteArray[0].call(this.instanceIds.get(), (Object)i);
                if (!DefaultTypeTransformation.booleanUnbox((Object)instance)) {
                    callSiteArray[1].call(callSiteArray[2].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[3].callGroovyObjectGetProperty((Object)this), this.attribute.get()}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{callSiteArray[4].callGroovyObjectGetProperty((Object)this), this.attribute.get(), name}, new String[]{"", ".", ".invalid (Instance ", " not found)."}));
                    boolean bl = false;
                    this.valid.set((Object)bl);
                    return null;
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].callGroovyObjectGetProperty((Object)instance))) {
                    callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[8].callGroovyObjectGetProperty((Object)this), this.attribute.get()}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{callSiteArray[9].callGroovyObjectGetProperty((Object)this), this.attribute.get(), name}, new String[]{"", ".", ".invalid (Could not find parent server group for instance ", ")."}));
                    boolean bl = false;
                    this.valid.set((Object)bl);
                }
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].callSafe(callSiteArray[11].callGroovyObjectGetProperty((Object)instance), (Object)0))) {
                    callSiteArray[12].call(callSiteArray[13].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{callSiteArray[14].callGroovyObjectGetProperty((Object)this), this.attribute.get()}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{callSiteArray[15].callGroovyObjectGetProperty((Object)this), this.attribute.get(), name}, new String[]{"", ".", ".invalid (Could not find parent load balancer for instance ", ")."}));
                    boolean bl = false;
                    this.valid.set((Object)bl);
                    return bl;
                }
                return null;
            }

            public Object call(AppengineInstance instance, int i) {
                CallSite[] callSiteArray = _validateInstances_closure6.$getCallSiteArray();
                return callSiteArray[16].callCurrent((GroovyObject)this, (Object)instance, (Object)i);
            }

            @Generated
            public List getInstanceIds() {
                CallSite[] callSiteArray = _validateInstances_closure6.$getCallSiteArray();
                return (List)ScriptBytecodeAdapter.castToType((Object)this.instanceIds.get(), List.class);
            }

            @Generated
            public String getAttribute() {
                CallSite[] callSiteArray = _validateInstances_closure6.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.attribute.get());
            }

            @Generated
            public Object getValid() {
                CallSite[] callSiteArray = _validateInstances_closure6.$getCallSiteArray();
                return this.valid.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _validateInstances_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "getAt";
                stringArray[1] = "rejectValue";
                stringArray[2] = "errors";
                stringArray[3] = "context";
                stringArray[4] = "context";
                stringArray[5] = "serverGroup";
                stringArray[6] = "rejectValue";
                stringArray[7] = "errors";
                stringArray[8] = "context";
                stringArray[9] = "context";
                stringArray[10] = "getAt";
                stringArray[11] = "loadBalancers";
                stringArray[12] = "rejectValue";
                stringArray[13] = "errors";
                stringArray[14] = "context";
                stringArray[15] = "context";
                stringArray[16] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[17];
                _validateInstances_closure6.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_validateInstances_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _validateInstances_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[55].call(instances, (Object)new _validateInstances_closure6(this, this, instanceIds2, attribute2, valid));
        return valid.get();
    }

    public Object validateServerGroupCanBeDisabled(String serverGroupName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, AppengineLoadBalancerProvider loadBalancerProvider, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        Object serverGroup = callSiteArray[56].call((Object)clusterProvider, callSiteArray[57].callGroovyObjectGetProperty((Object)credentials), callSiteArray[58].callGroovyObjectGetProperty((Object)credentials), (Object)serverGroupName);
        Boolean valid = true;
        if (!DefaultTypeTransformation.booleanUnbox((Object)serverGroup)) {
            callSiteArray[59].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, serverGroupName}, new String[]{"", ".", ".invalid (Server group ", " not found)."}));
            boolean bl = false;
            valid = bl;
            return valid;
        }
        Object loadBalancerName = callSiteArray[60].callSafe(callSiteArray[61].callGetPropertySafe(serverGroup));
        Object loadBalancer = callSiteArray[62].call((Object)loadBalancerProvider, callSiteArray[63].callGroovyObjectGetProperty((Object)credentials), loadBalancerName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)loadBalancer)) {
            callSiteArray[64].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, loadBalancerName, serverGroupName}, new String[]{"", ".", ".invalid (Could not find parent load balancer ", " for server group ", ")."}));
            boolean bl = false;
            valid = bl;
            return valid;
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[65].callSafe(callSiteArray[66].callGetPropertySafe(callSiteArray[67].callGetPropertySafe(loadBalancer)), (Object)serverGroupName), (Object)((Double)ScriptBytecodeAdapter.asType((Object)1, Double.class)))) {
            callSiteArray[68].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[69].call((Object)new GStringImpl(new Object[]{this.context, attribute, serverGroupName}, new String[]{"", ".", ".invalid (Server group ", " is the only server group "}), (Object)new GStringImpl(new Object[]{loadBalancerName}, new String[]{"receiving traffic from load balancer ", ")."})));
            boolean bl = false;
            valid = bl;
        }
        return valid;
    }

    public Object validateServingStatusCanBeChanged(String serverGroupName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        Object serverGroup = callSiteArray[70].call((Object)clusterProvider, callSiteArray[71].callGroovyObjectGetProperty((Object)credentials), callSiteArray[72].callGroovyObjectGetProperty((Object)credentials), (Object)serverGroupName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)serverGroup)) {
            callSiteArray[73].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute, serverGroupName}, new String[]{"", ".", ".invalid (Server group ", " not found)."}));
            return false;
        }
        Boolean isFlex = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[74].callGetProperty(serverGroup), (Object)callSiteArray[75].callGetProperty(AppengineServerGroup.Environment.class));
        Boolean usesManualScaling = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[76].callGetPropertySafe(callSiteArray[77].callGetProperty(serverGroup)), (Object)callSiteArray[78].callGetProperty(ScalingPolicyType.class));
        Boolean usesBasicScaling = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[79].callGetPropertySafe(callSiteArray[80].callGetProperty(serverGroup)), (Object)callSiteArray[81].callGetProperty(ScalingPolicyType.class));
        if (!(DefaultTypeTransformation.booleanUnbox((Object)isFlex) || DefaultTypeTransformation.booleanUnbox((Object)usesBasicScaling) || DefaultTypeTransformation.booleanUnbox((Object)usesManualScaling))) {
            callSiteArray[82].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[83].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (Only server groups that use the App Engine flexible environment,"}), (Object)" or use basic or manual scaling can be started or stopped)."));
            return false;
        }
        return true;
    }

    public Object validateShardBy(AppengineTrafficSplit split, Boolean migrateTraffic, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)split)) {
            return true;
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)migrateTraffic) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].callCurrent((GroovyObject)this, callSiteArray[85].callGroovyObjectGetProperty((Object)split), (Object)attribute))) {
            callSiteArray[86].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (A shardBy value must be specified for gradual traffic migration)."}));
            return false;
        }
        Object object = callSiteArray[87].callSafe(callSiteArray[88].callSafe(callSiteArray[89].callGroovyObjectGetProperty((Object)split)));
        Object targetNumberOfEnabledServerGroups = DefaultTypeTransformation.booleanUnbox((Object)object) ? object : Integer.valueOf(0);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareGreaterThan((Object)targetNumberOfEnabledServerGroups, (Object)1) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[90].callCurrent((GroovyObject)this, callSiteArray[91].callGroovyObjectGetProperty((Object)split), (Object)attribute))) {
                callSiteArray[92].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[93].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (A shardBy value must be specified if traffic "}), (Object)"will be split between multiple server groups)."));
                return false;
            }
        } else if (ScriptBytecodeAdapter.compareGreaterThan((Object)targetNumberOfEnabledServerGroups, (Object)1) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[94].callCurrent((GroovyObject)this, callSiteArray[95].callGroovyObjectGetProperty((Object)split), (Object)attribute))) {
            callSiteArray[96].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[97].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid (A shardBy value must be specified if traffic "}), (Object)"will be split between multiple server groups)."));
            return false;
        }
        return true;
    }

    public Object validateGradualMigrationIsAllowed(AppengineTrafficSplit split, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[98].callCurrent((GroovyObject)this, callSiteArray[99].callGroovyObjectGetProperty((Object)split), (Object)"split.allocations"))) {
            return false;
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].callGroovyObjectGetProperty((Object)split))), (Object)1)) {
            callSiteArray[103].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[104].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), (Object)"(Cannot gradually migrate traffic to multiple server groups)."));
            return false;
        }
        Object serverGroup = callSiteArray[105].call((Object)clusterProvider, callSiteArray[106].callGroovyObjectGetProperty((Object)credentials), callSiteArray[107].callGroovyObjectGetProperty((Object)credentials), callSiteArray[108].call(callSiteArray[109].call(callSiteArray[110].callGroovyObjectGetProperty((Object)split)), (Object)0));
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[111].callGetProperty(serverGroup))) {
            callSiteArray[112].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[113].call(callSiteArray[114].call(callSiteArray[115].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), (Object)"(Cannot gradually migrate traffic to this server group. "), (Object)"Gradual migration is allowed only for server groups in the App Engine standard "), (Object)"environment that use automatic scaling and have warmup requests enabled)."));
            return false;
        }
        return true;
    }

    public Object validateServerGroupSupportsAutoscalingPolicyUpsert(String serverGroupName, AppengineNamedAccountCredentials credentials, AppengineClusterProvider clusterProvider, String attribute) {
        CallSite[] callSiteArray = StandardAppengineAttributeValidator.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)serverGroupName)) {
            return null;
        }
        Object serverGroup = callSiteArray[116].call((Object)clusterProvider, callSiteArray[117].callGroovyObjectGetProperty((Object)credentials), callSiteArray[118].callGroovyObjectGetProperty((Object)credentials), (Object)serverGroupName);
        if (DefaultTypeTransformation.booleanUnbox((Object)serverGroup)) {
            Boolean isStandard = ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[119].callGetProperty(serverGroup), (Object)callSiteArray[120].callGetProperty(AppengineServerGroup.Environment.class));
            Boolean usesAutomaticScaling = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[121].callGetPropertySafe(callSiteArray[122].callGetProperty(serverGroup)), (Object)callSiteArray[123].callGetProperty(ScalingPolicyType.class));
            if (DefaultTypeTransformation.booleanUnbox((Object)isStandard) && DefaultTypeTransformation.booleanUnbox((Object)usesAutomaticScaling)) {
                return true;
            }
            callSiteArray[124].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[125].call(callSiteArray[126].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".invalid "}), (Object)"(Autoscaling policies can only be updated for "), (Object)"server groups in the App Engine standard environment that use automatic scaling)."));
            return false;
        }
        callSiteArray[127].call((Object)this.errors, (Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ""}), callSiteArray[128].call((Object)new GStringImpl(new Object[]{this.context, attribute}, new String[]{"", ".", ".notFound "}), (Object)new GStringImpl(new Object[]{serverGroupName}, new String[]{"(Cannot find server group ", ".)"})));
        return false;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != StandardAppengineAttributeValidator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        String string = "^[a-z0-9]+$";
        prefixPattern = string;
        String string2 = "^[a-z0-9]+([-a-z0-9]*[a-z0-9])?$";
        namePattern = string2;
    }

    @Generated
    public static Object getNamePattern() {
        return namePattern;
    }

    @Generated
    public static Object getPrefixPattern() {
        return prefixPattern;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public void setContext(String string) {
        this.context = string;
    }

    @Generated
    public ValidationErrors getErrors() {
        return this.errors;
    }

    @Generated
    public void setErrors(ValidationErrors validationErrors) {
        this.errors = validationErrors;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "validateNotEmpty";
        stringArray[1] = "getOne";
        stringArray[2] = "rejectValue";
        stringArray[3] = "validateNotEmpty";
        stringArray[4] = "getSupportedCredentialTypes";
        stringArray[5] = "contains";
        stringArray[6] = "rejectValue";
        stringArray[7] = "plus";
        stringArray[8] = "join";
        stringArray[9] = "rejectValue";
        stringArray[10] = "rejectValue";
        stringArray[11] = "validateNotEmpty";
        stringArray[12] = "validateByRegex";
        stringArray[13] = "validateByRegex";
        stringArray[14] = "validateByRegex";
        stringArray[15] = "rejectValue";
        stringArray[16] = "validateNotEmpty";
        stringArray[17] = "allocations";
        stringArray[18] = "validateAllocations";
        stringArray[19] = "allocations";
        stringArray[20] = "shardBy";
        stringArray[21] = "plus";
        stringArray[22] = "shardBy";
        stringArray[23] = "rejectValue";
        stringArray[24] = "rejectValue";
        stringArray[25] = "rejectValue";
        stringArray[26] = "COOKIE";
        stringArray[27] = "COOKIE_SPLIT_DECIMAL_PLACES";
        stringArray[28] = "IP_SPLIT_DECIMAL_PLACES";
        stringArray[29] = "each";
        stringArray[30] = "size";
        stringArray[31] = "rejectValue";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "join";
        stringArray[35] = "toString";
        stringArray[36] = "round";
        stringArray[37] = "sum";
        stringArray[38] = "collect";
        stringArray[39] = "rejectValue";
        stringArray[40] = "inject";
        stringArray[41] = "withDefault";
        stringArray[42] = "notFound";
        stringArray[43] = "notFound";
        stringArray[44] = "rejectValue";
        stringArray[45] = "size";
        stringArray[46] = "join";
        stringArray[47] = "notRegisteredWithLoadBalancer";
        stringArray[48] = "notRegisteredWithLoadBalancer";
        stringArray[49] = "rejectValue";
        stringArray[50] = "plus";
        stringArray[51] = "size";
        stringArray[52] = "join";
        stringArray[53] = "rejectValue";
        stringArray[54] = "collect";
        stringArray[55] = "eachWithIndex";
        stringArray[56] = "getServerGroup";
        stringArray[57] = "name";
        stringArray[58] = "region";
        stringArray[59] = "rejectValue";
        stringArray[60] = "first";
        stringArray[61] = "loadBalancers";
        stringArray[62] = "getLoadBalancer";
        stringArray[63] = "name";
        stringArray[64] = "rejectValue";
        stringArray[65] = "get";
        stringArray[66] = "allocations";
        stringArray[67] = "split";
        stringArray[68] = "rejectValue";
        stringArray[69] = "plus";
        stringArray[70] = "getServerGroup";
        stringArray[71] = "name";
        stringArray[72] = "region";
        stringArray[73] = "rejectValue";
        stringArray[74] = "env";
        stringArray[75] = "FLEXIBLE";
        stringArray[76] = "type";
        stringArray[77] = "scalingPolicy";
        stringArray[78] = "MANUAL";
        stringArray[79] = "type";
        stringArray[80] = "scalingPolicy";
        stringArray[81] = "BASIC";
        stringArray[82] = "rejectValue";
        stringArray[83] = "plus";
        stringArray[84] = "validateNotEmpty";
        stringArray[85] = "shardBy";
        stringArray[86] = "rejectValue";
        stringArray[87] = "size";
        stringArray[88] = "keySet";
        stringArray[89] = "allocations";
        stringArray[90] = "validateNotEmpty";
        stringArray[91] = "shardBy";
        stringArray[92] = "rejectValue";
        stringArray[93] = "plus";
        stringArray[94] = "validateNotEmpty";
        stringArray[95] = "shardBy";
        stringArray[96] = "rejectValue";
        stringArray[97] = "plus";
        stringArray[98] = "validateNotEmpty";
        stringArray[99] = "allocations";
        stringArray[100] = "size";
        stringArray[101] = "keySet";
        stringArray[102] = "allocations";
        stringArray[103] = "rejectValue";
        stringArray[104] = "plus";
        stringArray[105] = "getServerGroup";
        stringArray[106] = "name";
        stringArray[107] = "region";
        stringArray[108] = "getAt";
        stringArray[109] = "keySet";
        stringArray[110] = "allocations";
        stringArray[111] = "allowsGradualTrafficMigration";
        stringArray[112] = "rejectValue";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
        stringArray[115] = "plus";
        stringArray[116] = "getServerGroup";
        stringArray[117] = "name";
        stringArray[118] = "region";
        stringArray[119] = "env";
        stringArray[120] = "FLEXIBLE";
        stringArray[121] = "type";
        stringArray[122] = "scalingPolicy";
        stringArray[123] = "AUTOMATIC";
        stringArray[124] = "rejectValue";
        stringArray[125] = "plus";
        stringArray[126] = "plus";
        stringArray[127] = "rejectValue";
        stringArray[128] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[129];
        StandardAppengineAttributeValidator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(StandardAppengineAttributeValidator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = StandardAppengineAttributeValidator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

